/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fcg;

import com.ibm.fcg.FcgClassReferenceType;
import com.ibm.fcg.FcgCodeGen;
import com.ibm.fcg.FcgType;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;

public class FcgTypeUtils {
    private static HashMap s_predefinedMap = new HashMap();

    public static FcgType getFcgType(FcgCodeGen fcgCodeGen, Class clazz) {
        FcgType fcgType;
        if (clazz.isArray()) {
            FcgType fcgType2 = FcgTypeUtils.getFcgType(fcgCodeGen, clazz.getComponentType());
            fcgType = fcgCodeGen.getArrayType(fcgType2);
        } else {
            String string = clazz.getName();
            fcgType = (FcgType)s_predefinedMap.get(string);
            if (fcgType == null) {
                string = FcgTypeUtils.fixupInnerClassName(fcgCodeGen, string);
                fcgType = clazz.isInterface() ? fcgCodeGen.getInterfaceType(string) : fcgCodeGen.getClassReferenceType(string);
            }
        }
        return fcgType;
    }

    private static String fixupInnerClassName(FcgCodeGen fcgCodeGen, String string) {
        int n = string.indexOf(36);
        if (n > 0) {
            String string2 = string.substring(0, n);
            String string3 = FcgTypeUtils.fixupInnerClassName(fcgCodeGen, string.substring(n + 1, string.length()));
            FcgClassReferenceType fcgClassReferenceType = fcgCodeGen.getInnerClassReferenceType(string2, string3);
            string = fcgClassReferenceType.getTypeName();
        }
        return string;
    }

    static {
        s_predefinedMap.put("boolean", FcgType.BOOLEAN);
        s_predefinedMap.put("byte", FcgType.BYTE);
        s_predefinedMap.put("char", FcgType.CHAR);
        s_predefinedMap.put("short", FcgType.SHORT);
        s_predefinedMap.put("int", FcgType.INT);
        s_predefinedMap.put("long", FcgType.LONG);
        s_predefinedMap.put("float", FcgType.FLOAT);
        s_predefinedMap.put("double", FcgType.DOUBLE);
        s_predefinedMap.put("[Z", FcgType.BOOLEAN_ARRAY);
        s_predefinedMap.put("[B", FcgType.BYTE_ARRAY);
        s_predefinedMap.put("[C", FcgType.CHAR_ARRAY);
        s_predefinedMap.put("[S", FcgType.SHORT_ARRAY);
        s_predefinedMap.put("[I", FcgType.INT_ARRAY);
        s_predefinedMap.put("[J", FcgType.LONG_ARRAY);
        s_predefinedMap.put("[F", FcgType.FLOAT_ARRAY);
        s_predefinedMap.put("[D", FcgType.DOUBLE_ARRAY);
        s_predefinedMap.put(String.class.getName(), FcgType.STRING);
        s_predefinedMap.put(Array.newInstance(String.class, 1).getClass().getName(), FcgType.STRING_ARRAY);
        s_predefinedMap.put(StringBuffer.class.getName(), FcgType.STRINGBUFFER);
        s_predefinedMap.put(Object.class.getName(), FcgType.OBJECT);
        s_predefinedMap.put(Array.newInstance(Object.class, 1).getClass().getName(), FcgType.OBJECT_ARRAY);
        s_predefinedMap.put(BigDecimal.class.getName(), FcgType.BIG_DECIMAL);
        s_predefinedMap.put(BigInteger.class.getName(), FcgType.BIG_INTEGER);
    }
}

