/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.security.thread;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.security.thread.J2CIdentityService;
import com.ibm.ws.kernel.security.thread.ThreadIdentityException;
import com.ibm.wsspi.kernel.security.thread.ThreadIdentityService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;

public class ThreadIdentityManager {
    private static final TraceComponent tc = Tr.register(ThreadIdentityManager.class, (String)"Security");
    private static final String thisClass = ThreadIdentityManager.class.getName();
    private static final ThreadLocal<Boolean> recursionMarker = new ThreadLocal<Boolean>(){

        @Override
        @Trivial
        protected synchronized Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private static List<ThreadIdentityService> threadIdentityServices = Collections.synchronizedList(new ArrayList());
    private static List<J2CIdentityService> j2cIdentityServices = Collections.synchronizedList(new ArrayList());

    public static void addThreadIdentityService(ThreadIdentityService tis) {
        if (tis != null) {
            threadIdentityServices.add(tis);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"A ThreadIdentityService implementation was added.", (Object[])new Object[]{tis.getClass().getName()});
            }
        }
    }

    public static void addJ2CIdentityService(J2CIdentityService j2cIdentityService) {
        if (j2cIdentityService != null) {
            j2cIdentityServices.add(j2cIdentityService);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"A J2CIdentityService implementation was added.", (Object[])new Object[]{j2cIdentityService.getClass().getName()});
            }
        }
    }

    public static void removeThreadIdentityService(ThreadIdentityService tis) {
        if (tis != null) {
            threadIdentityServices.remove(tis);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"A ThreadIdentityService implementation was removed.", (Object[])new Object[]{tis.getClass().getName()});
            }
        }
    }

    public static void removeJ2CIdentityService(J2CIdentityService j2cIdentityService) {
        if (j2cIdentityService != null) {
            j2cIdentityServices.remove(j2cIdentityService);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"A J2CIdentityService implementation was removed.", (Object[])new Object[]{j2cIdentityService.getClass().getName()});
            }
        }
    }

    public static void removeAllThreadIdentityServices() {
        threadIdentityServices.clear();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"All the ThreadIdentityService implementations were removed.", (Object[])new Object[0]);
        }
    }

    public static void removeAllJ2CIdentityServices() {
        j2cIdentityServices.clear();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"All the J2CIdentityService implementations were removed.", (Object[])new Object[0]);
        }
    }

    public static boolean isThreadIdentityEnabled() {
        return ThreadIdentityManager.isAppThreadIdentityEnabled() || ThreadIdentityManager.isJ2CThreadIdentityEnabled();
    }

    public static boolean isAppThreadIdentityEnabled() {
        for (ThreadIdentityService tis : threadIdentityServices) {
            if (!tis.isAppThreadIdentityEnabled()) continue;
            return true;
        }
        return false;
    }

    public static boolean isJ2CThreadIdentityEnabled() {
        for (J2CIdentityService j2cIdentityService : j2cIdentityServices) {
            if (!j2cIdentityService.isJ2CThreadIdentityEnabled()) continue;
            return true;
        }
        return false;
    }

    public static Object setJ2CThreadIdentity(Subject subject) throws ThreadIdentityException {
        LinkedHashMap<J2CIdentityService, Object> token = new LinkedHashMap<J2CIdentityService, Object>();
        for (J2CIdentityService j2cIdentityService : j2cIdentityServices) {
            if (!j2cIdentityService.isJ2CThreadIdentityEnabled()) continue;
            ThreadIdentityManager.tryToSetJ2CIdentity(token, j2cIdentityService, subject);
        }
        if (!token.isEmpty()) {
            return token;
        }
        return null;
    }

    public static Object setAppThreadIdentity(Subject subject) throws ThreadIdentityException {
        LinkedHashMap<ThreadIdentityService, Object> token = new LinkedHashMap<ThreadIdentityService, Object>();
        for (ThreadIdentityService tis : threadIdentityServices) {
            if (!tis.isAppThreadIdentityEnabled()) continue;
            ThreadIdentityManager.tryToSetIdentity(token, tis, subject);
        }
        if (!token.isEmpty()) {
            return token;
        }
        return null;
    }

    private static void tryToSetIdentity(LinkedHashMap<ThreadIdentityService, Object> token, ThreadIdentityService tis, Subject subject) throws ThreadIdentityException {
        try {
            Object tokenReturnedFromSet = tis.set(subject);
            if (tokenReturnedFromSet != null) {
                token.put(tis, tokenReturnedFromSet);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)thisClass, (String)"251");
            ThreadIdentityManager.resetCheckedInternal(token, e);
        }
    }

    private static void tryToSetJ2CIdentity(LinkedHashMap<J2CIdentityService, Object> token, J2CIdentityService j2cIdentityService, Subject subject) throws ThreadIdentityException {
        try {
            Object tokenReturnedFromSet = j2cIdentityService.set(subject);
            if (tokenReturnedFromSet != null) {
                token.put(j2cIdentityService, tokenReturnedFromSet);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)thisClass, (String)"272");
            ThreadIdentityManager.resetCheckedInternal(token, e);
        }
    }

    private static boolean checkForRecursionAndSet() {
        if (recursionMarker.get() == Boolean.FALSE) {
            recursionMarker.set(Boolean.TRUE);
            return false;
        }
        return true;
    }

    private static void resetRecursionCheck() {
        recursionMarker.set(Boolean.FALSE);
    }

    public static Object runAsServer() {
        LinkedHashMap<ThreadIdentityService, Object> token = new LinkedHashMap<ThreadIdentityService, Object>();
        if (!ThreadIdentityManager.checkForRecursionAndSet()) {
            try {
                for (ThreadIdentityService tis : threadIdentityServices) {
                    if (!tis.isAppThreadIdentityEnabled()) continue;
                    token.put(tis, tis.runAsServer());
                }
            }
            finally {
                ThreadIdentityManager.resetRecursionCheck();
            }
        }
        return token;
    }

    public static void resetChecked(Object token) throws ThreadIdentityException {
        ThreadIdentityManager.resetCheckedInternal(token, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resetCheckedInternal(Object token, Exception firstException) throws ThreadIdentityException {
        Exception cachedException = firstException;
        if (!(threadIdentityServices.isEmpty() && j2cIdentityServices.isEmpty() || ThreadIdentityManager.checkForRecursionAndSet())) {
            try {
                int lastIdx;
                ArrayList identityServicesToTokensMap = new ArrayList(((LinkedHashMap)token).entrySet());
                for (int idx = lastIdx = identityServicesToTokensMap.size() - 1; idx >= 0; --idx) {
                    Map.Entry entry = (Map.Entry)identityServicesToTokensMap.get(idx);
                    Object identityService = entry.getKey();
                    Object identityServiceToken = entry.getValue();
                    try {
                        if (identityService instanceof ThreadIdentityService) {
                            ((ThreadIdentityService)identityService).reset(identityServiceToken);
                            continue;
                        }
                        if (!(identityService instanceof J2CIdentityService)) continue;
                        ((J2CIdentityService)identityService).reset(identityServiceToken);
                        continue;
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)thisClass, (String)"385");
                        if (cachedException != null) continue;
                        cachedException = e;
                    }
                }
            }
            finally {
                ThreadIdentityManager.resetRecursionCheck();
                if (cachedException != null) {
                    throw new ThreadIdentityException(cachedException);
                }
            }
        }
    }

    public static Subject getJ2CInvocationSubject() {
        Subject j2cSubject = null;
        for (J2CIdentityService j2cIdentityService : j2cIdentityServices) {
            Subject subject;
            if (!j2cIdentityService.isJ2CThreadIdentityEnabled() || (subject = j2cIdentityService.getJ2CInvocationSubject()) == null) continue;
            j2cSubject = subject;
            break;
        }
        return j2cSubject;
    }

    public static void reset(Object token) {
        try {
            ThreadIdentityManager.resetCheckedInternal(token, null);
        }
        catch (ThreadIdentityException threadIdentityException) {
            // empty catch block
        }
    }
}

