/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.logging.hpel.reader.filters;

import com.ibm.websphere.logging.hpel.reader.LogQueryBean;
import com.ibm.websphere.logging.hpel.reader.LogRecordFilter;
import com.ibm.websphere.logging.hpel.reader.RepositoryLogRecord;
import com.ibm.websphere.logging.hpel.reader.filters.LevelFilter;
import java.util.regex.Pattern;

public class MultipleCriteriaFilter
implements LogRecordFilter {
    private boolean checkDate = false;
    private LevelFilter levelFilter = null;
    private Pattern[] includeLoggers;
    private Pattern[] excludeLoggers;
    private int[] threadIDs;
    private Pattern[] messageContent;
    private long endDate;
    private long startDate;

    public MultipleCriteriaFilter(LogQueryBean logQueryBean) {
        if (logQueryBean.getMinTime() != null || logQueryBean.getMaxTime() != null) {
            this.checkDate = true;
            this.startDate = logQueryBean.getMinTime() != null ? logQueryBean.getMinTime().getTime() : 0L;
            long l = this.endDate = logQueryBean.getMaxTime() != null ? logQueryBean.getMaxTime().getTime() : Long.MAX_VALUE;
        }
        if (logQueryBean.getMinLevel() != null || logQueryBean.getMaxLevel() != null) {
            this.levelFilter = new LevelFilter(logQueryBean.getMinLevel(), logQueryBean.getMaxLevel());
        }
        if (logQueryBean.getMessageContent() != null) {
            this.messageContent = this.compile(logQueryBean.getMessageContent());
        }
        if (logQueryBean.getIncludeLoggers() != null) {
            this.includeLoggers = this.compile(logQueryBean.getIncludeLoggers());
        }
        if (logQueryBean.getExcludeLoggers() != null) {
            this.excludeLoggers = this.compile(logQueryBean.getExcludeLoggers());
        }
        this.threadIDs = logQueryBean.getThreadIDs();
    }

    private Pattern[] compile(String[] patterns) {
        Pattern[] result = null;
        if (patterns != null) {
            result = new Pattern[patterns.length];
            for (int i = 0; i < patterns.length; ++i) {
                result[i] = LogQueryBean.compile(patterns[i]);
            }
        }
        return result;
    }

    @Override
    public boolean accept(RepositoryLogRecord record) {
        if (this.checkDate && (record.getMillis() > this.endDate || this.startDate > record.getMillis())) {
            return false;
        }
        if (this.levelFilter != null && !this.levelFilter.accept(record)) {
            return false;
        }
        if (this.messageContent != null) {
            String string = record.getFormattedMessage() != null ? record.getFormattedMessage() : record.getRawMessage();
            boolean match = false;
            Pattern[] patternArray = this.messageContent;
            int n = patternArray.length;
            for (int i = 0; i < n; ++i) {
                Pattern pattern = patternArray[i];
                if (!pattern.matcher(string).find()) continue;
                match = true;
                break;
            }
            if (!match) {
                return false;
            }
        }
        if (this.includeLoggers != null) {
            boolean bl;
            boolean bl2 = false;
            for (Pattern incLogger : this.includeLoggers) {
                if (!incLogger.matcher(record.getLoggerName()).find()) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return false;
            }
        }
        if (this.excludeLoggers != null) {
            for (Pattern excLogger : this.excludeLoggers) {
                if (!excLogger.matcher(record.getLoggerName()).find()) continue;
                return false;
            }
        }
        if (this.threadIDs != null) {
            for (int hexThread : this.threadIDs) {
                if (hexThread != record.getThreadID()) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

