/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.timing.probeExtensionImpl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.request.timing.config.SlowRequestTimingConfig;
import com.ibm.ws.request.timing.manager.ProbationaryRequestManager;
import com.ibm.ws.request.timing.manager.SlowRequestManager;
import com.ibm.ws.request.timing.queue.DelayedRequestQueue;
import com.ibm.ws.request.timing.queue.SlowRequest;
import com.ibm.wsspi.probeExtension.ProbeExtension;
import com.ibm.wsspi.requestContext.Event;
import com.ibm.wsspi.requestContext.RequestContext;
import java.util.List;

public class SlowRequestProbeExtension
implements ProbeExtension {
    private static final TraceComponent tc = Tr.register(SlowRequestProbeExtension.class);
    private volatile SlowRequestTimingConfig config = new SlowRequestTimingConfig();
    private final DelayedRequestQueue<SlowRequest> requestQueue = new DelayedRequestQueue();
    private final ProbationaryRequestManager<SlowRequestTimingConfig, SlowRequest> probSlowReqMgr = new ProbationaryRequestManager<SlowRequestTimingConfig, SlowRequest>(this.config, this.requestQueue, SlowRequest.class);
    private final SlowRequestManager slowReqMgr = new SlowRequestManager(this.requestQueue);
    private volatile boolean hasStopped = false;

    public void processEntryEvent(Event event, RequestContext requestContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processEntryEvent " + event), (Object[])new Object[0]);
        }
        if (!this.hasStopped) {
            this.probSlowReqMgr.setLastRequestTime(System.nanoTime());
            this.probSlowReqMgr.startTimer();
            this.slowReqMgr.startHandler();
        }
    }

    public void processExitEvent(Event event, RequestContext requestContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processExitEvent " + event), (Object[])new Object[0]);
        }
        if (!this.hasStopped) {
            // empty if block
        }
    }

    public void setConfig(SlowRequestTimingConfig config) {
        this.config = config;
        this.probSlowReqMgr.setConfig(config);
    }

    public void updateConfig(SlowRequestTimingConfig config) {
        this.config = config;
        this.probSlowReqMgr.resetTimer(this.config);
    }

    public void stop() {
        this.hasStopped = true;
        this.probSlowReqMgr.stopTimer();
        this.slowReqMgr.stopHandler();
        this.requestQueue.clear();
    }

    public void processCounter(Event event) {
    }

    public boolean invokeForRootEventsOnly() {
        return true;
    }

    public List<String> invokeForEventTypes() {
        return null;
    }

    public boolean invokeForEventEntry() {
        return true;
    }

    public boolean invokeForEventExit() {
        return true;
    }

    public boolean invokeForCounter() {
        return false;
    }

    public int getRequestSampleRate() {
        return this.config.getSampleRate();
    }

    public int getContextInfoRequirement() {
        return this.config.getContextInfoRequirement();
    }
}

