/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.timing.config;

import com.ibm.ws.request.timing.config.ContextInfoPattern;
import com.ibm.ws.request.timing.config.RequestTimingConfig;
import com.ibm.ws.request.timing.config.Timing;
import com.ibm.wsspi.requestContext.Event;
import com.ibm.wsspi.requestContext.RequestContext;
import java.io.PrintWriter;
import java.util.Map;

public class HungRequestTimingConfig
extends RequestTimingConfig {
    private final boolean keepStatistics;

    public HungRequestTimingConfig(int contextInfoRequirement, Map<String, Map<ContextInfoPattern, Timing>> hungRequestTiming) {
        super(1, contextInfoRequirement, hungRequestTiming);
        this.keepStatistics = this.countTimingConfigs() > 1;
    }

    public HungRequestTimingConfig() {
        this.keepStatistics = false;
    }

    public void incrementTimingConfigForRequest(RequestContext requestContext) {
        if (this.keepStatistics) {
            Event rootEvent = requestContext.getRootEvent();
            String requestType = rootEvent.getType();
            Object contextInfoObj = rootEvent.getContextInfo();
            String contextInfo = contextInfoObj != null ? contextInfoObj.toString() : null;
            Timing bestMatch = this.getTiming(requestType, contextInfo);
            bestMatch.incrementCount(contextInfo);
        }
    }

    public void writeIntrospectionData(PrintWriter pw) {
        if (this.keepStatistics) {
            Map<String, Map<ContextInfoPattern, Timing>> timingConfig = this.getRequestTiming();
            if (timingConfig != null) {
                for (String type : timingConfig.keySet()) {
                    pw.println("Type " + type + ":");
                    Map<ContextInfoPattern, Timing> typeConfig = timingConfig.get(type);
                    for (ContextInfoPattern contextInfo : typeConfig.keySet()) {
                        Timing curTiming = typeConfig.get(contextInfo);
                        curTiming.writeIntrospectionData(pw);
                    }
                }
                pw.println("End of requestTiming-1.0 output");
            } else {
                pw.println("requestTiming-1.0 cannot print statistics because the timing config was null.");
            }
        } else {
            pw.println("requestTiming-1.0 is not keeping timing statistics since there are no <timing/> elements in the configuration");
        }
    }

    private int countTimingConfigs() {
        int configCount = 0;
        Map<String, Map<ContextInfoPattern, Timing>> config = this.getRequestTiming();
        if (config != null) {
            for (Map<ContextInfoPattern, Timing> typeConfig : config.values()) {
                configCount += typeConfig.size();
            }
        }
        return configCount;
    }

    public String toString() {
        StringBuffer hungReqTimingCfg = new StringBuffer();
        hungReqTimingCfg.append(String.format("%n", new Object[0]));
        hungReqTimingCfg.append("-------------------Hung Request Timing Settings-------------------" + String.format("%n", new Object[0]));
        hungReqTimingCfg.append("Sample rate: " + this.getSampleRate() + String.format("%n", new Object[0]));
        hungReqTimingCfg.append("Context info requirement: " + this.getContextInfoRequirement() + String.format("%n", new Object[0]));
        hungReqTimingCfg.append("-------------------Type Settings-------------------" + String.format("%n", new Object[0]));
        for (Map<ContextInfoPattern, Timing> typeMap : this.getRequestTiming().values()) {
            for (ContextInfoPattern contextInfoPattern : typeMap.keySet()) {
                Timing t = typeMap.get(contextInfoPattern);
                hungReqTimingCfg.append(t.getType() + ": " + contextInfoPattern + ": Request threshold (ms) - " + t.getRequestThreshold() + String.format("%n", new Object[0]));
            }
        }
        hungReqTimingCfg.append("-------------------------------------------------------------");
        return hungReqTimingCfg.toString();
    }
}

