/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.timing;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.LibertyProcess;
import com.ibm.ws.request.timing.config.ContextInfoPattern;
import com.ibm.ws.request.timing.config.HungRequestTimingConfig;
import com.ibm.ws.request.timing.config.SlowRequestTimingConfig;
import com.ibm.ws.request.timing.config.Timing;
import com.ibm.ws.request.timing.notification.HungRequestNotification;
import com.ibm.ws.request.timing.probeExtensionImpl.HungRequestProbeExtension;
import com.ibm.ws.request.timing.probeExtensionImpl.SlowRequestProbeExtension;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

public class RequestTimingService {
    private static final TraceComponent tc = Tr.register(RequestTimingService.class);
    private volatile ConfigurationAdmin configAdmin = null;
    private volatile SlowRequestProbeExtension slowRequestProbeExt = null;
    private volatile HungRequestProbeExtension hungRequestProbeExt = null;
    private static volatile ScheduledExecutorService scheduledExecSrvc = null;
    private static volatile ExecutorService executorSrvc = null;
    private static volatile LibertyProcess libertyProcess = null;
    private static volatile List<HungRequestNotification> hungRequestNotifications = Collections.unmodifiableList(new ArrayList());

    @Activate
    protected void activate(Map<String, Object> configuration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Activating " + this), (Object[])new Object[0]);
        }
        this.configureService(configuration, false);
    }

    @Modified
    protected void modified(Map<String, Object> configuration) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(" Modified " + this), (Object[])new Object[0]);
        }
        this.configureService(configuration, true);
    }

    @Deactivate
    protected void deactivate(int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)(" Deactivating " + this), (Object[])new Object[]{" reason = " + reason});
        }
        this.slowRequestProbeExt.stop();
        this.hungRequestProbeExt.stop();
        hungRequestNotifications = Collections.unmodifiableList(new ArrayList());
    }

    protected void setConfigurationAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    protected void unsetConfigurationAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = null;
    }

    protected void setScheduledExecutor(ScheduledExecutorService scheduledExecSrvc) {
        RequestTimingService.scheduledExecSrvc = scheduledExecSrvc;
    }

    protected void unsetScheduledExecutor(ScheduledExecutorService scheduledExecSrvc) {
        RequestTimingService.scheduledExecSrvc = null;
    }

    protected void setExecutor(ExecutorService executorSrvc) {
        RequestTimingService.executorSrvc = executorSrvc;
    }

    protected void unsetExecutor(ExecutorService executorSrvc) {
        RequestTimingService.executorSrvc = null;
    }

    protected void setLibertyProcess(LibertyProcess libertyProcess) {
        RequestTimingService.libertyProcess = libertyProcess;
    }

    protected void unsetLibertyProcess(LibertyProcess libertyProcess) {
        RequestTimingService.libertyProcess = null;
    }

    protected void setSlowRequestProbeExt(SlowRequestProbeExtension probeExt) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Setting probe extension : " + probeExt.getClass().getName()), (Object[])new Object[0]);
        }
        this.slowRequestProbeExt = probeExt;
    }

    protected void unsetSlowRequestProbeExt(SlowRequestProbeExtension probeExt) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Unsetting probe extension : " + probeExt.getClass().getName()), (Object[])new Object[0]);
        }
        this.slowRequestProbeExt = null;
    }

    protected void setHungRequestProbeExt(HungRequestProbeExtension probeExt) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Setting probe extension : " + probeExt.getClass().getName()), (Object[])new Object[0]);
        }
        this.hungRequestProbeExt = probeExt;
    }

    protected void unsetHungRequestProbeExt(HungRequestProbeExtension probeExt) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Unsetting probe extension : " + probeExt.getClass().getName()), (Object[])new Object[0]);
        }
        this.hungRequestProbeExt = null;
    }

    public synchronized void setHungRequestNotification(HungRequestNotification hungRequestNotification) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Setting the hung request notification into list", (Object[])new Object[]{hungRequestNotification.getClass()});
        }
        ArrayList<HungRequestNotification> notifications = new ArrayList<HungRequestNotification>(hungRequestNotifications);
        notifications.add(hungRequestNotification);
        hungRequestNotifications = Collections.unmodifiableList(notifications);
    }

    public synchronized void unsetHungRequestNotification(HungRequestNotification hungRequestNotification) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Removing hung request notification from list", (Object[])new Object[]{hungRequestNotification.getClass()});
        }
        ArrayList<HungRequestNotification> notifications = new ArrayList<HungRequestNotification>(hungRequestNotifications);
        notifications.remove(hungRequestNotification);
        hungRequestNotifications = Collections.unmodifiableList(notifications);
    }

    private void configureService(Map<String, Object> configuration, boolean modified) {
        long slowRequestThreshold = 10000L;
        long hungRequestThreshold = 600000L;
        int sampleRate = 1;
        int contextInfoRequirement = 0;
        HashMap<String, Map<ContextInfoPattern, Timing>> slowRequestTiming = new HashMap<String, Map<ContextInfoPattern, Timing>>();
        HashMap<String, Map<ContextInfoPattern, Timing>> hungRequestTiming = new HashMap<String, Map<ContextInfoPattern, Timing>>();
        if (configuration.containsKey("sampleRate") && (sampleRate = Integer.parseInt(configuration.get("sampleRate").toString())) < 1) {
            sampleRate = 1;
        }
        if (configuration.containsKey("includeContextInfo")) {
            boolean includeContextInfo = Boolean.parseBoolean(configuration.get("includeContextInfo").toString());
            contextInfoRequirement = includeContextInfo ? 0 : 2;
        }
        if (configuration.containsKey("slowRequestThreshold")) {
            slowRequestThreshold = Long.parseLong(configuration.get("slowRequestThreshold").toString());
        }
        if (configuration.containsKey("hungRequestThreshold")) {
            hungRequestThreshold = Long.parseLong(configuration.get("hungRequestThreshold").toString());
        }
        this.addToTimingSet(null, slowRequestTiming, "all", ContextInfoPattern.ALL, slowRequestThreshold);
        this.addToTimingSet(null, hungRequestTiming, "all", ContextInfoPattern.ALL, hungRequestThreshold);
        Configuration config = null;
        String[] timingPids = (String[])configuration.get("timing");
        if (timingPids != null && this.configAdmin != null) {
            for (String timingPid : timingPids) {
                try {
                    config = this.configAdmin.getConfiguration(timingPid);
                    Dictionary configElement = config != null ? config.getProperties() : null;
                    long typeSlowReqThreshold = 0L;
                    long typeHungReqThreshold = 0L;
                    String type = "UNDEFINED";
                    ContextInfoPattern contextInfoPattern = null;
                    if (configElement == null) {
                        Tr.error((TraceComponent)tc, (String)"REQUEST_TIMING_CONFIG_ERROR1", (Object[])new Object[]{timingPid});
                        continue;
                    }
                    typeSlowReqThreshold = configElement.get("slowRequestThreshold") != null ? MetatypeUtils.evaluateDuration((String)((String)configElement.get("slowRequestThreshold")), (TimeUnit)TimeUnit.MILLISECONDS) : slowRequestThreshold;
                    typeHungReqThreshold = configElement.get("hungRequestThreshold") != null ? MetatypeUtils.evaluateDuration((String)((String)configElement.get("hungRequestThreshold")), (TimeUnit)TimeUnit.MILLISECONDS) : hungRequestThreshold;
                    if (configElement.get("eventType") != null) {
                        type = configElement.get("eventType").toString();
                    }
                    if (configElement.get("contextInfoPattern") != null) {
                        String contextInfoPatternString = configElement.get("contextInfoPattern").toString();
                        if (contextInfoRequirement != 0) {
                            Tr.warning((TraceComponent)tc, (String)"REQUEST_TIMING_CONFIG_WARNING_CTX_INFO_PATTERN", (Object[])new Object[]{timingPid});
                        }
                        contextInfoPattern = new ContextInfoPattern(timingPid, contextInfoPatternString);
                    } else {
                        contextInfoPattern = ContextInfoPattern.ALL;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Nested timing element found", (Object[])new Object[]{contextInfoPattern, typeSlowReqThreshold, typeHungReqThreshold});
                    }
                    this.addToTimingSet(timingPid, slowRequestTiming, type, contextInfoPattern, typeSlowReqThreshold);
                    this.addToTimingSet(timingPid, hungRequestTiming, type, contextInfoPattern, typeHungReqThreshold);
                }
                catch (Exception e) {
                    Object[] objs = new Object[]{this, timingPid};
                    FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"280", (Object[])objs);
                }
            }
        }
        SlowRequestTimingConfig slowReqTimingConfig = new SlowRequestTimingConfig(sampleRate, contextInfoRequirement, this.makeReadOnlyMap(slowRequestTiming));
        HungRequestTimingConfig hungReqTimingConfig = new HungRequestTimingConfig(contextInfoRequirement, this.makeReadOnlyMap(hungRequestTiming));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Request timing configuration", (Object[])new Object[]{slowReqTimingConfig, hungReqTimingConfig});
        }
        if (modified) {
            this.slowRequestProbeExt.updateConfig(slowReqTimingConfig);
            this.hungRequestProbeExt.updateConfig(hungReqTimingConfig);
        } else {
            this.slowRequestProbeExt.setConfig(slowReqTimingConfig);
            this.hungRequestProbeExt.setConfig(hungReqTimingConfig);
        }
    }

    private Map<String, Map<ContextInfoPattern, Timing>> makeReadOnlyMap(Map<String, Map<ContextInfoPattern, Timing>> timingsMap) {
        HashMap<String, Map<ContextInfoPattern, Timing>> tempMap = new HashMap<String, Map<ContextInfoPattern, Timing>>(timingsMap.size());
        for (String type : timingsMap.keySet()) {
            tempMap.put(type, Collections.unmodifiableMap(timingsMap.get(type)));
        }
        return Collections.unmodifiableMap(tempMap);
    }

    private void addToTimingSet(String timingPid, Map<String, Map<ContextInfoPattern, Timing>> requestTimingMap, String type, ContextInfoPattern contextInfoPattern, long requestThreshold) {
        if (requestTimingMap.containsKey(type)) {
            Map<ContextInfoPattern, Timing> timingForType = requestTimingMap.get(type);
            if (timingForType.put(contextInfoPattern, new Timing(type, contextInfoPattern, requestThreshold)) != null) {
                Tr.warning((TraceComponent)tc, (String)"REQUEST_TIMING_CONFIG_WARNING_DUPLICATE", (Object[])new Object[]{type, contextInfoPattern, timingPid});
            }
        } else {
            TreeMap<ContextInfoPattern, Timing> timingForType = new TreeMap<ContextInfoPattern, Timing>();
            timingForType.put(contextInfoPattern, new Timing(type, contextInfoPattern, requestThreshold));
            requestTimingMap.put(type, timingForType);
        }
    }

    public static ScheduledExecutorService getScheduledExecutorService() {
        return scheduledExecSrvc;
    }

    public static ExecutorService getExecutorService() {
        return executorSrvc;
    }

    public static LibertyProcess getLibertyProcess() {
        return libertyProcess;
    }

    public static List<HungRequestNotification> getHungRequestNotifications() {
        return hungRequestNotifications;
    }

    public static void processAllHungRequestNotifications(String requestId, long threadId) {
        List<HungRequestNotification> hungRequestNotificationList = RequestTimingService.getHungRequestNotifications();
        for (int i = 0; i < hungRequestNotificationList.size(); ++i) {
            HungRequestNotification hungRequestNotification = hungRequestNotificationList.get(i);
            hungRequestNotification.hungRequestDetected(requestId, threadId);
        }
    }
}

