/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jndi.iiop;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jndi.WSContextBase;
import com.ibm.ws.jndi.WSName;
import com.ibm.ws.jndi.WSNameUtil;
import com.ibm.ws.jndi.iiop.CosNameUtil;
import com.ibm.ws.jndi.iiop.MessageUtil;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.net.URI;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.SchemaViolationException;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public final class JndiCosNamingContext
extends WSContextBase
implements Context {
    final URI rootUrl;
    final NamingContext cosCtx;
    final WSName subname;
    final Hashtable<?, ?> env;
    static final long serialVersionUID = 8410238679034086409L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    static String getProviderUri(Hashtable<?, ?> env) throws ConfigurationException {
        try {
            return (String)env.get("java.naming.provider.url");
        }
        catch (ClassCastException classCastException) {
            void e;
            FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.jndi.iiop.JndiCosNamingContext", (String)"62", null, (java.lang.Object[])new java.lang.Object[]{env});
            throw (ConfigurationException)new ConfigurationException().initCause((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static URI convertToUri(String uri) throws ConfigurationException {
        try {
            return URI.create(uri);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jndi.iiop.JndiCosNamingContext", (String)"70", null, (java.lang.Object[])new java.lang.Object[]{uri});
            throw (ConfigurationException)new ConfigurationException().initCause((Throwable)e);
        }
    }

    private static NamingContext getCosContext(ORB orb, String url) {
        return NamingContextHelper.narrow((Object)orb.string_to_object(url));
    }

    private static NamingContext duplicateRef(NamingContext cosCtx) {
        return cosCtx instanceof LocalObject ? cosCtx : (NamingContext)PortableRemoteObject.narrow((java.lang.Object)cosCtx._duplicate(), NamingContext.class);
    }

    private JndiCosNamingContext(URI rootUrl, NamingContext cosCtx, WSName subname, Hashtable<?, ?> env) {
        this.rootUrl = rootUrl;
        this.cosCtx = cosCtx;
        this.subname = subname;
        this.env = new Hashtable(env);
    }

    private JndiCosNamingContext(String rootUrl, NamingContext cosCtx, WSName subname, Hashtable<?, ?> env) throws ConfigurationException {
        this(JndiCosNamingContext.convertToUri(rootUrl), cosCtx, subname, env);
    }

    private JndiCosNamingContext(String rootUrl, ORB orb, Hashtable<?, ?> env) throws ConfigurationException {
        this(rootUrl, JndiCosNamingContext.getCosContext(orb, rootUrl), WSName.EMPTY_NAME, env);
    }

    public JndiCosNamingContext(ORB orb, Hashtable<?, ?> env) throws ConfigurationException {
        this(JndiCosNamingContext.getProviderUri(env), orb, env);
    }

    public JndiCosNamingContext(String rootUrl, NamingContext cosCtx, Hashtable<?, ?> env) throws ConfigurationException {
        this(rootUrl, cosCtx, WSName.EMPTY_NAME, env);
    }

    private JndiCosNamingContext(JndiCosNamingContext that) {
        this(that.rootUrl, JndiCosNamingContext.duplicateRef(that.cosCtx), that.subname, that.env);
    }

    private JndiCosNamingContext(JndiCosNamingContext progenitor, NamingContext cosCtx, WSName subname) throws InvalidNameException {
        this(progenitor.rootUrl, cosCtx, progenitor.subname.plus((Name)subname), progenitor.env);
    }

    public String toString() {
        return this.rootUrl + "#" + this.subname;
    }

    @FFDCIgnore(value={NotFound.class, CannotProceed.class, InvalidName.class})
    protected java.lang.Object lookup(WSName name) throws NamingException {
        if (name.isEmpty()) {
            return new JndiCosNamingContext(this);
        }
        NameComponent[] cosName = CosNameUtil.cosify(name);
        try {
            Object result = this.cosCtx.resolve(cosName);
            if (result._is_a(NamingContextHelper.id())) {
                NamingContext cosCtx = NamingContextHelper.unchecked_narrow((Object)result);
                return new JndiCosNamingContext(this, cosCtx, name);
            }
            return result;
        }
        catch (NotFound e) {
            throw CosNameUtil.detailed(new NameNotFoundException(), (Exception)((java.lang.Object)e), e.rest_of_name);
        }
        catch (CannotProceed e) {
            throw CosNameUtil.detailed(new CannotProceedException(), (Exception)((java.lang.Object)e), e.rest_of_name);
        }
        catch (InvalidName e) {
            throw CosNameUtil.detailed(new InvalidNameException(), (Exception)((java.lang.Object)e), new NameComponent[0]);
        }
    }

    protected void bind(WSName name, java.lang.Object obj) throws NamingException {
        this.bind(WSNameUtil.normalize((Name)name), obj, BindOperation.BIND);
    }

    @FFDCIgnore(value={ClassCastException.class, NotFound.class, CannotProceed.class, InvalidName.class, AlreadyBound.class})
    private void bind(WSName name, java.lang.Object obj, BindOperation bindOp) throws NamingException {
        name.ensureNotEmpty();
        NameComponent[] cosName = CosNameUtil.cosify(name);
        try {
            ObjectImpl ref = (ObjectImpl)obj;
            switch (bindOp) {
                case BIND: {
                    this.cosCtx.bind(cosName, (Object)ref);
                    break;
                }
                case REBIND: {
                    this.cosCtx.rebind(cosName, (Object)ref);
                }
            }
        }
        catch (ClassCastException e) {
            String msg = MessageUtil.format("invalid.object", "Object of type {0} is not a valid remote reference.", obj.getClass().getName());
            throw CosNameUtil.detailed(new SchemaViolationException(msg), e, cosName);
        }
        catch (NotFound e) {
            throw CosNameUtil.detailed(new NameNotFoundException(), (Exception)((java.lang.Object)e), e.rest_of_name);
        }
        catch (CannotProceed e) {
            throw CosNameUtil.detailed(new CannotProceedException(), (Exception)((java.lang.Object)e), e.rest_of_name);
        }
        catch (InvalidName e) {
            throw CosNameUtil.detailed(new InvalidNameException(), (Exception)((java.lang.Object)e), new NameComponent[0]);
        }
        catch (AlreadyBound e) {
            throw CosNameUtil.detailed(new NameAlreadyBoundException(), (Exception)((java.lang.Object)e), new NameComponent[0]);
        }
    }

    protected void rebind(WSName name, java.lang.Object obj) throws NamingException {
        this.bind(WSNameUtil.normalize((Name)name), obj, BindOperation.REBIND);
    }

    protected void unbind(WSName name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rename(WSName oldName, WSName newName) throws NamingException {
        throw new OperationNotSupportedException();
    }

    protected NamingEnumeration<NameClassPair> list(WSName name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    protected NamingEnumeration<Binding> listBindings(WSName name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    protected void destroySubcontext(WSName name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    protected Context createSubcontext(WSName name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    protected java.lang.Object lookupLink(WSName name) throws NamingException {
        return null;
    }

    protected NameParser getNameParser(WSName name) throws NamingException {
        return null;
    }

    @Override
    public java.lang.Object addToEnvironment(String propName, java.lang.Object propVal) throws NamingException {
        return null;
    }

    @Override
    public java.lang.Object removeFromEnvironment(String propName) throws NamingException {
        return null;
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return new Hashtable(this.env);
    }

    @Override
    public void close() throws NamingException {
        if (this.cosCtx instanceof LocalObject) {
            return;
        }
        this.cosCtx._release();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rootUrl == null ? 0 : this.rootUrl.hashCode());
        result = 31 * result + (this.subname == null ? 0 : this.subname.hashCode());
        return result;
    }

    public boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JndiCosNamingContext other = (JndiCosNamingContext)obj;
        if (this.rootUrl == null ? other.rootUrl != null : !this.rootUrl.equals(other.rootUrl)) {
            return false;
        }
        return !(this.subname == null ? other.subname != null : !this.subname.equals((java.lang.Object)other.subname));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(JndiCosNamingContext.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class BindOperation
    extends Enum<BindOperation> {
        public static final /* enum */ BindOperation BIND;
        public static final /* enum */ BindOperation REBIND;
        private static final /* synthetic */ BindOperation[] $VALUES;
        static final long serialVersionUID = -8258248142132229974L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static BindOperation[] values() {
            return (BindOperation[])$VALUES.clone();
        }

        public static BindOperation valueOf(String name) {
            return Enum.valueOf(BindOperation.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(BindOperation.class);
            BIND = new BindOperation();
            REBIND = new BindOperation();
            $VALUES = new BindOperation[]{BIND, REBIND};
        }
    }
}

