/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.util;

import org.apache.commons.beanutils.Converter;

public final class EnumerationConverter
implements Converter {
    private static final EnumerationConverter INSTANCE = new EnumerationConverter();

    public static EnumerationConverter getInstance() {
        return INSTANCE;
    }

    private EnumerationConverter() {
    }

    public Object convert(Class type, Object value) {
        if (!type.isEnum()) {
            throw new RuntimeException("Only enum types supported in this version!");
        }
        if (value == null) {
            throw new RuntimeException("Null values not supported in this version!");
        }
        if (String.class != value.getClass()) {
            throw new RuntimeException("Only java.lang.String values supported in this version!");
        }
        String stringValue = (String)value;
        Class enumClass = type;
        return Enum.valueOf(enumClass, stringValue);
    }
}

