/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.metadata.builder;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jaxws.metadata.EndpointInfo;
import com.ibm.ws.jaxws.metadata.EndpointType;
import com.ibm.ws.jaxws.metadata.builder.EndpointInfoBuilderContext;
import com.ibm.ws.jaxws.metadata.builder.EndpointInfoConfigurator;
import com.ibm.ws.jaxws.metadata.builder.WsdlBindingTypeValidationHandler;
import com.ibm.ws.jaxws.utils.JaxWsUtils;
import com.ibm.ws.jaxws.utils.StringUtils;
import com.ibm.ws.jaxws.utils.URLUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class EndpointInfoBuilder {
    private static final TraceComponent tc = Tr.register(EndpointInfoBuilder.class);
    private final Map<EndpointInfoConfigurator.Phase, Set<EndpointInfoConfigurator>> phaseConfigurators = new HashMap<EndpointInfoConfigurator.Phase, Set<EndpointInfoConfigurator>>();
    static final long serialVersionUID = -4887360847499331718L;

    protected void setEndpointInfoConfigurator(EndpointInfoConfigurator configurator) {
        EndpointInfoConfigurator.Phase phase = configurator.getPhase();
        if (!this.phaseConfigurators.containsKey((Object)phase)) {
            CopyOnWriteArraySet<EndpointInfoConfigurator> configurators = new CopyOnWriteArraySet<EndpointInfoConfigurator>();
            configurators.add(configurator);
            this.phaseConfigurators.put(phase, configurators);
        } else {
            Set<EndpointInfoConfigurator> configurators = this.phaseConfigurators.get((Object)phase);
            if (configurators == null) {
                configurators = new CopyOnWriteArraySet<EndpointInfoConfigurator>();
                this.phaseConfigurators.put(phase, configurators);
            }
            configurators.add(configurator);
        }
    }

    protected void unsetEndpointInfoConfigurator(EndpointInfoConfigurator configurator) {
        Set<EndpointInfoConfigurator> configurators;
        EndpointInfoConfigurator.Phase phase = configurator.getPhase();
        if (this.phaseConfigurators.containsKey((Object)phase) && (configurators = this.phaseConfigurators.get((Object)phase)) != null && !configurators.isEmpty()) {
            this.phaseConfigurators.get((Object)phase).remove(configurator);
        }
    }

    public EndpointInfo build(EndpointInfoBuilderContext ctx, String serviceImplBeanClassName, EndpointType endpointType) throws UnableToAdaptException {
        EndpointInfo endpointInfo = new EndpointInfo(serviceImplBeanClassName, endpointType);
        endpointInfo.setBeanName((String)ctx.getContextEnv("endpointBeanNameInEnv"));
        endpointInfo.setServletName((String)ctx.getContextEnv("endpointServletNameInEnv"));
        this.invokeConfigurators(ctx, ConfigMethod.PREPARE, endpointInfo);
        this.invokeConfigurators(ctx, ConfigMethod.CONFIG, endpointInfo);
        this.validate(ctx, endpointInfo);
        ctx.clearContextEnv();
        return endpointInfo;
    }

    private void invokeConfigurators(EndpointInfoBuilderContext ctx, ConfigMethod configMethod, EndpointInfo endpointInfo) throws UnableToAdaptException {
        for (EndpointInfoConfigurator.Phase phase : EndpointInfoConfigurator.Phase.values()) {
            Set<EndpointInfoConfigurator> configurators = this.phaseConfigurators.get((Object)phase);
            if (configurators == null || configurators.isEmpty()) continue;
            for (EndpointInfoConfigurator configurator : configurators) {
                switch (configMethod) {
                    case PREPARE: {
                        configurator.prepare(ctx, endpointInfo);
                        break;
                    }
                    case CONFIG: {
                        configurator.config(ctx, endpointInfo);
                    }
                }
            }
        }
    }

    protected void validate(EndpointInfoBuilderContext ctx, EndpointInfo endpointInfo) {
        String wsdlLocation = endpointInfo.getWsdlLocation();
        if (!StringUtils.isEmpty(wsdlLocation)) {
            if (URLUtils.isAbsolutePath(wsdlLocation)) {
                Tr.warning((TraceComponent)tc, (String)"warn.endpoint.absolute.wsdllocation", (Object[])new Object[]{endpointInfo.getImplBeanClassName(), wsdlLocation});
            } else {
                String bindingType = endpointInfo.getProtocolBinding();
                String portComponentName = endpointInfo.getPortComponentName();
                this.validateWsdlAgainstBindingType(ctx, bindingType, wsdlLocation, portComponentName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={IOException.class, ParserConfigurationException.class, SAXException.class})
    private void validateWsdlAgainstBindingType(EndpointInfoBuilderContext ctx, String bindingType, String wsdlLocation, String portComponentName) {
        URL wsdlUrl;
        if (bindingType != null && !bindingType.isEmpty() && (wsdlUrl = JaxWsUtils.resolve(wsdlLocation, ctx.getContainer())) != null) {
            InputStream wsdlInputStream = null;
            try {
                wsdlInputStream = wsdlUrl.openStream();
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setFeature("http://xml.org/sax/features/namespaces", true);
                factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
                SAXParser parser = factory.newSAXParser();
                WsdlBindingTypeValidationHandler handler = new WsdlBindingTypeValidationHandler(bindingType, wsdlLocation, portComponentName);
                parser.parse(wsdlInputStream, (DefaultHandler)handler);
            }
            catch (IOException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unable to validate wsdl against BindingType due to IOException: {0}", (Object[])new Object[]{e});
                }
            }
            catch (ParserConfigurationException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unable to validate wsdl against BindingType due to ParserConfigurationException: {0}", (Object[])new Object[]{e});
                }
            }
            catch (SAXException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unable to validate wsdl against BindingType due to SAXException: {0}", (Object[])new Object[]{e});
                }
            }
            finally {
                if (wsdlInputStream != null) {
                    try {
                        wsdlInputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class ConfigMethod
    extends Enum<ConfigMethod> {
        public static final /* enum */ ConfigMethod PREPARE;
        public static final /* enum */ ConfigMethod CONFIG;
        private static final /* synthetic */ ConfigMethod[] $VALUES;
        static final long serialVersionUID = -4913043153593293232L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static ConfigMethod[] values() {
            return (ConfigMethod[])$VALUES.clone();
        }

        public static ConfigMethod valueOf(String name) {
            return Enum.valueOf(ConfigMethod.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ConfigMethod.class);
            PREPARE = new ConfigMethod();
            CONFIG = new ConfigMethod();
            $VALUES = new ConfigMethod[]{PREPARE, CONFIG};
        }
    }
}

