/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.jmx.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jaxws.bus.LibertyApplicationBusListener;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import javax.management.MBeanServer;
import org.apache.cxf.Bus;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JMXBusInitializer
implements LibertyApplicationBusListener {
    private static final TraceComponent tc = Tr.register(JMXBusInitializer.class);
    private final MBeanServer mbs;
    static final long serialVersionUID = -6846373941952679281L;

    public JMXBusInitializer(MBeanServer mbs) {
        this.mbs = mbs;
    }

    @Override
    public void preInit(Bus bus) {
        if (bus == null) {
            return;
        }
        if (this.mbs != null) {
            bus.setProperty("bus.jmx.enabled", (Object)"true");
            bus.setProperty("bus.jmx.usePlatformMBeanServer", (Object)"true");
            bus.setProperty("bus.jmx.createMBServerConnectorFactory", (Object)"false");
            bus.setExtension((Object)this.mbs, MBeanServer.class);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to get MBeanServer reference from PlatformMBeanService service, CXF JMX will be disabled", (Object[])new Object[0]);
            }
            bus.setProperty("bus.jmx.enabled", (Object)"false");
        }
    }

    @Override
    public void initComplete(Bus bus) {
    }

    @Override
    public void preShutdown(Bus bus) {
    }

    @Override
    public void postShutdown(Bus bus) {
    }
}

