/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.globalhandler;

import com.ibm.webservices.handler.impl.GlobalHandlerService;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jaxws.bus.LibertyApplicationBus;
import com.ibm.ws.jaxws.bus.LibertyApplicationBusFactory;
import com.ibm.ws.jaxws.bus.LibertyApplicationBusListener;
import com.ibm.ws.jaxws.globalhandler.GlobalHandlerEntryOutInterceptor;
import com.ibm.ws.jaxws.globalhandler.GlobalHandlerInterceptor;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.Map;
import org.apache.cxf.Bus;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(immediate=true, property={"service.vendor=IBM"})
public class JaxwsGlobalHandlerServiceImpl {
    static final TraceComponent tc = Tr.register(JaxwsGlobalHandlerServiceImpl.class);
    private volatile ComponentContext cContext = null;
    private JaxWSGlobalHandlerBusListener listener = null;
    public static final AtomicServiceReference<GlobalHandlerService> globalHandlerServiceSR = new AtomicServiceReference("GlobalHandlerService");
    static final long serialVersionUID = -239286511616761011L;

    @Activate
    protected void activate(ComponentContext cContext, Map<String, Object> properties) throws Exception {
        this.cContext = cContext;
        globalHandlerServiceSR.activate(cContext);
        this.listener = new JaxWSGlobalHandlerBusListener();
        LibertyApplicationBusFactory.getInstance().registerApplicationBusListener(this.listener);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        globalHandlerServiceSR.deactivate(cc);
        this.cContext = null;
        if (this.listener != null) {
            LibertyApplicationBusFactory.getInstance().unregisterApplicationBusListener(this.listener);
        }
    }

    @Reference(service=GlobalHandlerService.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setGlobalHandlerService(ServiceReference<GlobalHandlerService> serviceRef) {
        globalHandlerServiceSR.setReference(serviceRef);
    }

    protected void unsetGlobalHandlerService(ServiceReference<GlobalHandlerService> serviceRef) {
        globalHandlerServiceSR.unsetReference(serviceRef);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    class JaxWSGlobalHandlerBusListener
    implements LibertyApplicationBusListener {
        static final long serialVersionUID = 9073186233429921727L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        JaxWSGlobalHandlerBusListener() {
        }

        @Override
        public void preInit(Bus bus) {
        }

        @Override
        public void initComplete(Bus bus) {
            if (bus == null) {
                return;
            }
            LibertyApplicationBus.Type busType = (LibertyApplicationBus.Type)((Object)bus.getExtension(LibertyApplicationBus.Type.class));
            if (busType == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Unable to recognize the bus type from bus, Global handlers will not be registered and execeuted", (Object[])new Object[0]);
                }
                return;
            }
            if (globalHandlerServiceSR.getService() != null) {
                GlobalHandlerInterceptor globalHandlerInInterceptor = new GlobalHandlerInterceptor("pre-protocol-frontend", "in", busType);
                bus.getInInterceptors().add(globalHandlerInInterceptor);
                GlobalHandlerEntryOutInterceptor globalHandlerOutEntryInterceptor = new GlobalHandlerEntryOutInterceptor("out", busType);
                bus.getOutInterceptors().add(globalHandlerOutEntryInterceptor);
            }
        }

        @Override
        public void preShutdown(Bus bus) {
        }

        @Override
        public void postShutdown(Bus bus) {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(JaxWSGlobalHandlerBusListener.class);
        }
    }
}

