/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.catalog;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.bus.LibertyApplicationBus;
import com.ibm.ws.jaxws.bus.LibertyApplicationBusListener;
import com.ibm.ws.jaxws.metadata.JaxWsModuleMetaData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.apache.cxf.Bus;
import org.apache.cxf.catalog.OASISCatalogManager;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OASISCatalogApplicationBusListener
implements LibertyApplicationBusListener {
    private static final TraceComponent tc = Tr.register(OASISCatalogApplicationBusListener.class);
    static final long serialVersionUID = -876218355341688480L;

    @Override
    public void preInit(Bus bus) {
    }

    @Override
    public void initComplete(Bus bus) {
        if (bus == null) {
            return;
        }
        LibertyApplicationBus.Type busType = (LibertyApplicationBus.Type)((Object)bus.getExtension(LibertyApplicationBus.Type.class));
        if (busType == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to recognize the bus type from bus, OASISCatalogManager will not be created", (Object[])new Object[0]);
            }
            return;
        }
        ClassLoader appClassLoader = (ClassLoader)bus.getExtension(ClassLoader.class);
        JaxWsModuleMetaData moduleMetaData = (JaxWsModuleMetaData)bus.getExtension(JaxWsModuleMetaData.class);
        if (appClassLoader == null || moduleMetaData == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to locate appClassLoader {0} and JaxWsModuleMetaData {1} from bus, OASISCatalogManager will not be created", (Object[])new Object[]{appClassLoader, moduleMetaData});
            }
            return;
        }
        OASISCatalogManager catalogManager = new OASISCatalogManager();
        this.parseCatalogs(catalogManager, appClassLoader);
        bus.setExtension((Object)catalogManager, OASISCatalogManager.class);
    }

    @Override
    public void preShutdown(Bus bus) {
    }

    @Override
    public void postShutdown(Bus bus) {
    }

    public void parseCatalogs(OASISCatalogManager catalogManager, ClassLoader cl) {
        Enumeration<URL> catalogURLs = null;
        try {
            catalogURLs = cl.getResources("WEB-INF/jax-ws-catalog.xml");
            if (catalogURLs != null) {
                while (catalogURLs.hasMoreElements()) {
                    catalogManager.loadCatalog(catalogURLs.nextElement());
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to locate catalog file URL from WEB-INF", (Object[])new Object[0]);
            }
            if ((catalogURLs = cl.getResources("META-INF/jax-ws-catalog.xml")) != null) {
                while (catalogURLs.hasMoreElements()) {
                    catalogManager.loadCatalog(catalogURLs.nextElement());
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to locate catalog file URL from META-INF", (Object[])new Object[0]);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.jaxws.catalog.OASISCatalogApplicationBusListener", (String)"113", (Object)this, (Object[])new Object[]{catalogManager, cl});
        }
    }
}

