/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfiguration;
import com.ibm.ws.sib.ra.inbound.impl.DispatchableMessage;
import com.ibm.ws.sib.ra.inbound.impl.SibRaDispatcher;
import com.ibm.ws.sib.ra.inbound.impl.SibRaListener;
import com.ibm.ws.sib.ra.inbound.impl.SibRaMessagingEngineConnection;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AbstractConsumerSession;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import com.ibm.wsspi.sib.core.exception.SILimitExceededException;
import com.ibm.wsspi.sib.core.exception.SIMessageNotLockedException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;
import com.ibm.wsspi.sib.pacing.AsynchDispatchScheduler;
import com.ibm.wsspi.util.FastSerializableHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;

final class SibRaSingleProcessListener
extends SibRaListener {
    private final WorkManager _workManager;
    private int _workCount;
    private Object _workCountLock = new WorkCountLockObject();
    private final int _maxWorkCount;
    private final boolean _deleteBestEffortNonPersistentMessages;
    private final ActivationSpec _activationSpec;
    private final String _busName;
    private final String _meName;
    private final String _meUuid;
    private final String _destinationName;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaSingleProcessListener.class);
    private static final TraceComponent WORK_TRACE = SibRaUtils.getTraceComponent(SibRaSingleProcessListener.class);
    private static final String CLASS_NAME = SibRaSingleProcessListener.class.getName();
    private static final String WORK_CLASS_NAME = SibRaWork.class.getName();

    SibRaSingleProcessListener(SibRaMessagingEngineConnection connection, SIDestinationAddress destination, MessageEndpointFactory messageEndpointFactory) throws ResourceException {
        super(connection, destination, messageEndpointFactory);
        String methodName = "SibRaSingleProcessListener";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaSingleProcessListener", (Object)new Object[]{connection, destination, messageEndpointFactory});
        }
        this._workManager = this._connection.getEndpointActivation().getWorkManager();
        this._maxWorkCount = this._maxActiveMessages;
        SibRaEndpointConfiguration endpointConfiguration = this._connection.getEndpointConfiguration();
        this._activationSpec = endpointConfiguration.getActivationSpec();
        this._meName = connection.getConnection().getMeName();
        this._meUuid = connection.getConnection().getMeUuid();
        this._busName = connection.getBusName();
        this._destinationName = destination.getDestinationName();
        this._deleteBestEffortNonPersistentMessages = !connection.getEndpointActivation().isEndpointMethodTransactional();
        this.startConsumer();
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaSingleProcessListener");
        }
    }

    @Override
    public void internalConsumeMessages(LockedMessageEnumeration lockedMessages, AsynchDispatchScheduler asynchDispatchScheduler) {
        String methodName = "internalConsumeMessages";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"internalConsumeMessages", (Object)new Object[]{lockedMessages, asynchDispatchScheduler});
        }
        try {
            SIBusMessage message;
            ArrayList<DispatchableMessage> messages = new ArrayList<DispatchableMessage>();
            while ((message = lockedMessages.nextLocked()) != null) {
                FastSerializableHashMap handlerContext = new FastSerializableHashMap();
                DispatchableMessage dispatchableMessage = new DispatchableMessage(message, (Map)handlerContext);
                messages.add(dispatchableMessage);
                if (!this._deleteUnrecoverableMessages || this._unrecoverableReliability.compareTo((Object)message.getReliability()) < 0) continue;
                lockedMessages.deleteCurrent(null);
            }
            if (messages.size() != 0) {
                SibRaWork work = new SibRaWork();
                work.schedule(messages, asynchDispatchScheduler, this);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(CLASS_NAME + "." + "internalConsumeMessages"), (String)"1:375:1.42", (Object)this);
            SibTr.error((TraceComponent)TRACE, (String)"RETRIEVE_MESSAGES_CWSIV1100", (Object)new Object[]{throwable, lockedMessages});
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"internalConsumeMessages");
        }
    }

    @Override
    protected void processCachedMessage(SIBusMessage message, LockedMessageEnumeration lockedMessages) throws SISessionDroppedException, SIConnectionDroppedException, SISessionUnavailableException, SIConnectionUnavailableException, SIConnectionLostException, SILimitExceededException, SIMessageNotLockedException, SIResourceException, SIIncorrectCallException {
        if (this._deleteBestEffortNonPersistentMessages && Reliability.BEST_EFFORT_NONPERSISTENT.equals(message.getReliability())) {
            lockedMessages.deleteCurrent(null);
        }
    }

    @Override
    boolean isSessionBifurcated() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            String methodName = "isSessionBifurcated";
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"isSessionBifurcated");
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"isSessionBifurcated", (Object)Boolean.FALSE);
        }
        return false;
    }

    @Override
    int getMaxActiveMessages() {
        int maxActiveMsgs;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            String methodName = "getMaxActiveMessages";
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getMaxActiveMessages");
        }
        int n = maxActiveMsgs = this._strictMessageOrdering ? 1 : 0;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            String methodName = "getMaxActiveMessages";
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getMaxActiveMessages", (Object)maxActiveMsgs);
        }
        return maxActiveMsgs;
    }

    @Override
    long getMessageLockExpiry() {
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            String methodName = "getMessageLockExpiry";
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getMessageLockExpiry");
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getMessageLockExpiry", (Object)"0");
        }
        return 0L;
    }

    @Override
    protected SibRaStringGenerator getStringGenerator() {
        SibRaStringGenerator generator = super.getStringGenerator();
        generator.addField("workManager", this._workManager);
        generator.addField("maxActiveMessages", this._maxActiveMessages);
        return generator;
    }

    private final class SibRaWork
    implements Work,
    WorkListener {
        private List _messages;
        private SibRaDispatcher _dispatcher;
        private AtomicReference<AsynchDispatchScheduler> _asynchDispatchSchedulerRef = new AtomicReference();
        private AtomicReference<SibRaListener> _listenerRef = new AtomicReference();

        private SibRaWork() {
        }

        public void schedule(List messages, AsynchDispatchScheduler asynchDispatchScheduler, SibRaListener listener) {
            String methodName = "schedule";
            if (TraceComponent.isAnyTracingEnabled() && WORK_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)WORK_TRACE, (String)"schedule", (Object)new Object[]{messages, asynchDispatchScheduler, listener});
            }
            this._messages = messages;
            this._asynchDispatchSchedulerRef.set(asynchDispatchScheduler);
            this._listenerRef.set(listener);
            try {
                SibRaSingleProcessListener.this._workManager.scheduleWork((Work)this, Long.MAX_VALUE, null, (WorkListener)this);
            }
            catch (WorkException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(WORK_CLASS_NAME + "." + "schedule"), (String)"1:559:1.42", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && WORK_TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)WORK_TRACE, (Exception)((Object)exception));
                }
                this.unlockMessages(false);
            }
            if (TraceComponent.isAnyTracingEnabled() && WORK_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)WORK_TRACE, (String)"schedule");
            }
        }

        public synchronized void run() {
            String methodName = "run";
            if (TraceComponent.isAnyTracingEnabled() && WORK_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)WORK_TRACE, (String)"run");
            }
            try {
                if (this._dispatcher == null) {
                    this._dispatcher = SibRaSingleProcessListener.this._connection.createDispatcher((AbstractConsumerSession)SibRaSingleProcessListener.this._session, SibRaSingleProcessListener.this._unrecoverableReliability, SibRaSingleProcessListener.this._maxFailedDeliveries, SibRaSingleProcessListener.this._sequentialFailureThreshold);
                }
                this._dispatcher.dispatch(this._messages, this._asynchDispatchSchedulerRef.get(), this._listenerRef.get());
            }
            catch (IllegalStateException exception) {
                if (TraceComponent.isAnyTracingEnabled() && WORK_TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)WORK_TRACE, (Exception)((Object)exception));
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)(WORK_CLASS_NAME + "." + "run"), (String)"1:608:1.42", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && WORK_TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Throwable)throwable);
                }
            }
            finally {
                if (this._dispatcher != null) {
                    SibRaSingleProcessListener.this._connection.closeDispatcher(this._dispatcher);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && WORK_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)WORK_TRACE, (String)"run");
            }
        }

        public synchronized void release() {
            String methodName = "release";
            if (TraceComponent.isAnyTracingEnabled() && WORK_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)WORK_TRACE, (String)"release");
            }
            if (this._dispatcher != null) {
                this._dispatcher.cancel();
            }
            if (TraceComponent.isAnyTracingEnabled() && WORK_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)WORK_TRACE, (String)"release");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void workAccepted(WorkEvent workEvent) {
            String methodName = "workAccepted";
            if (TraceComponent.isAnyTracingEnabled() && WORK_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)WORK_TRACE, (String)"workAccepted", (Object)workEvent);
            }
            Object object = SibRaSingleProcessListener.this._workCountLock;
            synchronized (object) {
                SibRaSingleProcessListener.this._workCount++;
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)TRACE, (String)("_workCount: " + SibRaSingleProcessListener.this._workCount + " _maxWorkCount: " + SibRaSingleProcessListener.this._maxWorkCount));
                }
                if (SibRaSingleProcessListener.this._workCount == SibRaSingleProcessListener.this._maxWorkCount) {
                    SibRaSingleProcessListener.this.sibPacingSessionStarted = false;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && WORK_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)WORK_TRACE, (String)"workAccepted");
            }
        }

        public void workRejected(WorkEvent workEvent) {
            String methodName = "workRejected";
            if (TraceComponent.isAnyTracingEnabled() && WORK_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)WORK_TRACE, (String)"workRejected", (Object)workEvent);
            }
            this.unlockMessages(false);
            this.workEnded();
            if (TraceComponent.isAnyTracingEnabled() && WORK_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)WORK_TRACE, (String)"workRejected");
            }
        }

        public void workStarted(WorkEvent workEvent) {
            if (TraceComponent.isAnyTracingEnabled() && WORK_TRACE.isEntryEnabled()) {
                String methodName = "workStarted";
                SibTr.entry((Object)this, (TraceComponent)WORK_TRACE, (String)"workStarted", (Object)workEvent);
                SibTr.exit((Object)this, (TraceComponent)WORK_TRACE, (String)"workStarted");
            }
        }

        public void workCompleted(WorkEvent workEvent) {
            String methodName = "workCompleted";
            if (TraceComponent.isAnyTracingEnabled() && WORK_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)WORK_TRACE, (String)"workCompleted", (Object)workEvent);
            }
            this.workEnded();
            if (TraceComponent.isAnyTracingEnabled() && WORK_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)WORK_TRACE, (String)"workCompleted");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void workEnded() {
            String methodName = "workEnded";
            if (TraceComponent.isAnyTracingEnabled() && WORK_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)WORK_TRACE, (String)"workEnded");
            }
            Object object = SibRaSingleProcessListener.this._workCountLock;
            synchronized (object) {
                if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)TRACE, (String)("_workCount: " + SibRaSingleProcessListener.this._workCount + " _maxWorkCount: " + SibRaSingleProcessListener.this._maxWorkCount));
                }
                Object object2 = SibRaSingleProcessListener.this.insideConsumeMessagesLock;
                synchronized (object2) {
                    block15: {
                        if (SibRaSingleProcessListener.this._workCount == SibRaSingleProcessListener.this._maxWorkCount) {
                            try {
                                SibRaSingleProcessListener.this.sibPacingSessionStarted = true;
                                if (!SibRaSingleProcessListener.this.insideConsumeMessages) {
                                    boolean deliverImmediately = false;
                                    SibRaSingleProcessListener.this.startSession(false);
                                }
                            }
                            catch (SIException exception) {
                                FFDCFilter.processException((Throwable)exception, (String)(WORK_CLASS_NAME + "." + "workEnded"), (String)"1:795:1.42", (Object)this);
                                if (WORK_TRACE.isEventEnabled()) {
                                    SibTr.exception((Object)this, (TraceComponent)WORK_TRACE, (Exception)((Object)exception));
                                }
                            }
                            catch (SIErrorException exception) {
                                FFDCFilter.processException((Throwable)exception, (String)(WORK_CLASS_NAME + "." + "workEnded"), (String)"1:803:1.42", (Object)this);
                                if (!WORK_TRACE.isEventEnabled()) break block15;
                                SibTr.exception((Object)this, (TraceComponent)WORK_TRACE, (Exception)((Object)exception));
                            }
                        }
                    }
                }
                SibRaSingleProcessListener.this._workCount--;
            }
            if (TraceComponent.isAnyTracingEnabled() && WORK_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)WORK_TRACE, (String)"workEnded");
            }
        }

        private void unlockMessages(boolean incrementDeliveryCount) {
            String methodName = "unlockMessages";
            if (TraceComponent.isAnyTracingEnabled() && WORK_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)WORK_TRACE, (String)"unlockMessages");
            }
            if (this._messages != null) {
                block8: {
                    ArrayList<SIBusMessage> listOfSIBusMessages = new ArrayList<SIBusMessage>();
                    try {
                        for (int i = 0; i < this._messages.size(); ++i) {
                            listOfSIBusMessages.add(((DispatchableMessage)this._messages.get(i)).getMessage());
                        }
                        SibRaSingleProcessListener.this._session.unlockSet(SibRaListener.getMessageHandles(listOfSIBusMessages), incrementDeliveryCount);
                    }
                    catch (SIException exception) {
                        FFDCFilter.processException((Throwable)exception, (String)(WORK_CLASS_NAME + "." + "unlockMessages"), (String)"1:850:1.42", (Object)this);
                        if (TraceComponent.isAnyTracingEnabled() && WORK_TRACE.isEventEnabled()) {
                            SibTr.exception((Object)this, (TraceComponent)WORK_TRACE, (Exception)((Object)exception));
                        }
                    }
                    catch (SIErrorException exception) {
                        FFDCFilter.processException((Throwable)exception, (String)(WORK_CLASS_NAME + "." + "unlockMessages"), (String)"1:858:1.42", (Object)this);
                        if (!TraceComponent.isAnyTracingEnabled() || !WORK_TRACE.isEventEnabled()) break block8;
                        SibTr.exception((Object)this, (TraceComponent)WORK_TRACE, (Exception)((Object)exception));
                    }
                }
                this._messages = null;
            }
            if (TraceComponent.isAnyTracingEnabled() && WORK_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)WORK_TRACE, (String)"unlockMessages");
            }
        }

        public String toString() {
            SibRaStringGenerator generator = new SibRaStringGenerator(this);
            generator.addField("messages", this._messages);
            generator.addField("dispatcher", this._dispatcher);
            generator.addField("deleteUnrecoverableMessages", SibRaSingleProcessListener.this._deleteUnrecoverableMessages);
            generator.addParent("SibRaSingleProcessListener.this", SibRaSingleProcessListener.this);
            return generator.getStringRepresentation();
        }
    }

    private class WorkCountLockObject {
        private WorkCountLockObject() {
        }
    }
}

