/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.sib.comms.CommsConnection;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.comms.common.CommsByteBufferPool;
import com.ibm.ws.sib.comms.common.CommsLightTrace;
import com.ibm.ws.sib.comms.common.XidProxy;
import com.ibm.ws.sib.comms.server.CommsServerByteBufferPool;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.IdToTransactionTable;
import com.ibm.ws.sib.comms.server.ServerLinkLevelState;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.mfp.AbstractMessage;
import com.ibm.ws.sib.mfp.IncorrectMessageTypeException;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.mfp.impl.ControlMessageFactory;
import com.ibm.ws.sib.mfp.impl.JsMessageFactory;
import com.ibm.ws.sib.utils.DataSlice;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.core.SIXAResource;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class CommsServerByteBuffer
extends CommsByteBuffer {
    private static String CLASS_NAME = CommsServerByteBuffer.class.getName();
    private static final TraceComponent tc = SibTr.register(CommsServerByteBuffer.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");

    public CommsServerByteBuffer(CommsServerByteBufferPool pool) {
        super((CommsByteBufferPool)pool);
    }

    public synchronized int getSITransactionId(int connectionObjectId, ServerLinkLevelState linkState, boolean txOptimized) {
        int transactionId;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSITransactionId", (Object)new Object[]{"" + connectionObjectId, linkState, "" + txOptimized});
        }
        int transactionFlags = -1;
        if (txOptimized) {
            transactionFlags = this.getInt();
            if ((transactionFlags & 1) == 0) {
                transactionId = 0;
            } else {
                int owningConvId = this.getInt();
                transactionId = this.getInt();
                if (tc.isDebugEnabled()) {
                    SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Transaction Flags", (Object)("" + transactionFlags));
                    SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Owning Conversation Id", (Object)("" + owningConvId));
                    SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Transaction Id", (Object)("" + transactionId));
                }
                if ((transactionFlags & 4) != 0) {
                    if ((transactionFlags & 2) != 0) {
                        boolean allowSubordinates = (transactionFlags & 0x10) != 0;
                        try {
                            SIUncoordinatedTransaction uctran = linkState.getSICoreConnectionTable().get(owningConvId).createUncoordinatedTransaction(allowSubordinates);
                            linkState.getTransactionTable().addLocalTran(transactionId, owningConvId, uctran);
                        }
                        catch (SIException e) {
                            if (tc.isEventEnabled()) {
                                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                            }
                            linkState.getTransactionTable().addLocalTran(transactionId, owningConvId, IdToTransactionTable.INVALID_TRANSACTION);
                            linkState.getTransactionTable().markAsRollbackOnly(transactionId, e);
                        }
                    } else {
                        SIXAResource xaRes = null;
                        XidProxy xidProxy = null;
                        try {
                            if ((transactionFlags & 8) != 0) {
                                int endFlags = this.getInt();
                                linkState.getTransactionTable().endOptimizedGlobalTransactionBranch(transactionId, endFlags);
                                xaRes = (SIXAResource)linkState.getTransactionTable().get(transactionId);
                            } else {
                                xaRes = linkState.getSICoreConnectionTable().get(owningConvId).getSIXAResource();
                            }
                            xidProxy = (XidProxy)this.getXid();
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)"xidProxy", (Object)xidProxy);
                            }
                            xaRes.start((Xid)xidProxy, 0);
                            linkState.getTransactionTable().addGlobalTransactionBranch(transactionId, owningConvId, xaRes, xidProxy, true);
                        }
                        catch (SIException e) {
                            if (tc.isEventEnabled()) {
                                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                            }
                            linkState.getTransactionTable().addGlobalTransactionBranch(transactionId, owningConvId, IdToTransactionTable.INVALID_TRANSACTION, xidProxy, true);
                            linkState.getTransactionTable().markAsRollbackOnly(transactionId, e);
                        }
                        catch (XAException e) {
                            if (tc.isEventEnabled()) {
                                SibTr.exception((TraceComponent)tc, (Exception)e);
                            }
                            linkState.getTransactionTable().addGlobalTransactionBranch(transactionId, owningConvId, IdToTransactionTable.INVALID_TRANSACTION, xidProxy, true);
                            linkState.getTransactionTable().markAsRollbackOnly(transactionId, e);
                        }
                    }
                }
            }
        } else {
            transactionId = this.getInt();
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"transactionId", (Object)("" + transactionId));
            }
        }
        if (TraceComponent.isAnyTracingEnabled()) {
            SITransaction commsTx = null;
            if (transactionId != 0) {
                commsTx = linkState.getTransactionTable().get(transactionId, true);
            }
            CommsLightTrace.traceTransaction((TraceComponent)tc, (String)"GetTxnTrace", (Object)commsTx, (int)transactionId, (int)transactionFlags);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSITransactionId", (Object)("" + transactionId));
        }
        return transactionId;
    }

    public synchronized AbstractMessage getMEMEMessage() throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"getMEMEMessage");
        }
        int messageLength = this.getInt();
        boolean isControlMessage = this.get() == 1;
        ControlMessage message = null;
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Message Length", (Object)messageLength);
            SibTr.debug((TraceComponent)tc, (String)"Control Message", (Object)("" + isControlMessage));
        }
        if (isControlMessage) {
            ControlMessageFactory fac = ControlMessageFactory.getInstance();
            if (this.receivedBuffer.hasArray()) {
                message = fac.createInboundControlMessage(this.receivedBuffer.array(), this.receivedBuffer.position() + this.receivedBuffer.arrayOffset(), messageLength);
            } else {
                byte[] messageArray = this.get(messageLength);
                message = fac.createInboundControlMessage(messageArray, 0, messageLength);
            }
        } else {
            JsMessageFactory fac = JsMessageFactory.getInstance();
            if (this.receivedBuffer.hasArray()) {
                message = fac.createInboundJsMessage(this.receivedBuffer.array(), this.receivedBuffer.position() + this.receivedBuffer.arrayOffset(), messageLength);
            } else {
                byte[] messageArray = this.get(messageLength);
                message = fac.createInboundJsMessage(messageArray, 0, messageLength);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"getMEMEMessage", (Object)message);
        }
        return message;
    }

    public synchronized int putMEMEMessage(AbstractMessage memeMessage, Conversation conversation) throws SIConnectionDroppedException, UnsupportedEncodingException, IncorrectMessageTypeException, MessageCopyFailedException, MessageEncodeFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"putMEMEMessage", (Object)new Object[]{memeMessage, conversation});
        }
        List messageParts = null;
        CommsConnection commsConnection = ((ConversationState)conversation.getAttachment()).getCommsConnection();
        messageParts = this.encodeFast(memeMessage, commsConnection, conversation);
        int messageLength = this.putMEMEMessageWithoutEncode(memeMessage, messageParts);
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"putMEMEMessage", (Object)messageLength);
        }
        return messageLength;
    }

    public synchronized int putMEMEMessageWithoutEncode(AbstractMessage memeMessage, List<DataSlice> messageParts) {
        int x;
        if (tc.isEntryEnabled()) {
            SibTr.entry((Object)((Object)this), (TraceComponent)tc, (String)"putMEMEMessageWithoutEncode", (Object)new Object[]{memeMessage, messageParts});
        }
        int messageLength = 0;
        for (x = 0; x < messageParts.size(); ++x) {
            messageLength += messageParts.get(x).getLength();
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Message is " + messageLength + "byte(s) in length"));
        }
        this.putInt(messageLength);
        if (memeMessage.isControlMessage()) {
            this.put((byte)1);
        } else {
            this.put((byte)0);
        }
        for (x = 0; x < messageParts.size(); ++x) {
            DataSlice messPart = messageParts.get(x);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("DataSlice[" + x + "]: Array: " + messPart.getBytes() + ", Offset: " + messPart.getOffset() + ", Length: " + messPart.getLength()));
            }
            this.wrap(messPart.getBytes(), messPart.getOffset(), messPart.getLength());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((Object)((Object)this), (TraceComponent)tc, (String)"putMEMEMessageWithoutEncode", (Object)messageLength);
        }
        return messageLength;
    }
}

