/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.utility.internal.cmdline;

import com.ibm.ws.install.InstallConstants;
import com.ibm.ws.install.InstallEventListener;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.InstallProgressEvent;
import com.ibm.ws.install.RepositoryConfig;
import com.ibm.ws.install.RepositoryConfigUtils;
import com.ibm.ws.install.internal.InstallKernelImpl;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.utility.cmdline.ReturnCode;
import com.ibm.ws.install.utility.internal.cmdline.Action;
import com.ibm.ws.install.utility.internal.cmdline.CmdUtils;
import com.ibm.ws.install.utility.internal.cmdline.InstallUtilityExecutor;
import com.ibm.ws.install.utility.internal.cmdline.RequireAcceptLicenseAction;
import com.ibm.ws.kernel.boot.cmdline.Arguments;
import com.ibm.ws.kernel.feature.internal.cmdline.ArgumentsImpl;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

public class DownloadAction
extends RequireAcceptLicenseAction {
    private File localDir;
    private String localDirString;
    private boolean isOverwrite;
    private InstallEventListener ielistener;
    private InstallEventListener ieNoStepListener;
    private final InstallConstants.DownloadOption downloadOption = InstallConstants.DownloadOption.all;
    private HashSet<String> assetIds;
    private boolean isDirExistBefore;
    private boolean isBadConnectionFound = false;

    @Override
    ReturnCode initialize(Arguments args) {
        super.initialize(args);
        this.installKernel.addListener(this.getNoStepListener(), "PROGRESS");
        if (this.argList.isEmpty()) {
            InstallLogUtils.getInstallLogger().log(Level.SEVERE, CmdUtils.getMessage("ERROR_NO_ARGUMENT", "download"));
            Action.help.handleTask((Arguments)new ArgumentsImpl(new String[]{"help", "download"}));
            return ReturnCode.BAD_ARGUMENT;
        }
        this.assetIds = new HashSet(this.argList);
        this.localDirString = args.getOption("location");
        boolean bl = this.isOverwrite = args.getOption("overwrite") != null;
        if (this.localDirString == null) {
            InstallLogUtils.getInstallLogger().log(Level.SEVERE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_MISSING_DIRECTORY", new Object[]{"download"}));
            return ReturnCode.BAD_ARGUMENT;
        }
        if (this.localDirString.isEmpty()) {
            InstallLogUtils.getInstallLogger().log(Level.SEVERE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_DIRECTORY_REQUIRED", new Object[]{"location"}));
            return ReturnCode.BAD_ARGUMENT;
        }
        try {
            ReturnCode rc = CmdUtils.checkRepositoryStatus(this.installKernel, this.repoProperties, "download", this.getRepoZipForBuild());
            if (rc.equals((Object)ReturnCode.BAD_CONNECTION_FOUND)) {
                rc = ReturnCode.OK;
                this.isBadConnectionFound = true;
            }
            if (rc.equals((Object)ReturnCode.USER_ABORT)) {
                return rc;
            }
        }
        catch (InstallException e) {
            InstallLogUtils.getInstallLogger().log(Level.SEVERE, e.getMessage(), e);
            return InstallUtilityExecutor.returnCode(e.getRc());
        }
        try {
            this.installKernel.resolve(this.assetIds, true);
            this.featureLicenses = this.installKernel.getFeatureLicense(Locale.getDefault());
            this.sampleLicenses = this.installKernel.getSampleLicense(Locale.getDefault());
        }
        catch (InstallException e) {
            InstallException newError = CmdUtils.convertToBadConnectionError(e, this.isBadConnectionFound);
            InstallLogUtils.getInstallLogger().log(Level.SEVERE, newError.getMessage(), newError);
            return InstallUtilityExecutor.returnCode(newError.getRc());
        }
        this.removeEventListener();
        return ReturnCode.OK;
    }

    private File getDownloadOnlyDirectory(String downloadDir) {
        File toDir = new File(downloadDir);
        if (toDir.exists()) {
            this.isDirExistBefore = true;
            if (!toDir.isDirectory()) {
                InstallLogUtils.getInstallLogger().log(Level.SEVERE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_DOWNLOADONLY_IS_FILE", new Object[]{toDir.getAbsolutePath()}));
                return null;
            }
            if (toDir.list() == null) {
                InstallLogUtils.getInstallLogger().log(Level.SEVERE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_DIRECTORY_INACCESSIBLE", new Object[]{toDir.getAbsolutePath()}));
                return null;
            }
            try {
                File test = new File(toDir, "test");
                test.createNewFile();
                test.delete();
            }
            catch (Exception e) {
                InstallLogUtils.getInstallLogger().log(Level.SEVERE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_DIRECTORY_INACCESSIBLE", new Object[]{toDir.getAbsolutePath()}));
                return null;
            }
            if (toDir.isDirectory() && toDir.list().length > 0 && !CmdUtils.isValidDirectoryRepo(toDir)) {
                InstallLogUtils.getInstallLogger().log(Level.SEVERE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_INVALID_DOWNLOAD_DIRECTORY", new Object[]{toDir.getAbsolutePath()}));
                return null;
            }
        } else {
            this.isDirExistBefore = false;
            if (!toDir.mkdirs()) {
                InstallLogUtils.getInstallLogger().log(Level.SEVERE, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_DOWNLOADONLY_UNABLE_TO_CREATE_DIR", new Object[]{toDir.getAbsolutePath()}));
                return null;
            }
        }
        return toDir;
    }

    private void checkForRepoConfig() {
        boolean isRepoAlreadyOnRepoConfig = false;
        try {
            List repositoryConfigs = RepositoryConfigUtils.getRepositoryConfigs((Properties)this.repoProperties);
            for (RepositoryConfig config : repositoryConfigs) {
                String url = config.getUrl();
                if (url == null || !url.toLowerCase().startsWith("file:")) continue;
                try {
                    URL urlProcessed = new URL(url);
                    File repoDir = new File(urlProcessed.getPath());
                    if (!repoDir.exists() || !repoDir.isDirectory() || !repoDir.getAbsolutePath().toLowerCase().equals(this.localDir.getAbsolutePath().toLowerCase())) continue;
                    isRepoAlreadyOnRepoConfig = true;
                }
                catch (Exception e) {}
                break;
            }
            if (isRepoAlreadyOnRepoConfig) {
                InstallLogUtils.getInstallLogger().log(Level.INFO, CmdUtils.getMessage("MSG_DIRECTORY_REPO_CONFIGURED", this.localDir.toURI().toURL().toString()));
            } else {
                InstallLogUtils.getInstallLogger().log(Level.INFO, CmdUtils.getMessage("MSG_DIRECTORY_REPO_NOT_CONFIGURED", this.localDir.toURI().toURL().toString()));
            }
        }
        catch (Exception e) {
            InstallLogUtils.getInstallLogger().log(Level.SEVERE, e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ReturnCode execute() {
        ReturnCode rc = super.execute();
        if (!rc.equals((Object)ReturnCode.OK)) {
            return rc;
        }
        try {
            this.localDir = this.getDownloadOnlyDirectory(this.localDirString);
            if (this.localDir == null) {
                return ReturnCode.IO_FAILURE;
            }
            if (!this.installKernel.resolveExistingAssetsFromDirectoryRepo(this.assetIds, this.localDir, this.isOverwrite)) {
                InstallLogUtils.getInstallLogger().log(Level.INFO, CmdUtils.getMessage("MSG_ALL_DOWNLOADING_FILES_EXISTS", this.localDir.getAbsolutePath()));
                this.checkForRepoConfig();
                return ReturnCode.ALREADY_EXISTS;
            }
        }
        catch (InstallException e) {
            InstallLogUtils.getInstallLogger().log(Level.SEVERE, e.getMessage(), e);
            if (!this.isDirExistBefore) {
                this.localDir.delete();
            }
            return InstallUtilityExecutor.returnCode(e.getRc());
        }
        try {
            Object downloadedFeatures;
            this.installKernel.addListener(this.getListener(), "PROGRESS");
            Map downloadedAssets = ((InstallKernelImpl)this.installKernel).downloadAssetsInstallUtility(this.assetIds, this.localDir, this.downloadOption, null, null, this.isOverwrite);
            if (downloadedAssets != null && !downloadedAssets.isEmpty()) {
                Collection downloadedOpensources;
                Collection downloadedSamples;
                Collection downloadedAddons;
                downloadedFeatures = (Collection)downloadedAssets.get("features");
                if (downloadedFeatures != null && !downloadedFeatures.isEmpty()) {
                    InstallLogUtils.getInstallLogger().log(Level.FINE, CmdUtils.getMessage("MSG_DOWNLOADED_FEATURES", InstallUtils.getFeatureListOutput((Collection)downloadedFeatures)));
                }
                if ((downloadedAddons = (Collection)downloadedAssets.get("addons")) != null && !downloadedAddons.isEmpty()) {
                    InstallLogUtils.getInstallLogger().log(Level.FINE, CmdUtils.getMessage("MSG_DOWNLOADED_ADDONS", InstallUtils.getFeatureListOutput((Collection)downloadedAddons)));
                }
                if ((downloadedSamples = (Collection)downloadedAssets.get("samples")) != null && !downloadedSamples.isEmpty()) {
                    InstallLogUtils.getInstallLogger().log(Level.FINE, CmdUtils.getMessage("MSG_DOWNLOADED_SAMPLES", InstallUtils.getFeatureListOutput((Collection)downloadedSamples)));
                }
                if ((downloadedOpensources = (Collection)downloadedAssets.get("opensource")) != null && !downloadedOpensources.isEmpty()) {
                    InstallLogUtils.getInstallLogger().log(Level.FINE, CmdUtils.getMessage("MSG_DOWNLOADED_OPENSOURCE", InstallUtils.getFeatureListOutput((Collection)downloadedOpensources)));
                }
            }
            InstallLogUtils.getInstallLogger().log(Level.INFO, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_DOWNLOAD_FILES_OK", new Object[0]));
            this.checkForRepoConfig();
            downloadedFeatures = ReturnCode.OK;
            return downloadedFeatures;
        }
        catch (InstallException ie) {
            String errMsg = ie.getMessage();
            if (errMsg.contains("CWWKF1247E")) {
                errMsg = CmdUtils.getMessage("ERROR_DOWNLOAD_ALREADY_INSTALLED", this.assetIds.toString());
            }
            InstallLogUtils.getInstallLogger().log(Level.SEVERE, errMsg, ie);
            if (!this.isDirExistBefore) {
                this.localDir.delete();
            }
            ReturnCode returnCode = InstallUtilityExecutor.returnCode(ie.getRc());
            return returnCode;
        }
        catch (Exception e) {
            InstallLogUtils.getInstallLogger().log(Level.SEVERE, e.getMessage(), e);
            if (!this.isDirExistBefore) {
                this.localDir.delete();
            }
            ReturnCode returnCode = ReturnCode.RUNTIME_EXCEPTION;
            return returnCode;
        }
        finally {
            this.removeEventListener();
        }
    }

    private InstallEventListener getNoStepListener() {
        if (this.ieNoStepListener == null) {
            this.ieNoStepListener = new InstallEventListener(){

                public void handleInstallEvent(InstallProgressEvent event) {
                    if (event.state == 8) {
                        InstallLogUtils.getInstallLogger().log(Level.INFO, event.message);
                    }
                }
            };
        }
        return this.ieNoStepListener;
    }

    private InstallEventListener getListener() {
        int numInstallResources = this.installKernel.getPublicInstallResourcesSize();
        int constantSteps = 4;
        final int progressSteps = numInstallResources + constantSteps;
        if (this.ielistener == null) {
            this.ielistener = new InstallEventListener(){
                int progressCurrentStep = 0;

                public void handleInstallEvent(InstallProgressEvent event) {
                    if (event.state != 176) {
                        InstallLogUtils.getInstallLogger().log(Level.INFO, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("PROGRESS_STEP", new Object[]{++this.progressCurrentStep, progressSteps}) + ": " + event.message);
                    }
                }
            };
        }
        return this.ielistener;
    }

    private void removeEventListener() {
        this.installKernel.removeListener(this.getListener());
        this.ielistener = null;
    }

    @Override
    protected void showMessagesForAdditionalFeatures() {
        Collection samplesOrOpenSources = this.installKernel.getSamplesOrOpenSources();
        if (!samplesOrOpenSources.isEmpty()) {
            logger.log(Level.INFO, "");
            logger.log(Level.INFO, CmdUtils.getMessage("MSG_DOWNLOAD_ADDITIONAL_FEATURES_FOR_SAMPLES", InstallUtils.getFeatureListOutput((Collection)samplesOrOpenSources)));
            logger.log(Level.INFO, "");
            logger.log(Level.INFO, CmdUtils.getMessage("MSG_DOWNLOAD_ACCEPT_LICENSE_FOR_ADDITIONAL_FEATURES", new Object[0]));
        }
    }

    private String getRepoZipForBuild() {
        String zipRepoPath = System.getProperty("INTERNAL_DOWNLOAD_FROM_FOR_BUILD");
        if (zipRepoPath != null) {
            logger.log(Level.FINEST, "INTERNAL_DOWNLOAD_FROM_FOR_BUILD=" + zipRepoPath);
            File zipRepoFile = new File(zipRepoPath);
            if (zipRepoFile.exists()) {
                return zipRepoPath;
            }
        }
        return null;
    }
}

