/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.jfapchannel.AcceptListener;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.Dispatchable;
import com.ibm.ws.sib.jfapchannel.JFapChannelConstants;
import com.ibm.ws.sib.jfapchannel.ReceiveListener;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBuffer;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBufferPool;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.ConversationImpl;
import com.ibm.ws.sib.jfapchannel.impl.JFapUtils;
import com.ibm.ws.sib.jfapchannel.impl.RequestIdTable;
import com.ibm.ws.sib.jfapchannel.impl.rldispatcher.ReceiveListenerDispatcher;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;

public class InboundTransmissionParser {
    private static final TraceComponent tc = SibTr.register(InboundTransmissionParser.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private Connection connection;
    private Throwable throwable;
    private AcceptListener acceptListener;
    private boolean onClientSide;
    private byte expectedPacketNumber = 0;
    private int transmissionPayloadDataLength;
    private int transmissionPayloadRemaining;
    private WsByteBuffer[] inFlightSegmentedTransmissions = new WsByteBuffer[16];
    private boolean needMoreData = false;
    private int state = 0;
    private static final int STATE_PARSING_PRIMARY_HEADER = 0;
    private static final int STATE_PARSING_CONVERSATION_HEADER = 1;
    private static final int STATE_PARSING_SEGMENT_START_HEADER = 2;
    private static final int STATE_PARSING_PRIMARY_ONLY_PAYLOAD = 3;
    private static final int STATE_PARSE_CONVERSATION_PAYLOAD = 4;
    private static final int STATE_PARSE_SEGMENT_START_PAYLOAD = 5;
    private static final int STATE_PARSE_SEGMENT_MIDDLE_PAYLOAD = 6;
    private static final int STATE_PARSE_SEGMENT_END_PAYLOAD = 7;
    private static final int STATE_ERROR = 8;
    private WsByteBuffer unparsedPrimaryHeader;
    private WsByteBuffer unparsedConversationHeader;
    private WsByteBuffer unparsedFirstSegment;
    private WsByteBuffer unparsedPayloadData = null;
    private PrimaryHeaderFields primaryHeaderFields = new PrimaryHeaderFields();
    private ConversationHeaderFields conversationHeaderFields = new ConversationHeaderFields();
    private SegmentedTransmissionHeaderFields[] segmentedTransmissionHeaderFields = new SegmentedTransmissionHeaderFields[16];
    private JFapChannelConstants.TransmissionLayout transmissionLayout = JFapChannelConstants.XMIT_LAYOUT_UNKNOWN;
    private static volatile int clientReadBytes = 0;
    private static volatile int meReadBytes = 0;
    private Conversation.ConversationType type = Conversation.UNKNOWN;

    public InboundTransmissionParser(Connection connection, AcceptListener acceptListener, boolean onClientSide) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{connection, acceptListener, "" + onClientSide});
        }
        this.connection = connection;
        this.acceptListener = acceptListener;
        this.onClientSide = onClientSide;
        this.unparsedPrimaryHeader = this.allocateWsByteBuffer(10, false);
        this.unparsedPrimaryHeader.position(0);
        this.unparsedPrimaryHeader.limit(10);
        this.unparsedConversationHeader = this.allocateWsByteBuffer(4, false);
        this.unparsedConversationHeader.position(0);
        this.unparsedConversationHeader.limit(4);
        this.unparsedFirstSegment = this.allocateWsByteBuffer(12, false);
        this.unparsedFirstSegment.position(0);
        this.unparsedFirstSegment.limit(12);
        for (int i = 0; i < this.segmentedTransmissionHeaderFields.length; ++i) {
            this.segmentedTransmissionHeaderFields[i] = new SegmentedTransmissionHeaderFields();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public void parse(WsByteBuffer transmissionData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"parse", (Object)transmissionData);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, transmissionData, "transmissionBuffer");
        }
        this.needMoreData = false;
        boolean encounteredError = false;
        block11: while (!this.needMoreData && !encounteredError) {
            switch (this.state) {
                case 0: {
                    this.parsePrimaryHeader(transmissionData);
                    continue block11;
                }
                case 1: {
                    this.parseConversationHeader(transmissionData);
                    continue block11;
                }
                case 2: {
                    this.parseSegmentStartHeader(transmissionData);
                    continue block11;
                }
                case 3: {
                    this.parsePrimaryOnlyPayload(transmissionData);
                    continue block11;
                }
                case 4: {
                    this.parseConversationPayload(transmissionData);
                    continue block11;
                }
                case 5: {
                    this.parseSegmentStartPayload(transmissionData);
                    continue block11;
                }
                case 6: {
                    this.parseSegmentMiddlePayload(transmissionData);
                    continue block11;
                }
                case 7: {
                    this.parseSegmentEndPayload(transmissionData);
                    continue block11;
                }
                case 8: {
                    encounteredError = true;
                    continue block11;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"got into default branch of parse() method case statement");
            }
            this.throwable = new SIErrorException("Should not have entered default branch of parse() method case statement");
            FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170001");
            this.state = 8;
        }
        if (encounteredError) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"encountered error parsing");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Throwable)this.throwable);
            }
            this.connection.invalidate(false, this.throwable, "parse error while parsing transmission");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"parse");
        }
    }

    private void parsePrimaryHeader(WsByteBuffer contextBuffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"parsePrimaryHeader", (Object)contextBuffer);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, contextBuffer, "contextBuffer");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, this.unparsedPrimaryHeader, "unparsedPrimaryHeader");
        }
        int initialPrimaryHeaderPosition = this.unparsedPrimaryHeader.position();
        WsByteBuffer parseHeaderBuffer = this.readData(contextBuffer, this.unparsedPrimaryHeader);
        if (parseHeaderBuffer != null) {
            short eyecatcher;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"parse header buffer not null");
            }
            if ((eyecatcher = parseHeaderBuffer.getShort()) != -16657) {
                this.state = 8;
                this.throwable = new SIConnectionLostException(nls.getFormattedMessage("TRANSPARSER_PROTOCOLERROR_SICJ0053", new Object[]{this.connection.remoteHostAddress, this.connection.chainName}, "TRANSPARSER_PROTOCOLERROR_SICJ0053"));
                FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170002", (Object)this.getFormattedBytes(contextBuffer));
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("bad eyecatcer (as short): " + eyecatcher));
                }
            } else {
                this.primaryHeaderFields.segmentLength = parseHeaderBuffer.getInt();
                if (this.primaryHeaderFields.segmentLength < 0) {
                    this.primaryHeaderFields.segmentLength = (int)((long)this.primaryHeaderFields.segmentLength + 0x100000000L);
                }
                if (this.primaryHeaderFields.segmentLength > this.connection.getMaxTransmissionSize()) {
                    this.state = 8;
                    this.throwable = new SIConnectionLostException(nls.getFormattedMessage("TRANSPARSER_PROTOCOLERROR_SICJ0053", new Object[]{this.connection.remoteHostAddress, this.connection.chainName}, "TRANSPARSER_PROTOCOLERROR_SICJ0053"));
                    FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170003", (Object)this.getFormattedBytes(contextBuffer));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"max transmission size exceeded");
                    }
                } else {
                    this.transmissionPayloadRemaining = this.primaryHeaderFields.segmentLength - 10;
                    short flags = parseHeaderBuffer.getShort();
                    this.primaryHeaderFields.priority = flags & 0xF;
                    this.primaryHeaderFields.isPooled = (flags & 0x1000) == 4096;
                    boolean bl = this.primaryHeaderFields.isExchange = (flags & 0x4000) == 16384;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("flags: " + flags));
                    }
                    this.primaryHeaderFields.packetNumber = parseHeaderBuffer.get();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("packet number: " + this.primaryHeaderFields.packetNumber + " expected: " + this.expectedPacketNumber));
                    }
                    if (this.primaryHeaderFields.packetNumber != this.expectedPacketNumber) {
                        this.state = 8;
                        this.throwable = new SIConnectionLostException(nls.getFormattedMessage("TRANSPARSER_PROTOCOLERROR_SICJ0053", new Object[]{this.connection.remoteHostAddress, this.connection.chainName}, "TRANSPARSER_PROTOCOLERROR_SICJ0053"));
                        Object[] ffdcData = new Object[]{"expected packet number=" + this.expectedPacketNumber, "received packet number=" + this.primaryHeaderFields.packetNumber, this.getFormattedBytes(contextBuffer)};
                        FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170004", (Object[])ffdcData);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("sequence number mis-match - expected:" + this.expectedPacketNumber + " got:" + this.primaryHeaderFields.packetNumber));
                        }
                    } else {
                        this.expectedPacketNumber = (byte)(this.expectedPacketNumber + 1);
                        this.primaryHeaderFields.segmentType = parseHeaderBuffer.get();
                        if (this.primaryHeaderFields.segmentType < 0) {
                            this.primaryHeaderFields.segmentType += 256;
                        }
                        this.transmissionLayout = JFapChannelConstants.segmentToLayout(this.primaryHeaderFields.segmentType);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("layout = " + this.transmissionLayout));
                        }
                        if (this.transmissionLayout == JFapChannelConstants.XMIT_PRIMARY_ONLY) {
                            this.transmissionPayloadDataLength = this.primaryHeaderFields.segmentLength - 10;
                            this.state = 3;
                        } else if (this.transmissionLayout == JFapChannelConstants.XMIT_CONVERSATION || this.transmissionLayout == JFapChannelConstants.XMIT_SEGMENT_START || this.transmissionLayout == JFapChannelConstants.XMIT_SEGMENT_MIDDLE || this.transmissionLayout == JFapChannelConstants.XMIT_SEGMENT_END) {
                            this.state = 1;
                        } else if (this.transmissionLayout == JFapChannelConstants.XMIT_LAYOUT_UNKNOWN) {
                            this.throwable = new SIErrorException(nls.getFormattedMessage("TRANSPARSER_INTERNAL_SICJ0054", null, "TRANSPARSER_INTERNAL_SICJ0054"));
                            FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170005", (Object)this.getFormattedBytes(contextBuffer));
                            this.state = 8;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"invalid layout");
                            }
                        } else {
                            this.throwable = new SIErrorException(nls.getFormattedMessage("TRANSPARSER_INTERNAL_SICJ0054", null, "TRANSPARSER_INTERNAL_SICJ0054"));
                            FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170006", (Object)this.getFormattedBytes(contextBuffer));
                            this.state = 8;
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"JFapChannelConstants.segmentToLayout method returned unknown enumeration value");
                            }
                        }
                    }
                }
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                JFapUtils.debugTraceWsByteBufferInfo(this, tc, this.unparsedPrimaryHeader, "unparsedPrimaryHEader");
            }
            int unparsedPrimaryHeaderPosition = this.unparsedPrimaryHeader.position();
            if (initialPrimaryHeaderPosition < 2 && unparsedPrimaryHeaderPosition > initialPrimaryHeaderPosition) {
                int eyecatcherPresent = unparsedPrimaryHeaderPosition - initialPrimaryHeaderPosition;
                if (eyecatcherPresent > 2) {
                    eyecatcherPresent = 2;
                }
                int eyecatcherOffset = initialPrimaryHeaderPosition;
                this.unparsedPrimaryHeader.position(eyecatcherOffset);
                boolean reject = false;
                for (int i = eyecatcherOffset; i < eyecatcherPresent && !reject; ++i) {
                    reject = this.unparsedPrimaryHeader.get() != JFapChannelConstants.EYECATCHER_AS_BYTES[i];
                }
                if (reject) {
                    this.throwable = new SIConnectionLostException(nls.getFormattedMessage("TRANSPARSER_PROTOCOLERROR_SICJ0053", new Object[]{this.connection.remoteHostAddress, this.connection.chainName}, "TRANSPARSER_PROTOCOLERROR_SICJ0053"));
                    FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170007", (Object)this.getFormattedBytes(contextBuffer));
                    this.state = 8;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"invalid eyecatcher");
                    }
                } else {
                    this.unparsedPrimaryHeader.position(unparsedPrimaryHeaderPosition);
                }
            }
            if (this.state != 8) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"need more data");
                }
                this.needMoreData = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"parsePrimaryHeader");
        }
    }

    private void parseConversationHeader(WsByteBuffer contextBuffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"parseConversationHeader", (Object)contextBuffer);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, contextBuffer, "contextBuffer");
        }
        WsByteBuffer parseConversationBuffer = this.readData(contextBuffer, this.unparsedConversationHeader);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, parseConversationBuffer, "parseConversationBuffer");
        }
        if (parseConversationBuffer != null) {
            this.conversationHeaderFields.conversationId = parseConversationBuffer.getShort();
            this.conversationHeaderFields.requestNumber = parseConversationBuffer.getShort();
            this.transmissionPayloadRemaining -= 4;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("conversationId:" + this.conversationHeaderFields.conversationId + " requestNumber:" + this.conversationHeaderFields.requestNumber));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("transmissionLayout:" + this.transmissionLayout));
            }
            if (this.transmissionLayout == JFapChannelConstants.XMIT_CONVERSATION) {
                this.transmissionPayloadDataLength = this.primaryHeaderFields.segmentLength - 14;
                this.state = 4;
            } else if (this.transmissionLayout == JFapChannelConstants.XMIT_SEGMENT_MIDDLE) {
                this.transmissionPayloadDataLength = this.primaryHeaderFields.segmentLength - 14;
                this.state = 6;
            } else if (this.transmissionLayout == JFapChannelConstants.XMIT_SEGMENT_END) {
                this.transmissionPayloadDataLength = this.primaryHeaderFields.segmentLength - 14;
                this.state = 7;
            } else if (this.transmissionLayout == JFapChannelConstants.XMIT_SEGMENT_START) {
                this.state = 2;
            } else if (this.transmissionLayout == JFapChannelConstants.XMIT_PRIMARY_ONLY) {
                this.throwable = new SIErrorException(nls.getFormattedMessage("TRANSPARSER_INTERNAL_SICJ0054", null, "TRANSPARSER_INTERNAL_SICJ0054"));
                FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170008", (Object)this.getFormattedBytes(contextBuffer));
                this.state = 8;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Invalid state detected - Entered parseConversationHeader method when transmission only contained a primary header");
                }
            } else if (this.transmissionLayout == JFapChannelConstants.XMIT_LAYOUT_UNKNOWN) {
                this.throwable = new SIErrorException(nls.getFormattedMessage("TRANSPARSER_INTERNAL_SICJ0054", null, "TRANSPARSER_INTERNAL_SICJ0054"));
                FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170009", (Object)this.getFormattedBytes(contextBuffer));
                this.state = 8;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Invalid state detected - Entered parseConversationHeader method when transmission layout could not be determined");
                }
            } else {
                this.throwable = new SIErrorException(nls.getFormattedMessage("TRANSPARSER_INTERNAL_SICJ0054", null, "TRANSPARSER_INTERNAL_SICJ0054"));
                FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170010", (Object)this.getFormattedBytes(contextBuffer));
                this.state = 8;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unknown transmission layout detected in parseConversationHeader");
                }
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"need more data");
            }
            this.needMoreData = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"parseConversationHeader");
        }
    }

    private void parseSegmentStartHeader(WsByteBuffer contextBuffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"parseSegmentStartHeader", (Object)contextBuffer);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, contextBuffer, "contextBuffer");
        }
        WsByteBuffer rawData = this.readData(contextBuffer, this.unparsedFirstSegment);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, rawData, "rawData");
        }
        if (rawData != null) {
            this.segmentedTransmissionHeaderFields[this.primaryHeaderFields.priority].totalLength = rawData.getLong();
            this.transmissionPayloadRemaining -= 12;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("totalLenght: " + this.segmentedTransmissionHeaderFields[this.primaryHeaderFields.priority].totalLength));
            }
            if (this.segmentedTransmissionHeaderFields[this.primaryHeaderFields.priority].totalLength < 0L) {
                this.throwable = new SIConnectionLostException(nls.getFormattedMessage("TRANSPARSER_PROTOCOLERROR_SICJ0053", new Object[]{this.connection.remoteHostAddress, this.connection.chainName}, "TRANSPARSER_PROTOCOLERROR_SICJ0053"));
                FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170011", (Object)this.getFormattedBytes(contextBuffer));
                this.state = 8;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Conversation lost after peer transmitted more data than initially indicated in first part of segmented transmission");
                }
            } else {
                this.segmentedTransmissionHeaderFields[this.primaryHeaderFields.priority].segmentType = rawData.get();
                if (this.segmentedTransmissionHeaderFields[this.primaryHeaderFields.priority].segmentType < 0) {
                    SegmentedTransmissionHeaderFields segmentedTransmissionHeaderFields = this.segmentedTransmissionHeaderFields[this.primaryHeaderFields.priority];
                    segmentedTransmissionHeaderFields.segmentType = segmentedTransmissionHeaderFields.segmentType + 256;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("segmentType: " + this.segmentedTransmissionHeaderFields[this.primaryHeaderFields.priority].segmentType));
                }
                rawData.position(rawData.position() + 3);
                this.transmissionPayloadDataLength = this.primaryHeaderFields.segmentLength - 26;
                this.state = 5;
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"need more data");
            }
            this.needMoreData = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"parseSegmentStartHeader");
        }
    }

    private void parsePrimaryOnlyPayload(WsByteBuffer contextBuffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"parsePrimaryOnlyPayload", (Object)contextBuffer);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, contextBuffer, "contextBuffer");
        }
        WsByteBuffer dispatchToConnectionData = null;
        if (this.unparsedPayloadData == null && this.transmissionPayloadDataLength > contextBuffer.remaining()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("allocating unparsed payload data area, size=" + this.transmissionPayloadDataLength));
            }
            this.unparsedPayloadData = this.allocateWsByteBuffer(this.transmissionPayloadDataLength, false);
            this.unparsedPayloadData.position(0);
            this.unparsedPayloadData.limit(this.transmissionPayloadDataLength);
        }
        if (this.state != 8) {
            if (this.unparsedPayloadData != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    JFapUtils.debugTraceWsByteBufferInfo(this, tc, this.unparsedPayloadData, "unparsedPayloadData");
                }
                if ((dispatchToConnectionData = this.readData(contextBuffer, this.unparsedPayloadData)) != null) {
                    boolean closed = this.dispatchToConnection(dispatchToConnectionData);
                    if (closed) {
                        this.needMoreData = true;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Connection closed, breaking out of loop");
                        }
                    }
                    this.reset();
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"need more data");
                    }
                    this.needMoreData = true;
                }
            } else {
                int contextBufferPosition = contextBuffer.position();
                int contextBufferLimit = contextBuffer.limit();
                contextBuffer.limit(contextBufferPosition + this.transmissionPayloadDataLength);
                boolean closed = this.dispatchToConnection(contextBuffer);
                if (closed) {
                    this.needMoreData = true;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Connection closed, breaking out of loop");
                    }
                } else {
                    contextBuffer.limit(contextBufferLimit);
                    contextBuffer.position(contextBufferPosition + this.transmissionPayloadDataLength);
                }
                this.reset();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"parsePrimaryOnlyPayload");
        }
    }

    private void parseConversationPayload(WsByteBuffer contextBuffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"parseConversationPayload", (Object)contextBuffer);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, contextBuffer, "contextBuffer");
        }
        if (this.unparsedPayloadData == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("allocating unparsed data buffer, size=" + this.transmissionPayloadDataLength));
            }
            this.unparsedPayloadData = this.allocateWsByteBuffer(this.transmissionPayloadDataLength, this.primaryHeaderFields.isPooled);
            this.unparsedPayloadData.position(0);
            this.unparsedPayloadData.limit(this.transmissionPayloadDataLength);
        }
        if (this.state != 8) {
            int unparsedDataRemaining = this.unparsedPayloadData.remaining();
            int amountCopied = JFapUtils.copyWsByteBuffer(contextBuffer, this.unparsedPayloadData, unparsedDataRemaining);
            if (amountCopied == unparsedDataRemaining) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("dispatching to conversation - amount cpoied = " + amountCopied));
                }
                this.dispatchToConversation(this.unparsedPayloadData);
                if (this.state != 8) {
                    this.reset();
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"need more data");
                }
                this.needMoreData = true;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"parseConversationPayload");
        }
    }

    private void parseSegmentStartPayload(WsByteBuffer contextBuffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"parseSegmentStartPayload", (Object)contextBuffer);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, contextBuffer, "contextBuffer");
        }
        if (this.unparsedPayloadData == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("allocating unparsed payload data buffe, size=" + this.segmentedTransmissionHeaderFields[this.primaryHeaderFields.priority].totalLength));
            }
            this.unparsedPayloadData = this.allocateWsByteBuffer((int)this.segmentedTransmissionHeaderFields[this.primaryHeaderFields.priority].totalLength, this.primaryHeaderFields.isPooled);
            this.unparsedPayloadData.position(0);
            this.unparsedPayloadData.limit((int)this.segmentedTransmissionHeaderFields[this.primaryHeaderFields.priority].totalLength);
        }
        if (this.state != 8) {
            int amountCopied = JFapUtils.copyWsByteBuffer(contextBuffer, this.unparsedPayloadData, this.transmissionPayloadRemaining);
            this.transmissionPayloadRemaining -= amountCopied;
            if (this.inFlightSegmentedTransmissions[this.primaryHeaderFields.priority] != null) {
                this.throwable = new SIConnectionLostException(nls.getFormattedMessage("TRANSPARSER_PROTOCOLERROR_SICJ0053", new Object[]{this.connection.remoteHostAddress, this.connection.chainName}, "TRANSPARSER_PROTOCOLERROR_SICJ0053"));
                FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170012", (Object)this.getFormattedBytes(contextBuffer));
                this.state = 8;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Received the start of a segmented transmission whilst already processing a segmented transmission at the same priority level");
                }
            } else {
                boolean bl = this.needMoreData = contextBuffer.remaining() == 0;
                if (!this.needMoreData) {
                    this.inFlightSegmentedTransmissions[this.primaryHeaderFields.priority] = this.unparsedPayloadData;
                    if (this.type == Conversation.ME) {
                        meReadBytes += this.unparsedPayloadData.remaining();
                    } else if (this.type == Conversation.CLIENT) {
                        clientReadBytes -= this.unparsedPayloadData.remaining();
                    }
                    this.reset();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"parseSegmentStartPayload");
        }
    }

    private void parseSegmentMiddlePayload(WsByteBuffer contextBuffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"parseSegmentMiddlePayload", (Object)contextBuffer);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, contextBuffer, "contextBuffer");
        }
        WsByteBuffer partialTransmission = this.inFlightSegmentedTransmissions[this.primaryHeaderFields.priority];
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("partial transmission in slot " + this.primaryHeaderFields.priority + " = " + partialTransmission));
        }
        int contextBufferRemaining = contextBuffer.remaining();
        if (partialTransmission == null) {
            this.throwable = new SIConnectionLostException(nls.getFormattedMessage("TRANSPARSER_PROTOCOLERROR_SICJ0053", new Object[]{this.connection.remoteHostAddress, this.connection.chainName}, "TRANSPARSER_PROTOCOLERROR_SICJ0053"));
            FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170013", (Object)this.getFormattedBytes(contextBuffer));
            this.state = 8;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Received the middle segment of a segmented transmission prior to receiving a start segment.");
            }
        } else if (partialTransmission.remaining() < this.transmissionPayloadRemaining) {
            this.throwable = new SIConnectionLostException(nls.getFormattedMessage("TRANSPARSER_PROTOCOLERROR_SICJ0053", new Object[]{this.connection.remoteHostAddress, this.connection.chainName}, "TRANSPARSER_PROTOCOLERROR_SICJ0053"));
            FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170014", (Object)this.getFormattedBytes(contextBuffer));
            this.state = 8;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Received a middle segment for a segmented transmission which makes the transmission larger than the peer indicated in the first segment.");
            }
        } else {
            int amountCopied = JFapUtils.copyWsByteBuffer(contextBuffer, partialTransmission, this.transmissionPayloadRemaining);
            this.transmissionPayloadRemaining -= amountCopied;
            if (this.type == Conversation.ME) {
                meReadBytes -= amountCopied;
            } else if (this.type == Conversation.CLIENT) {
                clientReadBytes -= amountCopied;
            }
            boolean bl = this.needMoreData = amountCopied == contextBufferRemaining;
            if (!this.needMoreData) {
                this.reset();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"parseSegmentMiddlePayload");
        }
    }

    private void parseSegmentEndPayload(WsByteBuffer contextBuffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"parseSegmentEndPayload", (Object)contextBuffer);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            JFapUtils.debugTraceWsByteBufferInfo(this, tc, contextBuffer, "contextBuffer");
        }
        WsByteBuffer partialTransmission = this.inFlightSegmentedTransmissions[this.primaryHeaderFields.priority];
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("partial transmission in slot " + this.primaryHeaderFields.priority + " = " + partialTransmission));
        }
        if (partialTransmission == null) {
            this.throwable = new SIConnectionLostException(nls.getFormattedMessage("TRANSPARSER_PROTOCOLERROR_SICJ0053", new Object[]{this.connection.remoteHostAddress, this.connection.chainName}, "TRANSPARSER_PROTOCOLERROR_SICJ0053"));
            FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170015", (Object)this.getFormattedBytes(contextBuffer));
            this.state = 8;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Peer sent a segment end transmission prior to sending a segment start transmission for the segmented transmission.");
            }
        } else {
            int partialTransmissionRemaining = partialTransmission.remaining();
            if (partialTransmissionRemaining > this.transmissionPayloadRemaining) {
                this.throwable = new SIConnectionLostException(nls.getFormattedMessage("TRANSPARSER_PROTOCOLERROR_SICJ0053", new Object[]{this.connection.remoteHostAddress, this.connection.chainName}, "TRANSPARSER_PROTOCOLERROR_SICJ0053"));
                FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170016", (Object)this.getFormattedBytes(contextBuffer));
                this.state = 8;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Peer sent the end segment of a segmented transmission which contains more data than origioinally suggested by first segment in segmented transmission.");
                }
            } else {
                int amountCopied = JFapUtils.copyWsByteBuffer(contextBuffer, partialTransmission, this.transmissionPayloadRemaining);
                this.transmissionPayloadRemaining -= amountCopied;
                if (this.type == Conversation.ME) {
                    meReadBytes -= amountCopied;
                } else if (this.type == Conversation.CLIENT) {
                    clientReadBytes -= amountCopied;
                }
                boolean bl = this.needMoreData = contextBuffer.remaining() == 0;
                if (this.transmissionPayloadRemaining == 0) {
                    this.inFlightSegmentedTransmissions[this.primaryHeaderFields.priority] = null;
                    this.primaryHeaderFields.segmentType = this.segmentedTransmissionHeaderFields[this.primaryHeaderFields.priority].segmentType;
                    this.dispatchToConversation(partialTransmission);
                    this.reset();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"parseSegmentEndPayload");
        }
    }

    private boolean dispatchToConnection(WsByteBuffer data) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dispatchToConnection", (Object)data);
        }
        if (TraceComponent.isAnyTracingEnabled()) {
            JFapUtils.debugSummaryMessage(tc, this.connection, null, "received connection data with segment " + Integer.toHexString(this.primaryHeaderFields.segmentType) + " (" + JFapChannelConstants.getSegmentName(this.primaryHeaderFields.segmentType) + ")");
        }
        boolean closed = this.connection.processData(this.primaryHeaderFields.segmentType, this.primaryHeaderFields.priority, this.primaryHeaderFields.isPooled, this.primaryHeaderFields.isExchange, data);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dispatchToConnection", (Object)closed);
        }
        return closed;
    }

    private void dispatchToConversation(WsByteBuffer data) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dispatchToConversation", (Object)data);
        }
        ConversationImpl conversation = this.connection.getConversationById(this.conversationHeaderFields.conversationId);
        if (TraceComponent.isAnyTracingEnabled()) {
            JFapUtils.debugSummaryMessage(tc, this.connection, conversation, "received conversation data with segment " + Integer.toHexString(this.primaryHeaderFields.segmentType) + " (" + JFapChannelConstants.getSegmentName(this.primaryHeaderFields.segmentType) + ")", this.conversationHeaderFields.requestNumber);
        }
        if (conversation != null) {
            conversation.logDataReceivedEvent(this.primaryHeaderFields.segmentType, this.conversationHeaderFields.requestNumber);
        }
        switch (this.primaryHeaderFields.segmentType) {
            case 10: {
                if (conversation == null) {
                    this.state = 8;
                    this.throwable = new SIConnectionLostException(nls.getFormattedMessage("TRANSPARSER_PROTOCOLERROR_SICJ0053", new Object[]{this.connection.remoteHostAddress, this.connection.chainName}, "TRANSPARSER_PROTOCOLERROR_SICJ0053"));
                    FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170017", (Object)this.getFormattedBytes(data));
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Cannot locate conversation corresponding to conversation identifier in transmission (" + this.conversationHeaderFields.conversationId + ")"));
                    break;
                }
                conversation.processLogicalClose(data);
                break;
            }
            case 14: {
                if (conversation == null) {
                    this.state = 8;
                    this.throwable = new SIConnectionLostException(nls.getFormattedMessage("TRANSPARSER_PROTOCOLERROR_SICJ0053", new Object[]{this.connection.remoteHostAddress, this.connection.chainName}, "TRANSPARSER_PROTOCOLERROR_SICJ0053"));
                    FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170018", (Object)this.getFormattedBytes(data));
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Cannot locate conversation corresponding to conversation identifier in transmission (" + this.conversationHeaderFields.conversationId + ")"));
                    break;
                }
                conversation.processPing(this.conversationHeaderFields.requestNumber, this.primaryHeaderFields.priority, data);
                break;
            }
            case 15: {
                if (conversation == null) {
                    this.state = 8;
                    this.throwable = new SIConnectionLostException(nls.getFormattedMessage("TRANSPARSER_PROTOCOLERROR_SICJ0053", new Object[]{this.connection.remoteHostAddress, this.connection.chainName}, "TRANSPARSER_PROTOCOLERROR_SICJ0053"));
                    FFDCFilter.processException((Throwable)this.throwable, (String)"com.ibm.ws.sib.jfapchannel.impl.InboundTransmissionParser", (String)"00170019", (Object)this.getFormattedBytes(data));
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Cannot locate conversation corresponding to conversation identifier in transmission (" + this.conversationHeaderFields.conversationId + ")"));
                    break;
                }
                conversation.processPingResponse(data);
                break;
            }
            default: {
                this.dispatchToConversationListenerMethod(data, conversation);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dispatchToConversation");
        }
    }

    private void dispatchToConversationListenerMethod(WsByteBuffer data, ConversationImpl conversation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dispatchToConversationListenerMethod", (Object)new Object[]{data, conversation});
        }
        boolean bailOut = false;
        if (conversation == null) {
            if (this.onClientSide) {
                bailOut = true;
            } else {
                conversation = new ConversationImpl((short)this.conversationHeaderFields.conversationId, false, this.connection, null);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"accepting new conversation");
                }
                ConversationReceiveListener rl = null;
                boolean badReceiveListener = false;
                try {
                    rl = this.acceptListener.acceptConnection(conversation);
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.sib.jfapchannel.impl.ConnectionReadCompletedCallback", (String)"00170020");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception thrown from acceptConnection");
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((Object)this, (TraceComponent)tc, (String)t.getMessage());
                    }
                    badReceiveListener = true;
                    bailOut = true;
                }
                if (rl == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"bad receive listener");
                    }
                    badReceiveListener = true;
                    bailOut = true;
                    rl = new BadReceiveListener();
                }
                conversation.setDefaultReceiveListener(rl);
                try {
                    conversation = this.connection.startNewConversation(conversation);
                    if (badReceiveListener) {
                        try {
                            conversation.close();
                        }
                        catch (SIResourceException e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.jfapchannel.impl.ConnectionReadCompletedCallback", (String)"00170020");
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception thrown closing conversation");
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)e));
                            }
                            this.connection.invalidate(false, e, "SIResourceError when closing conversation - " + e.getMessage());
                            bailOut = true;
                        }
                    }
                }
                catch (SIResourceException e) {
                    try {
                        conversation.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.connection.invalidate(true, e, "SIResourceError when creating conversation - " + e.getMessage());
                }
            }
        }
        if (!bailOut) {
            RequestIdTable reqIdTable = null;
            if (conversation != null) {
                reqIdTable = conversation.getRequestIdTable();
            }
            if (reqIdTable != null && reqIdTable.containsId(this.conversationHeaderFields.requestNumber)) {
                ReceiveListener listener = reqIdTable.getListener(this.conversationHeaderFields.requestNumber);
                reqIdTable.remove(this.conversationHeaderFields.requestNumber);
                if (listener != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("listener: " + listener + " conversaion: " + conversation));
                    }
                    ReceiveListenerDispatcher.getInstance(conversation.getConversationType(), conversation.isOnClientSide()).queueDataReceivedInvocation(this.connection, listener, data, this.primaryHeaderFields.segmentType, this.conversationHeaderFields.requestNumber, this.primaryHeaderFields.priority, this.primaryHeaderFields.isPooled, this.primaryHeaderFields.isExchange, (Conversation)conversation);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Entry " + this.conversationHeaderFields.requestNumber + " in request table has null listener"));
                    }
                    this.connection.invalidate(true, null, "no receive listener for conversation " + this.conversationHeaderFields.requestNumber);
                }
            } else {
                ConversationReceiveListener listener = conversation.getDefaultReceiveListener();
                if (listener == null) {
                    this.connection.invalidate(true, null, "no default receive listener");
                } else {
                    ReceiveListenerDispatcher.getInstance(conversation.getConversationType(), conversation.isOnClientSide()).queueDataReceivedInvocation(this.connection, listener, data, this.primaryHeaderFields.segmentType, this.conversationHeaderFields.requestNumber, this.primaryHeaderFields.priority, this.primaryHeaderFields.isPooled, this.primaryHeaderFields.isExchange, (Conversation)conversation);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dispatchToConversationListenerMethod");
        }
    }

    private void reset() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"reset");
        }
        this.throwable = null;
        this.state = 0;
        this.unparsedPrimaryHeader.position(0);
        this.unparsedPrimaryHeader.limit(10);
        this.unparsedConversationHeader.position(0);
        this.unparsedConversationHeader.limit(4);
        this.unparsedFirstSegment.position(0);
        this.unparsedFirstSegment.limit(12);
        this.unparsedPayloadData = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"reset");
        }
    }

    private WsByteBuffer readData(WsByteBuffer unparsedData, WsByteBuffer scratchArea) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readData", (Object)new Object[]{unparsedData, scratchArea});
        }
        int scratchAreaRemaining = scratchArea.remaining();
        int scratchAreaUsed = scratchArea.position();
        WsByteBuffer retBuffer = null;
        if (scratchAreaUsed == 0 && unparsedData.remaining() >= scratchAreaRemaining) {
            retBuffer = unparsedData;
        } else {
            int amountCopied = JFapUtils.copyWsByteBuffer(unparsedData, scratchArea, scratchAreaRemaining);
            if (amountCopied >= scratchAreaRemaining) {
                retBuffer = scratchArea;
                retBuffer.flip();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readData", (Object)retBuffer);
        }
        return retBuffer;
    }

    private WsByteBuffer allocateWsByteBuffer(int size, boolean fromPool) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"allocateWsByteBuffer", (Object)new Object[]{"" + size, "" + fromPool});
        }
        WsByteBuffer retBuffer = null;
        if (fromPool) {
            retBuffer = WsByteBufferPool.getInstance().allocate(size);
        } else {
            byte[] wrapArray = new byte[size];
            retBuffer = WsByteBufferPool.getInstance().wrap(wrapArray);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"allocateWsByteBuffer", (Object)retBuffer);
        }
        return retBuffer;
    }

    protected void setType(Conversation.ConversationType type) {
        this.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFormattedBytes(WsByteBuffer buff) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getFormattedBytes", null);
        }
        int currentPosition = buff.position();
        int currentLimit = buff.limit();
        buff.rewind();
        try {
            if (buff.hasArray()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((Object)this, (TraceComponent)tc, (String)"getFormattedBytes", null);
                }
                String string = SibTr.formatBytes((byte[])buff.array(), (int)(buff.arrayOffset() + buff.position()), (int)buff.remaining());
                return string;
            }
            byte[] dataArray = new byte[buff.remaining()];
            buff.get(dataArray);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getFormattedBytes", null);
            }
            String string = SibTr.formatBytes((byte[])dataArray, (int)0, (int)dataArray.length);
            return string;
        }
        finally {
            buff.position(currentPosition);
            buff.limit(currentLimit);
        }
    }

    private static class BadReceiveListener
    implements ConversationReceiveListener {
        private BadReceiveListener() {
        }

        @Override
        public ConversationReceiveListener dataReceived(WsByteBuffer data, int segmentType, int requestNumber, int priority, boolean allocatedFromBufferPool, boolean partOfExchange, Conversation conversation) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"BadReceiveListener.dataReceived");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"BadReceiveListener.dataReceived");
            }
            return null;
        }

        @Override
        public void errorOccurred(SIConnectionLostException exception, int segmentType, int requestNumber, int priority, Conversation conversation) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"BadReceiveListener.errorOccurred");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)exception));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"BadReceiveListener.errorOccurred");
            }
        }

        @Override
        public Dispatchable getThreadContext(Conversation conversation, WsByteBuffer data, int segmentType) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"BadReceiveListener.getThreadContext");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"BadReceiveListener.getThreadContext");
            }
            return null;
        }
    }

    private static class SegmentedTransmissionHeaderFields {
        private long totalLength;
        private int segmentType;

        private SegmentedTransmissionHeaderFields() {
        }
    }

    private static class ConversationHeaderFields {
        private int conversationId;
        private int requestNumber;

        private ConversationHeaderFields() {
        }
    }

    private static class PrimaryHeaderFields {
        int segmentLength;
        int priority;
        boolean isPooled;
        boolean isExchange;
        int packetNumber;
        int segmentType;

        private PrimaryHeaderFields() {
        }
    }
}

