/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.jfapchannel.SendListener;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBuffer;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBufferPool;
import com.ibm.ws.sib.jfapchannel.framework.IOWriteCompletedCallback;
import com.ibm.ws.sib.jfapchannel.framework.IOWriteRequestContext;
import com.ibm.ws.sib.jfapchannel.framework.NetworkConnection;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.ConversationImpl;
import com.ibm.ws.sib.jfapchannel.impl.PriorityQueue;
import com.ibm.ws.sib.jfapchannel.impl.TransmissionData;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ConnectionWriteCompletedCallback
implements IOWriteCompletedCallback {
    private static final TraceComponent tc = SibTr.register(ConnectionWriteCompletedCallback.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private PriorityQueue priorityQueue = null;
    private IOWriteRequestContext writeCtx;
    private Connection connection;
    private boolean idle = true;
    private boolean terminate = false;
    private boolean connectionClosed = false;
    private Object connectionClosedLock = new Object();
    private List<SendListener> inflightSendListeners = new ArrayList<SendListener>();
    private List<ConversationImpl> inflightConversations = new ArrayList<ConversationImpl>();
    private TransmissionData partiallySentTransmission = null;
    private boolean firstInvocation = true;

    public ConnectionWriteCompletedCallback(PriorityQueue priorityQueue, IOWriteRequestContext x, Connection connection) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{priorityQueue, x, connection});
        }
        this.priorityQueue = priorityQueue;
        this.writeCtx = x;
        this.connection = connection;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void proddle() throws SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"proddle");
        }
        boolean writeOnThisThread = false;
        PriorityQueue priorityQueue = this.priorityQueue;
        synchronized (priorityQueue) {
            ConnectionWriteCompletedCallback connectionWriteCompletedCallback = this;
            synchronized (connectionWriteCompletedCallback) {
                if (this.idle && !this.terminate) {
                    boolean bl = this.idle = !this.isWorkAvailable();
                    if (!this.idle) {
                        writeOnThisThread = true;
                    }
                }
            }
        }
        if (writeOnThisThread) {
            WsByteBuffer writeBuffer = this.writeCtx.getBuffer();
            if (this.firstInvocation || writeBuffer == null) {
                this.firstInvocation = false;
                int writeBufferSize = Integer.parseInt(RuntimeInfo.getProperty((String)"com.ibm.ws.sib.jfapchannel.DEFAULT_WRITE_BUFFER_SIZE", (String)"32768"));
                if (writeBuffer == null || !writeBuffer.isDirect() || writeBuffer.capacity() < writeBufferSize) {
                    if (writeBuffer != null) {
                        writeBuffer.release();
                    }
                    writeBuffer = WsByteBufferPool.getInstance().allocateDirect(writeBufferSize);
                    this.writeCtx.setBuffer(writeBuffer);
                }
            }
            writeBuffer.clear();
            if (this.dequeueTransmissionData(writeBuffer)) {
                writeBuffer.flip();
                this.idle = false;
                NetworkConnection vc = null;
                Object object = this.connectionClosedLock;
                synchronized (object) {
                    if (!this.connectionClosed) {
                        if (this.connection.isLoggingIOEvents()) {
                            this.connection.getConnectionEventRecorder().logDebug("invoking writeCtx.write() on context " + System.identityHashCode(this.writeCtx) + " to write all data with no timeout");
                        }
                        vc = this.writeCtx.write(0, this, false, -1);
                    }
                }
                if (vc != null) {
                    this.complete(vc, this.writeCtx);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"proddle");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete(NetworkConnection vc, IOWriteRequestContext wctx) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"complete", (Object)new Object[]{vc, wctx});
        }
        if (this.connection.isLoggingIOEvents()) {
            this.connection.getConnectionEventRecorder().logDebug("complete method invoked on write context " + System.identityHashCode(wctx));
        }
        try {
            boolean done = true;
            do {
                done = true;
                boolean error = false;
                int sendListeners = this.inflightSendListeners.size();
                for (int index = 0; index < sendListeners && !error; ++index) {
                    SendListener sendListener = this.inflightSendListeners.get(index);
                    if (sendListener == null) continue;
                    try {
                        sendListener.dataSent(this.inflightConversations.get(index));
                        continue;
                    }
                    catch (Throwable t) {
                        FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.sib.jfapchannel.impl.ConnectionWriteCompletedCallback", (String)"00060002", (Object)this.connection.getDiagnostics(true));
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"exception invoking send listener data sent");
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.exception((TraceComponent)tc, (Throwable)t);
                        }
                        this.connection.invalidate(true, t, "send listener threw exception");
                        error = true;
                    }
                }
                this.inflightSendListeners.clear();
                this.inflightConversations.clear();
                if (error) {
                    done = true;
                    this.partiallySentTransmission = null;
                    continue;
                }
                done = false;
                WsByteBuffer writeBuffer = null;
                Object object = this.priorityQueue;
                synchronized (object) {
                    ConnectionWriteCompletedCallback connectionWriteCompletedCallback = this;
                    synchronized (connectionWriteCompletedCallback) {
                        if (this.terminate) {
                            this.idle = true;
                        } else {
                            writeBuffer = this.writeCtx.getBuffer();
                            if (this.firstInvocation || writeBuffer == null) {
                                this.firstInvocation = false;
                                int writeBufferSize = Integer.parseInt(RuntimeInfo.getProperty((String)"com.ibm.ws.sib.jfapchannel.DEFAULT_WRITE_BUFFER_SIZE", (String)"32768"));
                                if (writeBuffer == null || !writeBuffer.isDirect() || writeBuffer.capacity() < writeBufferSize) {
                                    if (writeBuffer != null) {
                                        writeBuffer.release();
                                    }
                                    writeBuffer = WsByteBufferPool.getInstance().allocateDirect(writeBufferSize);
                                    this.writeCtx.setBuffer(writeBuffer);
                                }
                            }
                            this.idle = !this.isWorkAvailable();
                        }
                    }
                }
                if (done |= this.idle) continue;
                writeBuffer.clear();
                if (!this.dequeueTransmissionData(writeBuffer)) continue;
                writeBuffer.flip();
                vc = null;
                object = this.connectionClosedLock;
                synchronized (object) {
                    if (!this.connectionClosed) {
                        if (this.connection.isLoggingIOEvents()) {
                            this.connection.getConnectionEventRecorder().logDebug("invoking writeCtx.write() on context " + System.identityHashCode(this.writeCtx) + " to write all data with no timeout");
                        }
                        vc = this.writeCtx.write(0, this, false, -1);
                    }
                }
                boolean bl = done = vc == null;
            } while (!done);
        }
        catch (SIConnectionDroppedException connectionDroppedException) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught SIConnectionDroppedException, Priority Queue has been purged");
            }
        }
        catch (Error error) {
            FFDCFilter.processException((Throwable)error, (String)"com.ibm.ws.sib.jfapchannel.impl.ConnectionWriteCompletedCallback", (String)"00060004", (Object)this.connection.getDiagnostics(true));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Throwable)error);
            }
            this.connection.invalidate(false, error, "Error caught in ConnectionWriteCompletedCallback.complete()");
            throw error;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.sib.jfapchannel.impl.ConnectionWriteCompletedCallback", (String)"00060006", (Object)this.connection.getDiagnostics(true));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)runtimeException);
            }
            this.connection.invalidate(false, runtimeException, "RuntimeException caught in ConnectionWriteCompletedCallback.complete()");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"complete");
        }
    }

    @Override
    public void error(NetworkConnection vc, IOWriteRequestContext wrc, IOException t) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"error", (Object)new Object[]{vc, wrc, t});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled() && t != null) {
            SibTr.exception((Object)this, (TraceComponent)tc, (Exception)t);
        }
        if (this.connection.isLoggingIOEvents()) {
            this.connection.getConnectionEventRecorder().logDebug("error method invoked on write context " + System.identityHashCode(wrc) + " with exception " + t);
        }
        try {
            IOWriteRequestContext req = this.writeCtx;
            WsByteBuffer[] buffers = req.getBuffers();
            if (buffers != null) {
                for (WsByteBuffer buffer : buffers) {
                    try {
                        buffer.release();
                    }
                    catch (RuntimeException e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught exception on releasing buffer.", (Object)e);
                    }
                }
                req.setBuffers(null);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Request has no buffers: " + req));
            }
            String message = "IOException received - " + t == null ? "" : t.getMessage();
            this.connection.invalidate(false, t, message);
        }
        catch (Error error) {
            FFDCFilter.processException((Throwable)error, (String)"com.ibm.ws.sib.jfapchannel.impl.ConnectionWriteCompletedCallback", (String)"00060002", (Object)this.connection.getDiagnostics(true));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Throwable)error);
            }
            this.connection.invalidate(false, error, "Error caught in ConnectionWriteCompletedCallback.error()");
            throw error;
        }
        catch (RuntimeException runtimeException) {
            FFDCFilter.processException((Throwable)runtimeException, (String)"com.ibm.ws.sib.jfapchannel.impl.ConnectionWriteCompletedCallback", (String)"00060007", (Object)this.connection.getDiagnostics(true));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)runtimeException);
            }
            this.connection.invalidate(false, runtimeException, "RuntimeException caught in ConnectionWriteCompletedCallback.error()");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void physicalCloseNotification() {
        Object object = this.connectionClosedLock;
        synchronized (object) {
            this.connectionClosed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dequeueTransmissionData(WsByteBuffer bufferToFill) throws SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dequeueTransmissionData", (Object)bufferToFill);
        }
        boolean exhausedTransmissionsToSend = false;
        boolean dataCopied = false;
        do {
            ConnectionWriteCompletedCallback connectionWriteCompletedCallback;
            PriorityQueue priorityQueue = this.priorityQueue;
            synchronized (priorityQueue) {
                connectionWriteCompletedCallback = this;
                synchronized (connectionWriteCompletedCallback) {
                    if (this.partiallySentTransmission == null) {
                        this.partiallySentTransmission = this.priorityQueue.dequeue();
                    }
                }
            }
            if (this.partiallySentTransmission == null) {
                exhausedTransmissionsToSend = true;
                continue;
            }
            boolean finishedThisTransmission = this.partiallySentTransmission.buildTransmission(bufferToFill);
            dataCopied = true;
            if (!finishedThisTransmission) continue;
            this.terminate = this.partiallySentTransmission.isTerminal();
            if (this.partiallySentTransmission.getSendListener() != null) {
                this.inflightSendListeners.add(this.partiallySentTransmission.getSendListener());
                this.inflightConversations.add((ConversationImpl)this.partiallySentTransmission.getConversation());
            }
            this.partiallySentTransmission.release();
            connectionWriteCompletedCallback = this;
            synchronized (connectionWriteCompletedCallback) {
                this.partiallySentTransmission = null;
            }
        } while (!exhausedTransmissionsToSend && !this.terminate && bufferToFill.remaining() > 0);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dequeueTransmissionData", (Object)("" + dataCopied));
        }
        return dataCopied;
    }

    private boolean isWorkAvailable() throws SIConnectionDroppedException {
        return this.partiallySentTransmission != null || !this.priorityQueue.isEmpty();
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.jfapchannel.client.common.impl/src/com/ibm/ws/sib/jfapchannel/impl/ConnectionWriteCompletedCallback.java, SIB.comms, WASX.SIB, uu1215.01 1.46");
        }
    }
}

