/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.channelfw.FlowType;
import com.ibm.websphere.channelfw.osgi.ChannelFactoryProvider;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.sib.comms.CommsClientServiceFacadeInterface;
import com.ibm.ws.sib.jfapchannel.ClientConnectionManager;
import com.ibm.ws.sib.jfapchannel.impl.CommsClientServiceFacade;
import com.ibm.ws.sib.jfapchannel.impl.octracker.OutboundConnectionTracker;
import com.ibm.ws.sib.jfapchannel.richclient.impl.JFapChannelFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.channelfw.ChannelConfiguration;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.exception.ChainException;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class CommsOutboundChain {
    private static final TraceComponent tc = Tr.register(CommsOutboundChain.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final String _OutboundChain_ConfigAlias = "wasJmsOutbound";
    private String _chainName = null;
    private String _tcpChannelName = null;
    private String _jfapChannelName = null;
    private String _sslChannelName = null;
    private ChannelConfiguration _tcpOptions = null;
    private final AtomicServiceReference<ChannelConfiguration> _sslOptions = new AtomicServiceReference("sslOptions");
    private final AtomicServiceReference<ChannelFactoryProvider> _sslFactoryProvider = new AtomicServiceReference("sslSupport");
    private CommsClientServiceFacadeInterface _commsClientService = null;
    private volatile boolean _isChainStarted = false;
    private volatile boolean _isSSLEnabled = false;
    private volatile boolean _isSSLChain = false;
    private volatile boolean _isActivated = false;
    private final Object _chainActionLock = new Object();
    private final Runnable destroyChainAction = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Trivial
        public void run() {
            Object object = CommsOutboundChain.this._chainActionLock;
            synchronized (object) {
                block6: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("CommsOutboundChain: Destorying " + (CommsOutboundChain.this._isSSLChain ? "Secure" : "Non-Secure") + " chain "), (Object)CommsOutboundChain.this._chainName);
                    }
                    try {
                        CommsOutboundChain.this.destroyJFAPChain();
                    }
                    catch (Exception e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                        SibTr.debug((TraceComponent)tc, (String)"Exception in destorying chain", (Object)e);
                    }
                }
            }
        }
    };
    private final Runnable createChainAction = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Trivial
        public void run() {
            Object object = CommsOutboundChain.this._chainActionLock;
            synchronized (object) {
                block6: {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("CommsOutboundChain: Creating " + (CommsOutboundChain.this._isSSLChain ? "Secure" : "Non-Secure") + " chain "), (Object)CommsOutboundChain.this._chainName);
                    }
                    try {
                        CommsOutboundChain.this.createJFAPChain();
                    }
                    catch (Exception e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block6;
                        SibTr.debug((TraceComponent)tc, (String)"Exception in creating chain", (Object)e);
                    }
                }
            }
        }
    };

    protected void activate(Map<String, Object> properties, ComponentContext context) {
        String Outboundname;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"activate");
        }
        this._sslOptions.activate(context);
        this._sslFactoryProvider.activate(context);
        this._isSSLChain = MetatypeUtils.parseBoolean((Object)_OutboundChain_ConfigAlias, (String)"useSSL", (Object)properties.get("useSSL"), (boolean)false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Chain is configured for  " + (this._isSSLChain ? "Secure " : "Non-Secure")));
        }
        this._chainName = Outboundname = (String)properties.get("id");
        this._tcpChannelName = Outboundname + "_JfapTcp";
        this._sslChannelName = Outboundname + "_JfapSsl";
        this._jfapChannelName = Outboundname + "_JfapJfap";
        if (this._isChainStarted) {
            this.performAction(this.destroyChainAction);
        }
        this.performAction(this.createChainAction);
        this._isActivated = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"activate");
        }
    }

    @Trivial
    protected void setCommsClientService(CommsClientServiceFacadeInterface service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"setCommsClientService", (Object[])new Object[]{service});
        }
        this._commsClientService = service;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"setCommsClientService");
        }
    }

    @Trivial
    protected void unsetCommsClientService(CommsClientServiceFacadeInterface service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"unsetCommsClientService", (Object[])new Object[]{service});
        }
        this._commsClientService = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"unsetCommsClientService");
        }
    }

    @Trivial
    protected void setTcpOptions(ChannelConfiguration service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"setTcpOptions", (Object[])new Object[]{service});
        }
        this._tcpOptions = service;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setTcpOptions", (Object)this._tcpOptions);
        }
    }

    @Trivial
    protected void unsetTcpOptions(ServiceReference<ChannelConfiguration> service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"unsetTcpOptions", (Object[])new Object[]{service});
        }
        this._tcpOptions = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unsetTcpOptions");
        }
    }

    private Map<String, Object> getTcpOptions() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getTcpOptions", (Object[])new Object[0]);
        }
        Map tcpOptions = null;
        if (this._tcpOptions == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"getTcpOptions() returning NULL as __tcpOptions.getService() returned NUll _tcpOptions: ", (Object)this._tcpOptions);
            }
        } else {
            tcpOptions = this._tcpOptions.getConfiguration();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTcpOptions", (Object)tcpOptions);
        }
        return tcpOptions;
    }

    @Trivial
    protected void setSslSupport(ServiceReference<ChannelFactoryProvider> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"setSslSupport", (Object[])new Object[]{ref.getProperty("type"), ref});
        }
        this._isSSLEnabled = true;
        if (this._sslFactoryProvider.getReference() != null && this._isChainStarted) {
            this.performAction(this.destroyChainAction);
        }
        this._sslFactoryProvider.setReference(ref);
        if (this._isActivated && this._isSSLChain) {
            if (this._isChainStarted) {
                this.performAction(this.destroyChainAction);
            }
            this.performAction(this.createChainAction);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setSslSupport", (Object)this._isSSLEnabled);
        }
    }

    @Trivial
    public void unsetSslSupport(ServiceReference<ChannelFactoryProvider> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"unsetSslSupport", (Object[])new Object[]{ref.getProperty("type"), ref});
        }
        if (this._sslFactoryProvider.getReference() == ref && this._isSSLChain && this._isChainStarted) {
            this.performAction(this.destroyChainAction);
        }
        if (this._sslFactoryProvider.unsetReference(ref)) {
            this._isSSLEnabled = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unsetSslSupport", (Object)this._isSSLEnabled);
        }
    }

    @Trivial
    protected void setSslOptions(ServiceReference<ChannelConfiguration> service) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"setSslOptions", (Object[])new Object[]{service});
        }
        if (this._sslOptions.getReference() != null && this._isChainStarted) {
            this.performAction(this.destroyChainAction);
        }
        this._sslOptions.setReference(service);
        if (this._isActivated && this._isSSLChain) {
            if (this._isChainStarted) {
                this.performAction(this.destroyChainAction);
            }
            this.performAction(this.createChainAction);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setSslOptions");
        }
    }

    @Trivial
    protected void unsetSslOptions(ServiceReference<ChannelConfiguration> unbindServiceRef) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"unsetSslOptions", (Object[])new Object[]{unbindServiceRef});
        }
        if (this._sslOptions.getReference() == unbindServiceRef && this._isSSLChain && this._isChainStarted) {
            this.performAction(this.destroyChainAction);
        }
        this._sslOptions.unsetReference(unbindServiceRef);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unsetSslOptions");
        }
    }

    private Map<String, Object> getSslOptions() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getSslOptions", (Object[])new Object[0]);
        }
        ChannelConfiguration chanCnfgService = (ChannelConfiguration)this._sslOptions.getService();
        Map sslOptions = null;
        if (null != chanCnfgService) {
            sslOptions = chanCnfgService.getConfiguration();
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"getSslOptions() returning NULL as _sslOptions.getService() returned NUll _sslOptions: ", this._sslOptions);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSslOptions", (Object)sslOptions);
        }
        return sslOptions;
    }

    private void createJFAPChain() throws ChannelException, ChainException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createJFAPChain", (Object)this._isChainStarted);
        }
        if (!this._isChainStarted) {
            try {
                ChannelData jfapChannel;
                ChannelFramework cfw = CommsClientServiceFacade.getChannelFramewrok();
                cfw.registerFactory("JFapChannelOutbound", JFapChannelFactory.class);
                Map<String, Object> tcpOptions = this.getTcpOptions();
                ChannelData tcpChannel = cfw.getChannel(this._tcpChannelName);
                if (tcpChannel == null) {
                    String typeName = (String)tcpOptions.get("type");
                    tcpChannel = cfw.addChannel(this._tcpChannelName, cfw.lookupFactory(typeName), new HashMap<String, Object>(tcpOptions));
                }
                if (this._isSSLChain) {
                    Map<String, Object> sslOptions = this.getSslOptions();
                    if (sslOptions == null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"_sslOptions service is not bound which is required for secure chain,so no point continuing");
                        }
                        throw new ChainException(new Throwable(nls.getFormattedMessage("missingSslOptions.ChainNotStarted", new Object[]{this._chainName}, null)));
                    }
                    if (!this._isSSLEnabled) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"_sslFactoryProvider service is not bound which is required for secure chain,so no point continuing");
                        }
                        throw new ChainException(new Throwable(nls.getFormattedMessage("missingSslOptions.ChainNotStarted", new Object[]{this._chainName}, null)));
                    }
                    ChannelData sslChannel = cfw.getChannel(this._sslChannelName);
                    if (sslChannel == null) {
                        sslChannel = cfw.addChannel(this._sslChannelName, cfw.lookupFactory("SSLChannel"), new HashMap<String, Object>(sslOptions));
                    }
                }
                if ((jfapChannel = cfw.getChannel(this._jfapChannelName)) == null) {
                    jfapChannel = cfw.addChannel(this._jfapChannelName, cfw.lookupFactory("JFapChannelOutbound"), null);
                }
                String[] chanList = this._isSSLChain ? new String[]{this._jfapChannelName, this._sslChannelName, this._tcpChannelName} : new String[]{this._jfapChannelName, this._tcpChannelName};
                ChainData cd = cfw.addChain(this._chainName, FlowType.OUTBOUND, chanList);
                cd.setEnabled(true);
                this._isChainStarted = true;
            }
            catch (ChannelException e) {
                this._isChainStarted = false;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("JFAP Outbound chain " + this._chainName + " failed to get started"));
                }
                throw e;
            }
            catch (ChainException e) {
                this._isChainStarted = false;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("JFAP Outbound chain " + this._chainName + " failed to get started"));
                }
                throw e;
            }
            finally {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createJFAPChain ", (Object)this._isChainStarted);
                }
            }
            if (this._isSSLChain) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("JFAP Outbound secure chain" + this._chainName + " successfully started "));
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("JFAP Outbound chain" + this._chainName + " successfully started "));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChannel(String channelName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeChannel", (Object)channelName);
        }
        ChannelFramework cfw = CommsClientServiceFacade.getChannelFramewrok();
        try {
            if (cfw.getChannel(channelName) != null) {
                cfw.removeChannel(channelName);
            }
        }
        catch (ChannelException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Error removing channel " + channelName), (Object)((Object)e));
            }
        }
        catch (ChainException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Error removing channel " + channelName), (Object)((Object)e));
            }
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeChannel");
            }
        }
    }

    protected void deactivate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"CommsClientServiceFacade deactivated, reason=", (Object[])new Object[0]);
        }
        this.performAction(this.destroyChainAction);
        this._sslOptions.deactivate(context);
        this._sslFactoryProvider.deactivate(context);
        this._isActivated = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyJFAPChain() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroyJFAPChain", (Object[])new Object[0]);
        }
        Object object = this._chainActionLock;
        synchronized (object) {
            try {
                this.terminateConnectionsAssociatedWithChain();
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Failure in terminating conservations and physical connections while destroying chain : " + this._chainName), (Object)e);
                }
            }
            finally {
                this._isChainStarted = false;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroyJFAPChain", (Object)this._isChainStarted);
        }
    }

    private void performAction(Runnable action) {
        action.run();
    }

    private void terminateConnectionsAssociatedWithChain() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"terminateConnectionsAssociatedWithChain", (Object[])new Object[0]);
        }
        ChannelFramework cfw = CommsClientServiceFacade.getChannelFramewrok();
        OutboundConnectionTracker oct = ClientConnectionManager.getRef().getOutboundConnectionTracker();
        if (oct != null) {
            oct.terminateConnectionsAssociatedWithChain(this._chainName);
        } else if (cfw.getChain(this._chainName) != null) {
            cfw.getOutboundVCFactory(this._chainName).destroy();
        }
        ChainData cd = cfw.getChain(this._chainName);
        if (cd != null) {
            cfw.removeChain(cd);
        }
        this.removeChannel(this._tcpChannelName);
        if (this._isSSLChain) {
            this.removeChannel(this._sslChannelName);
        }
        this.removeChannel(this._jfapChannelName);
    }
}

