/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security.config.tss;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.xml.internal.nester.Nester;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.security.config.tss.OptionsKey;
import com.ibm.ws.transport.iiop.security.config.tss.TSSASMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSCompoundSecMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSCompoundSecMechListConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSGSSExportedNameConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSGSSUPMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSGeneralNameConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSITTAbsent;
import com.ibm.ws.transport.iiop.security.config.tss.TSSITTAnonymous;
import com.ibm.ws.transport.iiop.security.config.tss.TSSITTDistinguishedName;
import com.ibm.ws.transport.iiop.security.config.tss.TSSITTPrincipalNameGSSUP;
import com.ibm.ws.transport.iiop.security.config.tss.TSSITTX509CertChain;
import com.ibm.ws.transport.iiop.security.config.tss.TSSNULLASMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSNULLTransportConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSSASMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSSSLTransportConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSTransportMechConfig;
import com.ibm.ws.transport.iiop.security.util.HelperConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.omg.CSIIOP.TransportAddress;
import org.osgi.framework.Bundle;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TSSConfigHelper
implements HelperConstants {
    private static final String CSIV2_CONFIGURATION = "csiv2Configuration";
    private static final String PRIVILEGE_AUTHORITY = "privilegeAuthority";
    private static final String GENERAL_NAME = "generalName";
    private static final String TARGET_NAME = "targetName";
    private static final String REQUIRED = "required";
    private static final String IDENTITY_TOKEN_TYPES = "identityTokenTypes";
    private static final String SERVICE_CONFIGURATION_LIST = "serviceConfigurationList";
    static final long serialVersionUID = -5980153257558162594L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static TSSConfig getTSSConfig(Map<String, Object> props, Map<OptionsKey, List<TransportAddress>> addrMap, Bundle bundle) throws Exception {
        TSSConfig tssConfig = new TSSConfig();
        List<Map<String, Object>> tssConfigs = Nester.nest(CSIV2_CONFIGURATION, props);
        if (!tssConfigs.isEmpty()) {
            Map<String, Object> properties = tssConfigs.get(0);
            List<Map<String, Object>> mechList = Nester.nest("compoundSecMech", properties);
            TSSCompoundSecMechListConfig mechListConfig = tssConfig.getMechListConfig();
            mechListConfig.setStateful((Boolean)properties.get("stateful"));
            for (Map<String, Object> mech : mechList) {
                TSSCompoundSecMechConfig cMech = TSSConfigHelper.extractCompoundSecMech(mech, addrMap, bundle);
                mechListConfig.add(cMech);
            }
        }
        return tssConfig;
    }

    protected static TSSTransportMechConfig extractSSL(Map<String, Object> sslConfigProps, Map<OptionsKey, List<TransportAddress>> addrMap) {
        TSSSSLTransportConfig sslConfig = new TSSSSLTransportConfig();
        sslConfig.setSupports(TSSConfigHelper.extractAssociationOptions((String[])sslConfigProps.get("supports")));
        sslConfig.setRequires(TSSConfigHelper.extractAssociationOptions((String[])sslConfigProps.get("requires")));
        OptionsKey key = new OptionsKey(sslConfig.getSupports(), sslConfig.getRequires());
        List<TransportAddress> addresses = addrMap.get(key);
        if (addresses == null) {
            throw new IllegalStateException("No transport addressses configured for supports: " + sslConfigProps.get("supports") + " and requires: " + sslConfigProps.get("requires"));
        }
        sslConfig.setTransportAddresses(addresses);
        return sslConfig;
    }

    public static Map<OptionsKey, List<TransportAddress>> extractTransportAddresses(Map<String, Object> properties) {
        List<Map<String, Object>> listOfAddrProps = Nester.nest("transportAddress", properties);
        return TSSConfigHelper.extractTransportAddresses(listOfAddrProps);
    }

    protected static Map<OptionsKey, List<TransportAddress>> extractTransportAddresses(List<Map<String, Object>> listOfAddrProps) {
        HashMap<OptionsKey, List<TransportAddress>> mapOfAddr = new HashMap<OptionsKey, List<TransportAddress>>();
        for (Map<String, Object> addrProps : listOfAddrProps) {
            short requires;
            short supports = TSSConfigHelper.extractAssociationOptions((String[])addrProps.get("supports"));
            OptionsKey key = new OptionsKey(supports, requires = TSSConfigHelper.extractAssociationOptions((String[])addrProps.get("requires")));
            ArrayList<TransportAddress> addrs = (ArrayList<TransportAddress>)mapOfAddr.get(key);
            if (addrs == null) {
                addrs = new ArrayList<TransportAddress>();
                mapOfAddr.put(key, addrs);
            }
            addrs.add(new TransportAddress((String)addrProps.get("host"), ((Short)addrProps.get("port")).shortValue()));
        }
        return mapOfAddr;
    }

    protected static TSSCompoundSecMechConfig extractCompoundSecMech(Map<String, Object> mech, Map<OptionsKey, List<TransportAddress>> addrMap, Bundle bundle) throws Exception {
        Map<String, List<Map<String, Object>>> mechInfo = Nester.nest(mech, "csiv2SSLOptions", "GSSUP", "sasMech");
        TSSCompoundSecMechConfig result = new TSSCompoundSecMechConfig();
        List<Map<String, Object>> transportMechGroups = mechInfo.get("csiv2SSLOptions");
        if (!transportMechGroups.isEmpty()) {
            Map<String, Object> transportMechGroup = transportMechGroups.get(0);
            result.setTransport_mech(TSSConfigHelper.extractSSL(transportMechGroup, addrMap));
        } else {
            result.setTransport_mech(new TSSNULLTransportConfig());
        }
        List<Map<String, Object>> gssups = mechInfo.get("GSSUP");
        if (!gssups.isEmpty()) {
            result.setAs_mech(TSSConfigHelper.extractASMech(gssups.get(0)));
        } else {
            result.setAs_mech(new TSSNULLASMechConfig());
        }
        List<Map<String, Object>> sasMechs = mechInfo.get("sasMech");
        if (!sasMechs.isEmpty()) {
            result.setSas_mech(TSSConfigHelper.extractSASMech(sasMechs.get(0), bundle));
        }
        return result;
    }

    protected static TSSASMechConfig extractASMech(Map<String, Object> gssupMech) {
        TSSGSSUPMechConfig gssupConfig = new TSSGSSUPMechConfig();
        gssupConfig.setTargetName((String)gssupMech.get(TARGET_NAME));
        gssupConfig.setRequired((Boolean)gssupMech.get(REQUIRED));
        return gssupConfig;
    }

    /*
     * WARNING - void declaration
     */
    protected static TSSSASMechConfig extractSASMech(Map<String, Object> sasMech, Bundle bundle) throws Exception {
        List<Map<String, Object>> identityTokenTypesList;
        Map<String, List<Map<String, Object>>> mechInfo = Nester.nest(sasMech, SERVICE_CONFIGURATION_LIST, IDENTITY_TOKEN_TYPES);
        TSSSASMechConfig sasMechConfig = new TSSSASMechConfig();
        List<Map<String, Object>> serviceConfigurationLists = mechInfo.get(SERVICE_CONFIGURATION_LIST);
        if (!serviceConfigurationLists.isEmpty()) {
            Map<String, Object> serviceConfigurationList = serviceConfigurationLists.get(0);
            sasMechConfig.setRequired((Boolean)serviceConfigurationList.get(REQUIRED));
            Map<String, List<Map<String, Object>>> namePropsMap = Nester.nest(serviceConfigurationList, GENERAL_NAME);
            for (Map<String, Object> generalName : namePropsMap.get(GENERAL_NAME)) {
                String type = (String)generalName.get("config.referenceType");
                if ("com.ibm.ws.transport.iiop.tssGeneralName".equals(type)) {
                    sasMechConfig.addServiceConfigurationConfig(new TSSGeneralNameConfig((String)generalName.get(PRIVILEGE_AUTHORITY)));
                    continue;
                }
                if ("com.ibm.ws.transport.iiop.tssGSSExportedName".equals(type)) {
                    sasMechConfig.addServiceConfigurationConfig(new TSSGSSExportedNameConfig((String)generalName.get(PRIVILEGE_AUTHORITY), (String)generalName.get("oid")));
                    continue;
                }
                throw new IllegalStateException("Unrecognized service configuration: " + type);
            }
        }
        if ((identityTokenTypesList = mechInfo.get(IDENTITY_TOKEN_TYPES)).isEmpty()) {
            sasMechConfig.addIdentityToken(new TSSITTAbsent());
        } else {
            Map<String, Object> identitytokenTypes = identityTokenTypesList.get(0);
            List<Map<String, Object>> sasInfos = Nester.nest("ittGroup", identitytokenTypes);
            if (sasInfos.isEmpty()) {
                sasMechConfig.addIdentityToken(new TSSITTAbsent());
            } else {
                for (Map<String, Object> sasInfo : sasInfos) {
                    String type = (String)sasInfo.get("config.referenceType");
                    if ("com.ibm.ws.transport.iiop.tssIttAbsent".equals(type)) {
                        sasMechConfig.addIdentityToken(new TSSITTAbsent());
                        continue;
                    }
                    if ("com.ibm.ws.transport.iiop.tssIttAnonymous".equals(type)) {
                        sasMechConfig.addIdentityToken(new TSSITTAnonymous());
                        continue;
                    }
                    if ("com.ibm.ws.transport.iiop.tssIttPrincipalNameGSSUP".equals(type)) {
                        Class principalClass;
                        String principalClassName = (String)sasInfo.get("principal-class");
                        try {
                            principalClass = bundle.loadClass(principalClassName);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            void e;
                            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.transport.iiop.security.config.tss.TSSConfigHelper", (String)"248", null, (Object[])new Object[]{sasMech, bundle});
                            throw new Exception("Could not load principal class", (Throwable)e);
                        }
                        String domainName = (String)sasInfo.get("domain");
                        String realmName = null;
                        if (domainName != null) {
                            realmName = (String)sasInfo.get("realm");
                        }
                        try {
                            sasMechConfig.addIdentityToken(new TSSITTPrincipalNameGSSUP(principalClass, realmName, domainName));
                            continue;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            void e;
                            FFDCFilter.processException((Throwable)noSuchMethodException, (String)"com.ibm.ws.transport.iiop.security.config.tss.TSSConfigHelper", (String)"260", null, (Object[])new Object[]{sasMech, bundle});
                            throw new Exception("Could not find principal class constructor", (Throwable)e);
                        }
                    }
                    if ("com.ibm.ws.transport.iiop.tssIttDistinguishedName".equals(type)) {
                        sasMechConfig.addIdentityToken(new TSSITTDistinguishedName(null, null));
                        continue;
                    }
                    if (!"com.ibm.ws.transport.iiop.tssIttX509CertChain".equals(type)) continue;
                    sasMechConfig.addIdentityToken(new TSSITTX509CertChain(null, null));
                }
            }
        }
        return sasMechConfig;
    }

    protected static short extractAssociationOptions(String[] list) {
        short result = 0;
        if (list != null) {
            for (String string : list) {
                HelperConstants.AssociationOptions obj = HelperConstants.AssociationOptions.valueOf(string);
                if (HelperConstants.AssociationOptions.NoProtection.equals((Object)obj)) {
                    result = (short)(result | 1);
                    continue;
                }
                if (HelperConstants.AssociationOptions.Integrity.equals((Object)obj)) {
                    result = (short)(result | 2);
                    continue;
                }
                if (HelperConstants.AssociationOptions.Confidentiality.equals((Object)obj)) {
                    result = (short)(result | 4);
                    continue;
                }
                if (HelperConstants.AssociationOptions.DetectReplay.equals((Object)obj)) {
                    result = (short)(result | 8);
                    continue;
                }
                if (HelperConstants.AssociationOptions.DetectMisordering.equals((Object)obj)) {
                    result = (short)(result | 0x10);
                    continue;
                }
                if (HelperConstants.AssociationOptions.EstablishTrustInTarget.equals((Object)obj)) {
                    result = (short)(result | 0x20);
                    continue;
                }
                if (HelperConstants.AssociationOptions.EstablishTrustInClient.equals((Object)obj)) {
                    result = (short)(result | 0x40);
                    continue;
                }
                if (HelperConstants.AssociationOptions.NoDelegation.equals((Object)obj)) {
                    result = (short)(result | 0x80);
                    continue;
                }
                if (HelperConstants.AssociationOptions.SimpleDelegation.equals((Object)obj)) {
                    result = (short)(result | 0x100);
                    continue;
                }
                if (!HelperConstants.AssociationOptions.CompositeDelegation.equals((Object)obj)) continue;
                result = (short)(result | 0x200);
            }
        }
        return result;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(TSSConfigHelper.class);
    }
}

