/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.security.config.css;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.xml.internal.nester.Nester;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.iiop.security.config.css.CSSASMechConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSCompoundSecMechConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSCompoundSecMechListConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSGSSUPMechConfigDynamic;
import com.ibm.ws.transport.iiop.security.config.css.CSSGSSUPMechConfigStatic;
import com.ibm.ws.transport.iiop.security.config.css.CSSNULLASMechConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSNULLTransportConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSSASITTAbsent;
import com.ibm.ws.transport.iiop.security.config.css.CSSSASITTAnonymous;
import com.ibm.ws.transport.iiop.security.config.css.CSSSASITTPrincipalNameDynamic;
import com.ibm.ws.transport.iiop.security.config.css.CSSSASITTPrincipalNameStatic;
import com.ibm.ws.transport.iiop.security.config.css.CSSSASMechConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSSSLTransportConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSTransportMechConfig;
import com.ibm.ws.transport.iiop.security.util.HelperConstants;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CSSConfigHelper
implements HelperConstants {
    private static final String AS_GSSUP_DYNAMIC = "com.ibm.ws.transport.iiop.cssGSSUPDynamic";
    private static final String AS_GSSUP_STATIC = "com.ibm.ws.transport.iiop.cssGSSUPStatic";
    private static final String AS_MECH_GROUP = "asMechGroup";
    static final long serialVersionUID = -1161233348555229955L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static CSSConfig getCSSConfig(Map<String, Object> properties, Bundle bundle) throws Exception {
        CSSConfig cssConfig = new CSSConfig();
        List<Map<String, Object>> compoundSecurityMechLists = Nester.nest("csiv2Configuration", properties);
        if (!compoundSecurityMechLists.isEmpty()) {
            Map<String, Object> compoundSecurityMechList = compoundSecurityMechLists.get(0);
            CSSCompoundSecMechListConfig mechListConfig = cssConfig.getMechList();
            mechListConfig.setStateful((Boolean)compoundSecurityMechList.get("stateful"));
            List<Map<String, Object>> mechList = Nester.nest("compoundSecMech", compoundSecurityMechList);
            for (Map<String, Object> mech : mechList) {
                mechListConfig.add(CSSConfigHelper.extractCompoundSecMech(mech, bundle));
            }
        }
        return cssConfig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static CSSCompoundSecMechConfig extractCompoundSecMech(Map<String, Object> mechType, Bundle bundle) throws Exception {
        Map<String, List<Map<String, Object>>> mechInfo = Nester.nest(mechType, "csiv2SSLOptions", AS_MECH_GROUP, "sasMech");
        CSSCompoundSecMechConfig result = new CSSCompoundSecMechConfig();
        List<Map<String, Object>> sslOptionsList = mechInfo.get("csiv2SSLOptions");
        if (!sslOptionsList.isEmpty()) {
            Map<String, Object> sslOptions = sslOptionsList.get(0);
            result.setTransport_mech(CSSConfigHelper.extractSSLTransport(sslOptions));
        } else {
            result.setTransport_mech(new CSSNULLTransportConfig());
        }
        List<Map<String, Object>> gssups = mechInfo.get(AS_MECH_GROUP);
        if (!gssups.isEmpty()) {
            Map<String, Object> gssup = gssups.get(0);
            String type = (String)gssup.get("config.referenceType");
            if (AS_GSSUP_STATIC.equals(type)) {
                result.setAs_mech(CSSConfigHelper.extractGSSUPStatic(gssup));
            } else {
                if (!AS_GSSUP_DYNAMIC.equals(type)) throw new IllegalStateException("Unrecognized gssup type " + type);
                result.setAs_mech(CSSConfigHelper.extractGSSUPDynamic(gssup));
            }
        } else {
            result.setAs_mech(new CSSNULLASMechConfig());
        }
        List<Map<String, Object>> sasMechs = mechInfo.get("sasMech");
        result.setSas_mech(CSSConfigHelper.extractSASMech(sasMechs, bundle));
        return result;
    }

    protected static CSSTransportMechConfig extractSSLTransport(Map<String, Object> sslConfig) {
        CSSSSLTransportConfig result = new CSSSSLTransportConfig();
        result.setSupports(CSSConfigHelper.extractAssociationOptions((String[])sslConfig.get("supports")));
        result.setRequires(CSSConfigHelper.extractAssociationOptions((String[])sslConfig.get("requires")));
        return result;
    }

    protected static CSSASMechConfig extractGSSUPStatic(Map<String, Object> gssupType) {
        SerializableProtectedString password = (SerializableProtectedString)gssupType.get("password");
        return new CSSGSSUPMechConfigStatic((String)gssupType.get("username"), password, (String)gssupType.get("domain"));
    }

    protected static CSSASMechConfig extractGSSUPDynamic(Map<String, Object> gssupType) {
        return new CSSGSSUPMechConfigDynamic((String)gssupType.get("domain"));
    }

    /*
     * WARNING - void declaration
     */
    protected static CSSSASMechConfig extractSASMech(List<Map<String, Object>> sasMechTypes, Bundle bundle) throws Exception {
        CSSSASMechConfig result = new CSSSASMechConfig();
        if (sasMechTypes.isEmpty()) {
            result.setIdentityToken(new CSSSASITTAbsent());
        } else {
            Map<String, Object> sasMechType = sasMechTypes.get(0);
            List<Map<String, Object>> sasInfos = Nester.nest("ittGroup", sasMechType);
            if (sasInfos.isEmpty()) {
                result.setIdentityToken(new CSSSASITTAbsent());
            } else {
                Map<String, Object> sasInfo = sasInfos.get(0);
                String type = (String)sasInfo.get("config.referenceType");
                if ("com.ibm.ws.transport.iiop.cssIttAbsent".equals(type)) {
                    result.setIdentityToken(new CSSSASITTAbsent());
                } else if ("com.ibm.ws.transport.iiop.cssIttAnonymous".equals(type)) {
                    result.setIdentityToken(new CSSSASITTAnonymous());
                } else if ("com.ibm.ws.transport.iiop.cssIttPrincipalNameStatic".equals(type)) {
                    result.setIdentityToken(new CSSSASITTPrincipalNameStatic((String)sasInfo.get("oid"), (String)sasInfo.get("name")));
                } else if ("com.ibm.ws.transport.iiop.cssIttPrincipalNameDynamic".equals(type)) {
                    String principalClassName = (String)sasInfo.get("principal-class");
                    Class principalClass = null;
                    try {
                        principalClass = bundle.loadClass(principalClassName);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        void e;
                        FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.transport.iiop.security.config.css.CSSConfigHelper", (String)"148", null, (Object[])new Object[]{sasMechTypes, bundle});
                        throw new IllegalStateException("Could not load principal class", (Throwable)e);
                    }
                    String domainName = (String)sasInfo.get("domain");
                    String realmName = null;
                    if (domainName != null) {
                        realmName = (String)sasInfo.get("realm");
                    }
                    result.setIdentityToken(new CSSSASITTPrincipalNameDynamic((String)sasInfo.get("oid"), principalClass, domainName, realmName));
                }
            }
        }
        return result;
    }

    protected static short extractAssociationOptions(String[] list) {
        short result = 0;
        for (String string : list) {
            HelperConstants.AssociationOptions obj = HelperConstants.AssociationOptions.valueOf(string);
            if (HelperConstants.AssociationOptions.NoProtection.equals((Object)obj)) {
                result = (short)(result | 1);
                continue;
            }
            if (HelperConstants.AssociationOptions.Integrity.equals((Object)obj)) {
                result = (short)(result | 2);
                continue;
            }
            if (HelperConstants.AssociationOptions.Confidentiality.equals((Object)obj)) {
                result = (short)(result | 4);
                continue;
            }
            if (HelperConstants.AssociationOptions.DetectReplay.equals((Object)obj)) {
                result = (short)(result | 8);
                continue;
            }
            if (HelperConstants.AssociationOptions.DetectMisordering.equals((Object)obj)) {
                result = (short)(result | 0x10);
                continue;
            }
            if (HelperConstants.AssociationOptions.EstablishTrustInTarget.equals((Object)obj)) {
                result = (short)(result | 0x20);
                continue;
            }
            if (HelperConstants.AssociationOptions.EstablishTrustInClient.equals((Object)obj)) {
                result = (short)(result | 0x40);
                continue;
            }
            if (HelperConstants.AssociationOptions.NoDelegation.equals((Object)obj)) {
                result = (short)(result | 0x80);
                continue;
            }
            if (HelperConstants.AssociationOptions.SimpleDelegation.equals((Object)obj)) {
                result = (short)(result | 0x100);
                continue;
            }
            if (!HelperConstants.AssociationOptions.CompositeDelegation.equals((Object)obj)) continue;
            result = (short)(result | 0x200);
        }
        return result;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(CSSConfigHelper.class);
    }
}

