/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.classsource.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.anno.classsource.internal.ClassSourceImpl;
import com.ibm.ws.anno.classsource.internal.ClassSourceImpl_Factory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.classsource.ClassSource;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.anno.classsource.ClassSource_ClassLoader;
import com.ibm.wsspi.anno.classsource.ClassSource_Exception;
import com.ibm.wsspi.anno.classsource.ClassSource_Streamer;
import com.ibm.wsspi.anno.util.Util_InternMap;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClassSourceImpl_ClassLoader
extends ClassSourceImpl
implements ClassSource,
ClassSource_ClassLoader {
    public static final String CLASS_NAME = ClassSourceImpl_ClassLoader.class.getName();
    private static final TraceComponent tc = Tr.register(ClassSourceImpl_ClassLoader.class);
    protected final ClassLoader classLoader;
    static final long serialVersionUID = 3475371013417420159L;

    public ClassSourceImpl_ClassLoader(ClassSourceImpl_Factory factory, Util_InternMap internMap, String name, ClassLoader classLoader) {
        super(factory, internMap, name, String.valueOf(classLoader));
        this.classLoader = classLoader;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)this.hashText, (Object[])new Object[0]);
        }
    }

    @Override
    @Trivial
    public void open() throws ClassSource_Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] ENTER/RETURN", this.getHashText()), (Object[])new Object[0]);
        }
    }

    @Override
    @Trivial
    public void close() throws ClassSource_Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] ENTER/RETURN", this.getHashText()), (Object[])new Object[0]);
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void scanClasses(ClassSource_Streamer streamer, Set<String> i_seedClassNamesSet, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InputStream openResourceStream(String className, String resourceName) throws ClassSource_Exception {
        String methodName = "openResourceStream";
        ClassLoader useClassLoader = this.getClassLoader();
        URL url = useClassLoader.getResource(resourceName);
        if (url == null) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_ClassLoader", (String)"107", (Object)this, (Object[])new Object[]{className, resourceName});
            String eMsg = "[ " + this.getHashText() + " ] Failed to open resource [ " + resourceName + " ] for class [ " + className + " ]";
            throw this.getFactory().wrapIntoClassSourceException(CLASS_NAME, methodName, eMsg, (Throwable)e);
        }
    }

    @Override
    public void closeResourceStream(String className, String resourceName, InputStream inputStream) {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl_ClassLoader", (String)"124", (Object)this, (Object[])new Object[]{className, resourceName, inputStream});
            Tr.warning((TraceComponent)tc, (String)"ANNO_CLASSSOURCE_CLOSE2_EXCEPTION", (Object[])new Object[]{this.getHashText(), resourceName, className});
        }
    }

    @Override
    @Trivial
    public void log(TraceComponent logger) {
        if (logger.isDebugEnabled()) {
            Tr.debug((TraceComponent)logger, (String)MessageFormat.format("Class Source [ {0} ]", this.getHashText()), (Object[])new Object[0]);
        }
    }
}

