/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.web.liberty;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.CDIService;
import com.ibm.ws.cdi.CDIServiceUtils;
import com.ibm.ws.cdi.interfaces.CDIRuntime;
import com.ibm.ws.cdi.web.interfaces.CDIWebRuntime;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.webcontainer.facade.ServletContextFacade;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import javax.enterprise.inject.spi.BeanManager;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.cdi.web.liberty.CDIWebRuntimeImpl", service={CDIWebRuntime.class}, immediate=true, property={"service.vendor=IBM"})
public class CDIWebRuntimeImpl
implements CDIWebRuntime {
    private static final TraceComponent tc = Tr.register(CDIWebRuntimeImpl.class);
    private final AtomicServiceReference<CDIService> cdiServiceRef = new AtomicServiceReference("cdiService");
    static final long serialVersionUID = 6029799425921863614L;

    protected void activate(ComponentContext context) {
        this.cdiServiceRef.activate(context);
    }

    protected void deactivate(ComponentContext context) {
        this.cdiServiceRef.deactivate(context);
    }

    @Reference(name="cdiService", service=CDIService.class)
    protected void setCdiService(ServiceReference<CDIService> ref) {
        this.cdiServiceRef.setReference(ref);
    }

    protected void unsetCdiService(ServiceReference<CDIService> ref) {
        this.cdiServiceRef.unsetReference(ref);
    }

    private CDIRuntime getCDIRuntime() {
        CDIService cdiService = (CDIService)this.cdiServiceRef.getService();
        CDIRuntime cdiRuntime = (CDIRuntime)cdiService;
        return cdiRuntime;
    }

    @Override
    public boolean isCdiEnabled(IServletContext isc) {
        Object cdiEnabled;
        boolean cdiOn = false;
        while (isc instanceof ServletContextFacade) {
            isc = ((ServletContextFacade)isc).getIServletContext();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"checking to see whether cdi is enabled", (Object[])new Object[0]);
        }
        cdiOn = (cdiEnabled = isc.getAttribute("com.ibm.ws.cdi.cdiEnabledApp")) != null ? ((Boolean)cdiEnabled).booleanValue() : this.setCdiEnabled(isc);
        return cdiOn;
    }

    private boolean setCdiEnabled(IServletContext isc) {
        boolean cdiOn = false;
        while (isc instanceof ServletContextFacade) {
            isc = ((ServletContextFacade)isc).getIServletContext();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"checking to see whether cdi is enabled", (Object[])new Object[0]);
        }
        try {
            ModuleMetaData moduleMetaData = CDIServiceUtils.getModuleMetaData((Container)isc.getModuleContainer());
            cdiOn = this.getCDIRuntime().isModuleCDIEnabled(moduleMetaData);
        }
        catch (CDIException moduleMetaData) {
            FFDCFilter.processException((Throwable)moduleMetaData, (String)"com.ibm.ws.cdi.web.liberty.CDIWebRuntimeImpl", (String)"105", (Object)this, (Object[])new Object[]{isc});
            cdiOn = Boolean.FALSE;
        }
        isc.setAttribute("com.ibm.ws.cdi.cdiEnabledApp", (Object)cdiOn);
        WebAppConfig webAppConfig = isc.getWebAppConfig();
        webAppConfig.setJCDIEnabled(cdiOn);
        return cdiOn;
    }

    @Override
    public BeanManager getModuleBeanManager(ModuleMetaData moduleMetaData) {
        return this.getCDIRuntime().getModuleBeanManager(moduleMetaData);
    }

    @Override
    public BeanManager getCurrentBeanManager() {
        return this.getCDIRuntime().getCurrentBeanManager();
    }
}

