/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.web.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.web.impl.WeldTerminalAsyncListener;
import com.ibm.ws.cdi.web.interfaces.CDIWebRuntime;
import com.ibm.ws.cdi.web.interfaces.PostEventListenerProvider;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.async.AsyncContextImpl;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import java.util.EventListener;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.servlet.WeldInitialListener;
import org.jboss.weld.servlet.WeldTerminalListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class AbstractTerminalListenerRegistration
implements PostEventListenerProvider {
    private static final TraceComponent tc = Tr.register(AbstractTerminalListenerRegistration.class);
    private final AtomicServiceReference<CDIWebRuntime> cdiWebRuntimeRef = new AtomicServiceReference("cdiWebRuntime");
    static final long serialVersionUID = 544849196047737933L;

    protected void activate(ComponentContext context) {
        this.cdiWebRuntimeRef.activate(context);
    }

    protected void deactivate(ComponentContext context) {
        this.cdiWebRuntimeRef.deactivate(context);
    }

    @Reference(name="cdiWebRuntime", service=CDIWebRuntime.class)
    protected void setCdiWebRuntime(ServiceReference<CDIWebRuntime> ref) {
        this.cdiWebRuntimeRef.setReference(ref);
    }

    protected void unsetCdiWebRuntime(ServiceReference<CDIWebRuntime> ref) {
        this.cdiWebRuntimeRef.unsetReference(ref);
    }

    @Override
    public void registerListener(IServletContext isc) {
        BeanManager beanManager;
        CDIWebRuntime cdiWebRuntime = (CDIWebRuntime)this.cdiWebRuntimeRef.getService();
        if (cdiWebRuntime != null && cdiWebRuntime.isCdiEnabled(isc) && (beanManager = cdiWebRuntime.getCurrentBeanManager()) != null) {
            BeanManagerImpl beanManagerImpl = null;
            if (beanManager instanceof BeanManagerProxy) {
                BeanManagerProxy proxy = (BeanManagerProxy)beanManager;
                beanManagerImpl = proxy.delegate();
            } else if (beanManager instanceof BeanManagerImpl) {
                beanManagerImpl = (BeanManagerImpl)beanManager;
            } else {
                throw new RuntimeException("Unexpected beanManager instance.");
            }
            isc.addListener((EventListener)new WeldTerminalListener(beanManagerImpl));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"added WeldTerminalListener to the servlet context", (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void registerListener(IServletContext isc, AsyncContextImpl ac) {
        Object obj = isc.getAttribute("org.jboss.weld.servlet.WeldInitialListener");
        if (obj != null) {
            WeldInitialListener wl = (WeldInitialListener)obj;
            WeldTerminalAsyncListener asyncListener = new WeldTerminalAsyncListener(wl, (ServletContext)isc);
            ac.addListener((AsyncListener)asyncListener, (ServletRequest)ac.getIExtendedRequest(), (ServletResponse)ac.getIExtendedResponse());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"added WeldInitialAsyncListener to the asyncContext", (Object[])new Object[0]);
            }
        }
    }
}

