/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.singleton;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collective.singleton.ServiceEndpointIdentity;
import com.ibm.wsspi.collective.singleton.SingletonService;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ServiceEndpointIdentityImpl
implements ServiceEndpointIdentity {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(ServiceEndpointIdentityImpl.class);
    private String hostName;
    private String userDir;
    private String serverName;
    private int port;
    private String serviceName;
    private SingletonService.SingletonScope serviceScope = SingletonService.SingletonScope.HOST;
    private final int version = 1;
    public static final ServiceEndpointIdentity NULL_IDENTITY = new ServiceEndpointIdentityImpl("", "", "", 0, "", SingletonService.SingletonScope.HOST);

    public ServiceEndpointIdentityImpl(String hostName, String userDir, String serverName, int port, String serviceName, SingletonService.SingletonScope serviceScope) {
        this.hostName = hostName;
        this.userDir = userDir;
        this.serverName = serverName;
        this.port = port;
        this.serviceName = serviceName;
        this.serviceScope = serviceScope;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hostName == null ? 0 : this.hostName.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.serverName == null ? 0 : this.serverName.hashCode());
        result = 31 * result + (this.serviceName == null ? 0 : this.serviceName.hashCode());
        result = 31 * result + (this.serviceScope == null ? 0 : this.serviceScope.hashCode());
        result = 31 * result + (this.userDir == null ? 0 : this.userDir.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceEndpointIdentityImpl)) {
            return false;
        }
        ServiceEndpointIdentityImpl other = (ServiceEndpointIdentityImpl)obj;
        if (this.hostName == null ? other.hostName != null : !this.hostName.equals(other.hostName)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.serverName == null ? other.serverName != null : !this.serverName.equals(other.serverName)) {
            return false;
        }
        if (this.serviceName == null ? other.serviceName != null : !this.serviceName.equals(other.serviceName)) {
            return false;
        }
        if (this.serviceScope != other.serviceScope) {
            return false;
        }
        return !(this.userDir == null ? other.userDir != null : !this.userDir.equals(other.userDir));
    }

    public ServiceEndpointIdentityImpl() {
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getUserDir() {
        return this.userDir;
    }

    public void setUserDir(String userDir) {
        this.userDir = userDir;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public boolean isNull() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ServiceIdentity.isNull - NULL_IDENTITY=" + NULL_IDENTITY), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("ServiceIdentity.isNull - compare with: " + this), (Object[])new Object[0]);
        }
        return this.equals(NULL_IDENTITY);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("host=" + this.hostName);
        s.append("; userdir=" + this.userDir);
        s.append("; server=" + this.serverName);
        s.append("; port=" + this.port);
        s.append("; service=" + this.serviceName);
        s.append("; scope=" + this.serviceScope.toString());
        return s.toString();
    }

    public String toCanonicalForm() throws IOException {
        Properties p = new Properties();
        if (this.hostName == null) {
            this.hostName = "";
        }
        if (this.userDir == null) {
            this.userDir = "";
        }
        if (this.serverName == null) {
            this.serverName = "";
        }
        if (this.serviceName == null) {
            this.serviceName = "";
        }
        p.put("host", this.hostName);
        p.put("userdir", this.userDir);
        p.put("server", this.serverName);
        p.put("service", this.serviceName);
        p.put("port", String.valueOf(this.port));
        p.put("version", String.valueOf(1));
        p.put("scope", this.serviceScope.toString());
        StringWriter wtr = new StringWriter();
        p.store(wtr, "");
        return wtr.toString();
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={IOException.class})
    public void fromCanonicalForm(String value) throws IllegalArgumentException {
        StringReader rdr = new StringReader(value);
        Properties p = new Properties();
        try {
            p.load(rdr);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            void e;
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.collective.singleton.ServiceEndpointIdentityImpl", (String)"258", (Object)this, (Object[])new Object[]{value});
            throw new IllegalArgumentException("Parameter is not a valid canonical form", (Throwable)e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Parameter is not a valid canonical form", e);
        }
        this.hostName = p.getProperty("host");
        this.userDir = p.getProperty("userdir");
        this.serverName = p.getProperty("server");
        this.port = Integer.valueOf(p.getProperty("port"));
        this.serviceName = p.getProperty("service");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("scope property=" + p.getProperty("scope")), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("compare with SingletonScope.HOST=" + SingletonService.SingletonScope.HOST), (Object[])new Object[0]);
        }
        this.serviceScope = p.getProperty("scope").equals(SingletonService.SingletonScope.HOST.toString()) ? SingletonService.SingletonScope.HOST : SingletonService.SingletonScope.COLLECTIVE;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("serviceScope=" + this.serviceScope), (Object[])new Object[0]);
        }
    }

    public SingletonService.SingletonScope getServiceScope() {
        return this.serviceScope;
    }

    protected void setServiceScope(SingletonService.SingletonScope sc) {
        this.serviceScope = sc;
    }
}

