/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.impl;

import java.lang.ref.SoftReference;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;

public class SimpleRotatingSoftQueue<T>
implements Queue<T> {
    private final ArrayList<SoftReference<T>> elements;
    private final int QUEUE_SIZE;
    private final AtomicInteger tailIndex = new AtomicInteger(0);

    public SimpleRotatingSoftQueue(T[] elements) {
        if (elements == null || elements.length == 0) {
            throw new IllegalArgumentException("elements array must not be null or zero-length");
        }
        this.QUEUE_SIZE = elements.length;
        this.elements = new ArrayList(this.QUEUE_SIZE);
        for (T element : elements) {
            SoftReference<T> elementItem = new SoftReference<T>(element);
            this.elements.add(elementItem);
        }
    }

    @Override
    public boolean add(T element) {
        SoftReference<T> elementItem = new SoftReference<T>(element);
        this.elements.set(this.getAndUpdateTail(), elementItem);
        return true;
    }

    private int getAndUpdateTail() {
        int retMe;
        while (!this.tailIndex.compareAndSet(retMe = this.tailIndex.get(), this.getNext(retMe))) {
        }
        return retMe;
    }

    private int getNext(int index) {
        return ++index == this.elements.size() ? 0 : index;
    }

    @Override
    public <T> T[] toArray(T[] arr) {
        Object[] retMe;
        int currTailIndex;
        if (arr == null) {
            return null;
        }
        do {
            currTailIndex = this.tailIndex.get();
            ArrayList<T> returnArrayList = new ArrayList<T>();
            int i = 0;
            int index = currTailIndex;
            while (i < this.elements.size()) {
                T element = this.elements.get(index %= this.elements.size()).get();
                if (element != null) {
                    returnArrayList.add(element);
                }
                ++i;
                ++index;
            }
            retMe = (Object[])Array.newInstance(arr.getClass().getComponentType(), returnArrayList.size());
            returnArrayList.toArray(retMe);
        } while (!this.tailIndex.compareAndSet(currTailIndex, currTailIndex));
        return retMe;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T poll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T element() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T peek() {
        throw new UnsupportedOperationException();
    }
}

