/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.client.configuration;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.ProxyServerType;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LibertyJaxRsClientProxyInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final TraceComponent tc = Tr.register(LibertyJaxRsClientProxyInterceptor.class);
    static final long serialVersionUID = -7330065620117847560L;

    public LibertyJaxRsClientProxyInterceptor(String phase) {
        super(phase);
    }

    public void handleMessage(Message message) throws Fault {
        String sHost;
        Object host = message.get((Object)"com.ibm.ws.jaxrs.client.proxy.host");
        Object port = message.get((Object)"com.ibm.ws.jaxrs.client.proxy.port");
        Object type = message.get((Object)"com.ibm.ws.jaxrs.client.proxy.type");
        Conduit conduit = message.getExchange().getConduit(message);
        if (host != null && !(sHost = host.toString()).isEmpty()) {
            this.configClientProxy(conduit, sHost, port, type);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void configClientProxy(Conduit conduit, String host, Object port, Object type) {
        if (conduit instanceof HTTPConduit) {
            HTTPConduit httpConduit = (HTTPConduit)conduit;
            int iPort = 80;
            if (port != null) {
                String sPort = port.toString();
                try {
                    iPort = Integer.parseInt(sPort);
                }
                catch (NumberFormatException numberFormatException) {
                    void e;
                    FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jaxrs20.client.configuration.LibertyJaxRsClientProxyInterceptor", (String)"68", (Object)((Object)this), (Object[])new Object[]{conduit, host, port, type});
                    Tr.error((TraceComponent)tc, (String)"error.jaxrs.client.configuration.proxy.portinvalid", (Object[])new Object[]{sPort, "com.ibm.ws.jaxrs.client.proxy.port", 80, e.getMessage()});
                }
            }
            ProxyServerType proxyServerType = ProxyServerType.HTTP;
            if (type != null) {
                String sType = type.toString();
                try {
                    proxyServerType = ProxyServerType.valueOf((String)sType.toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    void e;
                    FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.jaxrs20.client.configuration.LibertyJaxRsClientProxyInterceptor", (String)"82", (Object)((Object)this), (Object[])new Object[]{conduit, host, port, type});
                    Tr.error((TraceComponent)tc, (String)"error.jaxrs.client.configuration.proxy.typeinvalid", (Object[])new Object[]{sType, "com.ibm.ws.jaxrs.client.proxy.type", ProxyServerType.HTTP, e.getMessage()});
                }
            }
            httpConduit.getClient().setProxyServer(host);
            httpConduit.getClient().setProxyServerPort(iPort);
            httpConduit.getClient().setProxyServerType(proxyServerType);
        }
    }
}

