/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.ConcurrentLinkedList;
import com.ibm.ws.objectManager.InternalTransaction;
import com.ibm.ws.objectManager.InvalidStateException;
import com.ibm.ws.objectManager.LinkedList;
import com.ibm.ws.objectManager.LogFileFullException;
import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.ObjectStore;
import com.ibm.ws.objectManager.PermanentIOException;
import com.ibm.ws.objectManager.SimplifiedSerializationSizeException;
import com.ibm.ws.objectManager.StateErrorException;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.objectManager.TransactionCheckpointLogRecord;
import com.ibm.ws.objectManager.TransactionOptimisticReplaceLogRecord;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;

class ConcurrentSubList
extends LinkedList {
    private static final Class cclass = ConcurrentSubList.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerLists");
    private static final long serialVersionUID = -6402774319655418538L;
    protected Token concurrentListToken;
    private static final byte SimpleSerialVersion = 0;

    protected ConcurrentSubList(Token concurrentListToken, Transaction transaction, ObjectStore objectStore) throws ObjectManagerException {
        String methodName = "<init>";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{concurrentListToken, transaction, objectStore});
        }
        this.concurrentListToken = concurrentListToken;
        objectStore.allocate(this);
        this.reservedSpaceInStore = ConcurrentSubList.maximumSerializedSize() + (long)this.owningToken.objectStore.getAddSpaceOverhead();
        this.owningToken.objectStore.reserve((int)this.reservedSpaceInStore, true);
        transaction.add(this);
        this.owningToken.objectStore.reserve(-((int)this.reservedSpaceInStore), false);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    static long logSpaceForAdd() {
        return TransactionOptimisticReplaceLogRecord.maximumSerializedSize() + 4L + ConcurrentSubList.maximumSerializedSize() + 2L * Link.maximumSerializedSize() + TransactionCheckpointLogRecord.maximumSerializedSize() + 4L + Token.maximumSerializedSize() * 3L;
    }

    static long logSpaceForDelete() {
        return TransactionOptimisticReplaceLogRecord.maximumSerializedSize() + 4L + Token.maximumSerializedSize() * 1L + ConcurrentSubList.maximumSerializedSize() + 2L * Link.maximumSerializedSize() + TransactionCheckpointLogRecord.maximumSerializedSize() + 4L + Token.maximumSerializedSize() * 4L;
    }

    @Override
    long storeSpaceForRemove() {
        return ConcurrentSubList.maximumSerializedSize() + 2L * Link.maximumSerializedSize() + (long)(3 * this.owningToken.objectStore.getAddSpaceOverhead());
    }

    @Override
    long storeSpaceForAdd() {
        return ConcurrentSubList.maximumSerializedSize() + 3L * Link.maximumSerializedSize() + (long)(4 * this.owningToken.objectStore.getAddSpaceOverhead()) + this.storeSpaceForRemove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Link addEntry(Token token, Transaction transaction, long sequenceNumber) throws ObjectManagerException {
        Link newLink;
        String methodName = "addEntry";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "addEntry", new Object[]{token, transaction, new Long(sequenceNumber)});
        }
        ConcurrentSubList concurrentSubList = this;
        synchronized (concurrentSubList) {
            if (!(this.state == 8 || this.state == 2 && this.lockedBy(transaction))) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "addEntry", new Object[]{new Integer(this.state), stateNames[this.state]});
                }
                throw new InvalidStateException((Object)this, this.state, stateNames[this.state]);
            }
            this.managedObjectsToAdd.clear();
            this.managedObjectsToReplace.clear();
            this.reservedSpaceInStore = this.storeSpaceForAdd();
            this.owningToken.objectStore.reserve((int)this.reservedSpaceInStore, false);
            Token previousToken = this.tail;
            Link previousLink = null;
            while (previousToken != null) {
                previousLink = (Link)previousToken.getManagedObject();
                if (previousLink.sequenceNumber <= sequenceNumber) break;
                previousToken = previousLink.previous;
            }
            Token nextToken = null;
            nextToken = previousToken == null ? this.head : previousLink.next;
            newLink = new Link(this, token, previousToken, nextToken, transaction, sequenceNumber);
            this.managedObjectsToAdd.add(newLink);
            if (previousToken == null) {
                this.availableHead = this.head = newLink.getToken();
            } else {
                previousLink.next = newLink.getToken();
                this.managedObjectsToReplace.add(previousLink);
                if (this.availableHead == null) {
                    this.availableHead = newLink.getToken();
                } else if (((Link)this.availableHead.getManagedObject()).sequenceNumber > sequenceNumber) {
                    this.availableHead = newLink.getToken();
                }
            }
            if (nextToken == null) {
                this.tail = newLink.getToken();
            } else {
                Link nextLink = (Link)nextToken.getManagedObject();
                nextLink.previous = newLink.getToken();
                this.managedObjectsToReplace.add(nextLink);
            }
            ConcurrentLinkedList concurrentLinkedList = (ConcurrentLinkedList)this.concurrentListToken.getManagedObject();
            concurrentLinkedList.tailSequenceNumberLock.unlock();
            this.incrementSize();
            this.managedObjectsToReplace.add(this);
            try {
                transaction.optimisticReplace(this.managedObjectsToAdd, this.managedObjectsToReplace, null, null, ConcurrentSubList.logSpaceForDelete());
                this.owningToken.objectStore.reserve((int)(this.storeSpaceForRemove() - this.reservedSpaceInStore), false);
            }
            catch (InvalidStateException exception) {
                this.undoAdd(newLink);
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "addEntry", exception);
                }
                throw exception;
            }
            catch (LogFileFullException exception) {
                this.undoAdd(newLink);
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "addEntry", exception);
                }
                throw exception;
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "addEntry", new Object[]{newLink});
        }
        return newLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object clone(Transaction transaction, ObjectStore objectStore) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "clone", new Object[]{transaction, objectStore});
        }
        ConcurrentSubList clonedList = new ConcurrentSubList(this.concurrentListToken, transaction, objectStore);
        InternalTransaction internalTransaction = transaction.internalTransaction;
        synchronized (internalTransaction) {
            long unlockPoint = this.getTransactionUnlockSequence();
            Link nextLink = (Link)this.nextLink(null, transaction, unlockPoint);
            while (nextLink != null) {
                clonedList.addEntry(nextLink.data, transaction, 0L);
                nextLink = (Link)this.nextLink(nextLink, transaction, unlockPoint);
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "clone", new Object[]{clonedList});
        }
        return clonedList;
    }

    @Override
    public void becomeCloneOf(ManagedObject other) {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "becomeCloneOf", "Other=" + other);
        }
        super.becomeCloneOf(other);
        this.concurrentListToken = ((ConcurrentSubList)other).concurrentListToken;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "becomeCloneOf");
        }
    }

    ConcurrentSubList() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "<init>");
            trace.exit(this, cclass, "<init>");
        }
    }

    protected static long maximumSerializedSize() {
        return 1L + LinkedList.maximumSerializedSize() + Token.maximumSerializedSize();
    }

    @Override
    public int getSignature() {
        return 8;
    }

    @Override
    public final void writeObject(DataOutputStream dataOutputStream) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "writeObject", "DataOutputStream=" + dataOutputStream);
        }
        try {
            dataOutputStream.writeByte(0);
            super.writeObject(dataOutputStream);
            this.concurrentListToken.writeObject(dataOutputStream);
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "witeObject", exception, "1:431:1.23");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "writeObject", "via PermanentIOException");
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if ((long)dataOutputStream.size() > ConcurrentSubList.maximumSerializedSize()) {
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug((Object)this, cclass, "writeObject", "maximumSerializedSize()=" + ConcurrentSubList.maximumSerializedSize() + "(long)dataOutputStream.size()=" + dataOutputStream.size() + "(int)");
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "writeObject", "via SimplifiedSerializationSizeException");
            }
            throw new SimplifiedSerializationSizeException((Object)this, ConcurrentSubList.maximumSerializedSize(), dataOutputStream.size());
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "writeObject");
        }
    }

    @Override
    public void readObject(DataInputStream dataInputStream, ObjectManagerState objectManagerState) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "readObject", "dataInputStream=" + dataInputStream + " objectManagerState=" + objectManagerState);
        }
        try {
            byte version = dataInputStream.readByte();
            if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                trace.debug((Object)this, cclass, "readObject", "version=" + version + "(byte)");
            }
            super.readObject(dataInputStream, objectManagerState);
            this.concurrentListToken = Token.restore(dataInputStream, objectManagerState);
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "readObject", exception, "1:497:1.23");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "readObject", "via PermanentIOException");
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "readObject");
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "readObject", "ObjectInputStream=" + objectInputStream);
        }
        objectInputStream.defaultReadObject();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "readObject", "via UnsupportedOperationException");
        }
        throw new UnsupportedOperationException();
    }

    static class Link
    extends LinkedList.Link {
        private static final long serialVersionUID = 1012127769762316826L;
        protected long sequenceNumber;
        private static final byte SimpleSerialVersion = 0;

        Link(ConcurrentSubList list, Token payload, Token previous, Token next, Transaction transaction, long sequenceNumber) throws ObjectManagerException {
            super(list, payload, previous, next, transaction);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "<init>", new Object[]{list, payload, previous, next, transaction, new Long(sequenceNumber)});
            }
            this.sequenceNumber = sequenceNumber;
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "<init>");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void preBackout(Transaction transaction) throws ObjectManagerException {
            String methodName = "preBackout";
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "preBackout", new Object[]{transaction});
            }
            switch (this.state) {
                case 2: {
                    ConcurrentLinkedList concurrentLinkedList = (ConcurrentLinkedList)((ConcurrentSubList)this.list).concurrentListToken.getManagedObject();
                    ConcurrentLinkedList.HeadSequenceNumberLock headSequenceNumberLock = concurrentLinkedList.headSequenceNumberLock;
                    synchronized (headSequenceNumberLock) {
                        if (this.sequenceNumber == concurrentLinkedList.headSequenceNumber) {
                            if (this.next == null) {
                                ++concurrentLinkedList.headSequenceNumber;
                            } else {
                                Link nextLink = (Link)this.next.getManagedObject();
                                if (nextLink.sequenceNumber != concurrentLinkedList.headSequenceNumber) {
                                    ++concurrentLinkedList.headSequenceNumber;
                                }
                            }
                        }
                        break;
                    }
                }
            }
            super.preBackout(transaction);
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "preBackout");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void backout(Transaction transaction, long logSequenceNumber, boolean requiresCurrentCheckpoint) throws ObjectManagerException {
            String methodName = "backout";
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "backout", new Object[]{transaction, new Long(logSequenceNumber), new Boolean(requiresCurrentCheckpoint)});
            }
            ConcurrentLinkedList concurrentLinkedList = (ConcurrentLinkedList)((ConcurrentSubList)this.list).concurrentListToken.getManagedObject();
            ConcurrentLinkedList.HeadSequenceNumberLock headSequenceNumberLock = concurrentLinkedList.headSequenceNumberLock;
            synchronized (headSequenceNumberLock) {
                switch (this.state) {
                    case 5: {
                        if (this.sequenceNumber >= concurrentLinkedList.headSequenceNumber) break;
                        concurrentLinkedList.headSequenceNumber = this.sequenceNumber;
                    }
                }
                super.backout(transaction, logSequenceNumber, requiresCurrentCheckpoint);
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "backout");
            }
        }

        @Override
        public void becomeCloneOf(ManagedObject other) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "becomeCloneOf", "Other=" + other);
            }
            super.becomeCloneOf(other);
            if (!this.backingOut) {
                Link otherLink = (Link)other;
                this.sequenceNumber = otherLink.sequenceNumber;
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "becomeCloneOf");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(Transaction transaction) throws ObjectManagerException {
            String methodName = "remove";
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "remove", new Object[]{transaction});
            }
            ConcurrentLinkedList concurrentLinkedList = (ConcurrentLinkedList)((ConcurrentSubList)this.list).concurrentListToken.getManagedObject();
            InternalTransaction internalTransaction = transaction.internalTransaction;
            synchronized (internalTransaction) {
                ConcurrentLinkedList.HeadSequenceNumberLock headSequenceNumberLock = concurrentLinkedList.headSequenceNumberLock;
                synchronized (headSequenceNumberLock) {
                    LinkedList linkedList = this.list;
                    synchronized (linkedList) {
                        if (this.state == 3) {
                            this.requestDelete(transaction);
                            this.list.decrementAvailableSize();
                        } else if (this.state == 2 && this.lockedBy(transaction)) {
                            this.requestDelete(transaction);
                        } else {
                            InvalidStateException invalidStateException = new InvalidStateException((Object)this, this.state, stateNames[this.state]);
                            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                                trace.exit((Object)this, cclass, "remove", new Object[]{invalidStateException, new Integer(this.state), stateNames[this.state]});
                            }
                            throw invalidStateException;
                        }
                        if (this.sequenceNumber == concurrentLinkedList.headSequenceNumber) {
                            concurrentLinkedList.incrementHeadSequenceNumber(this);
                        }
                    }
                }
                try {
                    transaction.delete(this, ConcurrentSubList.logSpaceForDelete());
                }
                catch (LogFileFullException exception) {
                    this.unRemove(concurrentLinkedList);
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "remove", exception);
                    }
                    throw exception;
                }
                catch (InvalidStateException exception) {
                    ObjectManager.ffdc.processException(this, cclass, "remove", exception, "1:783:1.23");
                    this.unRemove(concurrentLinkedList);
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "remove", exception);
                    }
                    throw exception;
                }
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "remove");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unRemove(ConcurrentLinkedList concurrentLinkedList) throws StateErrorException, ObjectManagerException {
            ConcurrentLinkedList.HeadSequenceNumberLock headSequenceNumberLock = concurrentLinkedList.headSequenceNumberLock;
            synchronized (headSequenceNumberLock) {
                LinkedList linkedList = this.list;
                synchronized (linkedList) {
                    this.setState(nextStateForRequestUnDelete);
                    this.list.availableHead = this.list.head;
                    this.list.skipToBeDeleted();
                    if (this.state == 3) {
                        this.list.incrementAvailableSize();
                    }
                    if (this.sequenceNumber < concurrentLinkedList.headSequenceNumber) {
                        concurrentLinkedList.headSequenceNumber = this.sequenceNumber;
                    }
                }
            }
            this.owningToken.objectStore.reserve(-((int)this.list.storeSpaceForRemove()), false);
        }

        Link() throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry(this, cclass, "<init>");
                trace.exit(this, cclass, "<init>");
            }
        }

        protected static final long maximumSerializedSize() {
            return 1L + LinkedList.Link.maximumSerializedSize() + 8L;
        }

        @Override
        public int getSignature() {
            return 9;
        }

        @Override
        public final void writeObject(DataOutputStream dataOutputStream) throws ObjectManagerException {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "writeObject", new Object[]{dataOutputStream});
            }
            try {
                dataOutputStream.writeByte(0);
                super.writeObject(dataOutputStream);
                dataOutputStream.writeLong(this.sequenceNumber);
            }
            catch (IOException exception) {
                ObjectManager.ffdc.processException(this, cclass, "witeObject", exception, "1:881:1.23");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "writeObject", "via PermanentIOException");
                }
                throw new PermanentIOException((Object)this, exception);
            }
            if ((long)dataOutputStream.size() > Link.maximumSerializedSize()) {
                if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                    trace.debug((Object)this, cclass, "writeObject", "maximumSerializedSize()=" + Link.maximumSerializedSize() + "(long)dataOutputStream.size()=" + dataOutputStream.size() + "(int)");
                }
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "writeObject", "via SimplifiedSerializationSizeException");
                }
                throw new SimplifiedSerializationSizeException((Object)this, Link.maximumSerializedSize(), dataOutputStream.size());
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "writeObject");
            }
        }

        @Override
        public void readObject(DataInputStream dataInputStream, ObjectManagerState objectManagerState) throws ObjectManagerException {
            String methodName = "readObject";
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.entry((Object)this, cclass, "readObject", new Object[]{dataInputStream, objectManagerState});
            }
            try {
                byte version = dataInputStream.readByte();
                if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
                    trace.debug((Object)this, cclass, "readObject", new Object[]{new Byte(version)});
                }
                super.readObject(dataInputStream, objectManagerState);
                this.sequenceNumber = dataInputStream.readLong();
            }
            catch (IOException exception) {
                ObjectManager.ffdc.processException(this, cclass, "readObject", exception, "1:940:1.23");
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "readObject", new Object[]{exception});
                }
                throw new PermanentIOException((Object)this, exception);
            }
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "readObject");
            }
        }
    }
}

