/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.impl.managedobject;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.impl.managedobject.CDIManagedObject;
import com.ibm.ws.cdi.impl.weld.WebSphereBeanDeploymentArchive;
import com.ibm.ws.cdi.interfaces.CDIRuntime;
import com.ibm.ws.managedobject.ManagedObject;
import com.ibm.ws.managedobject.ManagedObjectContext;
import com.ibm.ws.managedobject.ManagedObjectFactory;
import com.ibm.ws.managedobject.ManagedObjectInvocationContext;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionTarget;
import com.ibm.wsspi.injectionengine.InjectionTargetContext;
import com.ibm.wsspi.injectionengine.ReferenceContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.construction.api.WeldCreationalContext;
import org.jboss.weld.exceptions.UnsupportedOperationException;
import org.jboss.weld.manager.api.WeldInjectionTargetFactory;
import org.jboss.weld.manager.api.WeldManager;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class AbstractManagedObjectFactory<T>
implements ManagedObjectFactory<T> {
    private static final TraceComponent tc = Tr.register(AbstractManagedObjectFactory.class);
    protected final CDIRuntime cdiRuntime;
    protected final Class<T> _managedClass;
    protected Bean<T> _bean;
    protected boolean _beanLookupComplete = false;
    protected WeldManager _beanManager;
    protected WebSphereBeanDeploymentArchive _bda;
    private final boolean _requestManagingInjectionAndInterceptors;
    private ReferenceContext referenceContext = null;
    static final long serialVersionUID = 3599737862967628878L;

    public AbstractManagedObjectFactory(Class<T> classToManage, CDIRuntime cdiRuntime, boolean requestManagingInjectionAndInterceptors) {
        this._managedClass = classToManage;
        this.cdiRuntime = cdiRuntime;
        this._requestManagingInjectionAndInterceptors = requestManagingInjectionAndInterceptors;
    }

    public AbstractManagedObjectFactory(Class<T> classToManage, CDIRuntime cdiRuntime, boolean requestManagingInjectionAndInterceptors, ReferenceContext referenceContext) {
        this._managedClass = classToManage;
        this.cdiRuntime = cdiRuntime;
        this._requestManagingInjectionAndInterceptors = requestManagingInjectionAndInterceptors;
        this.referenceContext = referenceContext;
    }

    public boolean managesInjectionAndInterceptors() {
        return this._requestManagingInjectionAndInterceptors;
    }

    public Class<T> getManagedObjectClass() {
        return this._managedClass;
    }

    public boolean isManaged() {
        return true;
    }

    protected synchronized WeldManager getBeanManager() {
        if (this._beanManager == null) {
            this._beanManager = (WeldManager)this.cdiRuntime.getClassBeanManager(this.getManagedObjectClass());
            if (this._beanManager == null) {
                this._beanManager = (WeldManager)this.cdiRuntime.getCurrentModuleBeanManager();
            }
        }
        return this._beanManager;
    }

    protected synchronized WebSphereBeanDeploymentArchive getCurrentBeanDeploymentArchive() {
        if (this._bda == null) {
            this._bda = this.cdiRuntime.getClassBeanDeploymentArchive(this.getManagedObjectClass());
        }
        return this._bda;
    }

    protected synchronized Bean<T> getBean() {
        if (!this._beanLookupComplete) {
            WeldManager beanManager = this.getBeanManager();
            Set beans = beanManager.getBeans(this.getManagedObjectClass(), new Annotation[0]);
            if (beans.size() == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("No Beans found for managed class: " + this.getManagedObjectClass()), (Object[])new Object[0]);
                }
            } else {
                this._bean = beanManager.resolve(beans);
            }
            this._beanLookupComplete = true;
            if (this._bean != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found a bean of class : " + this._bean.getBeanClass()), (Object[])new Object[0]);
                }
                if (!this._bean.getBeanClass().equals(this.getManagedObjectClass())) {
                    throw new IllegalStateException("Managed Class {" + this.getManagedObjectClass().getName() + "} does not match Bean Class {" + this._bean.getBeanClass().getName() + "}");
                }
            }
        }
        return this._bean;
    }

    public String getBeanScope() {
        Bean<T> bean = this.getBean();
        String beanScope = null;
        if (bean != null) {
            beanScope = bean.getScope().getCanonicalName();
        }
        return beanScope;
    }

    public ManagedObject<T> existingInstance(T instance) {
        throw new UnsupportedOperationException();
    }

    public ManagedObjectContext createContext() {
        throw new UnsupportedOperationException();
    }

    public Constructor<T> getConstructor() {
        throw new UnsupportedOperationException();
    }

    public ManagedObject<T> createManagedObject() throws Exception {
        throw new UnsupportedOperationException();
    }

    protected javax.enterprise.inject.spi.InjectionTarget<T> getInjectionTarget(boolean nonContextual) {
        javax.enterprise.inject.spi.InjectionTarget injectionTarget = null;
        Class<T> clazz = this.getManagedObjectClass();
        WebSphereBeanDeploymentArchive bda = this.getCurrentBeanDeploymentArchive();
        if (bda != null) {
            injectionTarget = bda.getJEEComponentInjectionTarget(clazz);
        }
        if (injectionTarget == null) {
            AnnotatedType<T> annotatedType = this.getAnnotatedType(clazz, nonContextual);
            WeldManager beanManager = this.getBeanManager();
            WeldInjectionTargetFactory itFactory = beanManager.getInjectionTargetFactory(annotatedType);
            Bean<T> bean = this.getBean();
            injectionTarget = itFactory.createInjectionTarget(bean);
            if (bda != null) {
                if (bean == null) {
                    injectionTarget = beanManager.fireProcessInjectionTarget(annotatedType, injectionTarget);
                }
                bda.addJEEComponentInjectionTarget(clazz, injectionTarget);
            }
        }
        return injectionTarget;
    }

    protected AnnotatedType<T> getAnnotatedType(Class<T> clazz, boolean nonContextual) {
        WeldManager beanManager = this.getBeanManager();
        AnnotatedType annotatedType = null;
        annotatedType = nonContextual ? beanManager.createAnnotatedType(clazz, clazz.getName() + ": " + clazz.hashCode()) : beanManager.createAnnotatedType(clazz);
        return annotatedType;
    }

    protected abstract WeldCreationalContext<T> getCreationalContext(ManagedObjectInvocationContext<T> var1);

    public ManagedObject<T> createManagedObject(ManagedObjectInvocationContext<T> invocationContext) throws Exception {
        WeldManager beanManager = this.getBeanManager();
        if (beanManager != null) {
            boolean nonContextual = invocationContext == null;
            final javax.enterprise.inject.spi.InjectionTarget<T> injectionTarget = this.getInjectionTarget(nonContextual);
            final WeldCreationalContext<T> creationalContext = this.getCreationalContext(invocationContext);
            Object instance = AccessController.doPrivileged(new PrivilegedAction<T>(){
                static final long serialVersionUID = 3792764950999350447L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public T run() {
                    return injectionTarget.produce((CreationalContext)creationalContext);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
            CDIManagedObject mo = new CDIManagedObject(instance, creationalContext, injectionTarget, this.getBeanScope());
            if (this.managesInjectionAndInterceptors()) {
                this.injectAndPostConstruct(injectionTarget, creationalContext, mo);
            }
            return mo;
        }
        throw new IllegalStateException("Unable to obtain BeanManager");
    }

    private void injectAndPostConstruct(javax.enterprise.inject.spi.InjectionTarget<T> injectionTarget, WeldCreationalContext<T> creationalContext, ManagedObject<T> mo) throws InjectionException {
        this.performInjection(injectionTarget, mo, creationalContext);
        injectionTarget.postConstruct(mo.getObject());
    }

    private void performInjection(javax.enterprise.inject.spi.InjectionTarget<T> cdiInjectionTarget, final ManagedObject<T> mo, WeldCreationalContext<T> creationalContext) throws InjectionException {
        if (this.referenceContext != null) {
            InjectionTarget[] targets = this.referenceContext.getInjectionTargets(mo.getObject().getClass());
            if (null != targets && targets.length > 0) {
                InjectionTargetContext itc = new InjectionTargetContext(){
                    static final long serialVersionUID = 2252304885735264361L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    public <R> R getInjectionTargetContextData(Class<R> data) {
                        return (R)mo.getContextData(data);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(2.class);
                    }
                };
                for (InjectionTarget injectionTarget : targets) {
                    injectionTarget.inject(mo.getObject(), itc);
                }
            }
        } else {
            cdiInjectionTarget.inject(mo.getObject(), creationalContext);
        }
    }
}

