/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.support.JaxWsInstanceManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public final class ResourceUtils {
    static final long serialVersionUID = 7605869197041596778L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private ResourceUtils() {
    }

    public static Method findPostConstructMethod(Class<?> c) {
        return ResourceUtils.findPostConstructMethod(c, null);
    }

    public static Method findPostConstructMethod(Class<?> c, String name) {
        if (Object.class == c || null == c) {
            return null;
        }
        for (Method m : c.getDeclaredMethods()) {
            if (!(name != null ? m.getName().equals(name) : m.getAnnotation(PostConstruct.class) != null)) continue;
            return m;
        }
        Method m = ResourceUtils.findPostConstructMethod(c.getSuperclass(), name);
        if (m != null) {
            return m;
        }
        for (Class<?> i : c.getInterfaces()) {
            m = ResourceUtils.findPostConstructMethod(i, name);
            if (m == null) continue;
            return m;
        }
        return null;
    }

    public static Method findPreDestroyMethod(Class<?> c) {
        return ResourceUtils.findPreDestroyMethod(c, null);
    }

    public static Method findPreDestroyMethod(Class<?> c, String name) {
        if (Object.class == c || null == c) {
            return null;
        }
        for (Method m : c.getDeclaredMethods()) {
            if (!(name != null ? m.getName().equals(name) : m.getAnnotation(PreDestroy.class) != null)) continue;
            return m;
        }
        Method m = ResourceUtils.findPreDestroyMethod(c.getSuperclass(), name);
        if (m != null) {
            return m;
        }
        for (Class<?> i : c.getInterfaces()) {
            m = ResourceUtils.findPreDestroyMethod(i, name);
            if (m == null) continue;
            return m;
        }
        return null;
    }

    public static void verifySingletons(Set<Object> singletons) {
        if (singletons.isEmpty()) {
            return;
        }
        HashSet<String> map = new HashSet<String>();
        for (Object s : singletons) {
            if (map.contains(s.getClass().getName())) {
                throw new RuntimeException("More than one instance of the same singleton class " + s.getClass().getName() + " is available");
            }
            map.add(s.getClass().getName());
        }
    }

    public static boolean isNotAbstractClass(Class<?> c) {
        return !c.isInterface() && !Modifier.isAbstract(c.getModifiers());
    }

    public static void invokeLifeCycleMethod(Object instance, Method method) throws JaxWsInstanceManager.InterceptException {
        if (method != null) {
            try {
                method.invoke(instance, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                FFDCFilter.processException((Throwable)invocationTargetException, (String)"com.ibm.ws.jaxws.utils.ResourceUtils", (String)"126", null, (Object[])new Object[]{instance, method});
                String msg = "Method " + method.getName() + " can not be invoked due to InvocationTargetException";
                throw new JaxWsInstanceManager.InterceptException(msg);
            }
            catch (IllegalAccessException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.jaxws.utils.ResourceUtils", (String)"130", null, (Object[])new Object[]{instance, method});
                String msg = "Method " + method.getName() + " can not be invoked due to IllegalAccessException";
                throw new JaxWsInstanceManager.InterceptException(msg);
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ResourceUtils.class);
    }
}

