/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.support;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.clientcontainer.metadata.ClientModuleMetaData;
import com.ibm.ws.container.service.metadata.MetaDataEvent;
import com.ibm.ws.container.service.metadata.MetaDataSlotService;
import com.ibm.ws.container.service.metadata.ModuleMetaDataListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jaxws.metadata.JaxWsModuleInfo;
import com.ibm.ws.jaxws.metadata.JaxWsModuleMetaData;
import com.ibm.ws.jaxws.metadata.JaxWsModuleType;
import com.ibm.ws.jaxws.metadata.builder.JaxWsModuleInfoBuilder;
import com.ibm.ws.jaxws.support.JaxWsMetaDataManager;
import com.ibm.ws.jaxws.utils.JaxWsUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JaxWsModuleMetaDataListener
implements ModuleMetaDataListener {
    private static final TraceComponent tc = Tr.register(JaxWsModuleMetaDataListener.class);
    private final Map<JaxWsModuleType, JaxWsModuleInfoBuilder> jaxWsModuleInfoBuilderMap = new ConcurrentHashMap<JaxWsModuleType, JaxWsModuleInfoBuilder>();
    private final AtomicServiceReference<ClassLoadingService> classLoadingServiceSR = new AtomicServiceReference("classLoadingService");
    static final long serialVersionUID = -1353979631646690016L;

    /*
     * WARNING - void declaration
     */
    public void moduleMetaDataCreated(MetaDataEvent<ModuleMetaData> event) {
        ModuleMetaData mmd = (ModuleMetaData)event.getMetaData();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("moduleMetaDataCreated(" + mmd.getName() + ") : " + mmd), (Object[])new Object[0]);
        }
        if (!(mmd instanceof ClientModuleMetaData)) {
            return;
        }
        Container moduleContainer = event.getContainer();
        try {
            NonPersistentCache overlayCache = (NonPersistentCache)moduleContainer.adapt(NonPersistentCache.class);
            JaxWsModuleMetaData jaxWsModuleMetaData = (JaxWsModuleMetaData)overlayCache.getFromCache(JaxWsModuleMetaData.class);
            if (jaxWsModuleMetaData == null) {
                ClassLoader appContextClassLoader = ((ClassLoadingService)this.classLoadingServiceSR.getServiceWithException()).createThreadContextClassLoader(((ClientModuleMetaData)mmd).getModuleInfo().getClassLoader());
                jaxWsModuleMetaData = new JaxWsModuleMetaData((ClientModuleMetaData)mmd, event.getContainer(), appContextClassLoader);
                overlayCache.addToCache(JaxWsModuleMetaData.class, (Object)jaxWsModuleMetaData);
            } else {
                jaxWsModuleMetaData.getEnclosingModuleMetaDatas().add(mmd);
            }
            JaxWsMetaDataManager.setJaxWsModuleMetaData(mmd, jaxWsModuleMetaData);
            JaxWsModuleInfo jaxWsModuleInfo = (JaxWsModuleInfo)overlayCache.getFromCache(JaxWsModuleInfo.class);
            if (jaxWsModuleInfo == null) {
                if (JaxWsUtils.isWebModule(moduleContainer)) {
                    jaxWsModuleInfo = new JaxWsModuleInfo(JaxWsModuleType.WEB);
                } else if (JaxWsUtils.isEJBModule(moduleContainer)) {
                    jaxWsModuleInfo = new JaxWsModuleInfo(JaxWsModuleType.EJB);
                }
            }
            overlayCache.addToCache(JaxWsModuleInfo.class, (Object)jaxWsModuleInfo);
        }
        catch (UnableToAdaptException overlayCache) {
            void e;
            FFDCFilter.processException((Throwable)overlayCache, (String)"com.ibm.ws.jaxws.support.JaxWsModuleMetaDataListener", (String)"118", (Object)this, (Object[])new Object[]{event});
            throw new IllegalStateException((Throwable)e);
        }
    }

    protected void activate(ComponentContext cc) {
        this.classLoadingServiceSR.activate(cc);
    }

    protected void deactivate(ComponentContext cc) {
        this.classLoadingServiceSR.deactivate(cc);
    }

    public void moduleMetaDataDestroyed(MetaDataEvent<ModuleMetaData> event) {
        JaxWsModuleMetaData moduleMetaData;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("moduleMetaDataDestroyed(" + ((ModuleMetaData)event.getMetaData()).getName() + ") : " + event.getMetaData()), (Object[])new Object[0]);
        }
        if ((moduleMetaData = JaxWsMetaDataManager.getJaxWsModuleMetaData((ModuleMetaData)event.getMetaData())) != null) {
            JaxWsMetaDataManager.setJaxWsModuleMetaData((ModuleMetaData)event.getMetaData(), null);
            if (moduleMetaData.getJ2EEName().equals(((ModuleMetaData)event.getMetaData()).getJ2EEName())) {
                moduleMetaData.destroy();
                ClassLoadingService classLoadingService = (ClassLoadingService)this.classLoadingServiceSR.getService();
                if (classLoadingService != null) {
                    classLoadingService.destroyThreadContextClassLoader(moduleMetaData.getAppContextClassLoader());
                }
            }
        }
    }

    public void setMetaDataSlotService(MetaDataSlotService slotService) {
        JaxWsMetaDataManager.jaxwsApplicationSlot = slotService.reserveMetaDataSlot(ApplicationMetaData.class);
        JaxWsMetaDataManager.jaxwsModuleSlot = slotService.reserveMetaDataSlot(ModuleMetaData.class);
        JaxWsMetaDataManager.jaxwsComponentSlot = slotService.reserveMetaDataSlot(ComponentMetaData.class);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setMetaDataSlotService : applicationSlot=" + JaxWsMetaDataManager.jaxwsApplicationSlot), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("setMetaDataSlotService : moduleSlot=" + JaxWsMetaDataManager.jaxwsModuleSlot), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("setMetaDataSlotService : componentSlot=" + JaxWsMetaDataManager.jaxwsComponentSlot), (Object[])new Object[0]);
        }
    }

    public void unsetMetaDataSlotService(MetaDataSlotService slotService) {
        JaxWsMetaDataManager.jaxwsApplicationSlot = null;
        JaxWsMetaDataManager.jaxwsModuleSlot = null;
        JaxWsMetaDataManager.jaxwsComponentSlot = null;
    }

    public void registerJaxWsModuleInfoBuilder(JaxWsModuleInfoBuilder jaxWsModuleInfoBuilder) {
        this.jaxWsModuleInfoBuilderMap.put(jaxWsModuleInfoBuilder.getSupportType(), jaxWsModuleInfoBuilder);
    }

    public void unregisterJaxWsModuleInfoBuilder(JaxWsModuleInfoBuilder jaxWsModuleInfoBuilder) {
        this.jaxWsModuleInfoBuilderMap.remove((Object)jaxWsModuleInfoBuilder.getSupportType());
    }

    protected void setClassLoadingService(ServiceReference<ClassLoadingService> ref) {
        this.classLoadingServiceSR.setReference(ref);
    }

    protected void unsetClassLoadingService(ServiceReference<ClassLoadingService> ref) {
        this.classLoadingServiceSR.unsetReference(ref);
    }
}

