/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resources.internal;

import com.ibm.ws.repository.common.enums.AttachmentLinkType;
import com.ibm.ws.repository.common.enums.AttachmentType;
import com.ibm.ws.repository.common.enums.DisplayPolicy;
import com.ibm.ws.repository.common.enums.DownloadPolicy;
import com.ibm.ws.repository.common.enums.LicenseType;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.common.enums.ResourceTypeLabel;
import com.ibm.ws.repository.common.enums.State;
import com.ibm.ws.repository.common.enums.StateAction;
import com.ibm.ws.repository.common.enums.Visibility;
import com.ibm.ws.repository.common.utils.internal.HashUtils;
import com.ibm.ws.repository.connections.ProductDefinition;
import com.ibm.ws.repository.connections.RepositoryConnection;
import com.ibm.ws.repository.connections.RestRepositoryConnection;
import com.ibm.ws.repository.connections.internal.AbstractRepositoryConnection;
import com.ibm.ws.repository.exceptions.RepositoryBackendException;
import com.ibm.ws.repository.exceptions.RepositoryBackendIOException;
import com.ibm.ws.repository.exceptions.RepositoryBackendRequestFailureException;
import com.ibm.ws.repository.exceptions.RepositoryBadDataException;
import com.ibm.ws.repository.exceptions.RepositoryException;
import com.ibm.ws.repository.exceptions.RepositoryOperationNotSupportedException;
import com.ibm.ws.repository.exceptions.RepositoryResourceCreationException;
import com.ibm.ws.repository.exceptions.RepositoryResourceDeletionException;
import com.ibm.ws.repository.exceptions.RepositoryResourceException;
import com.ibm.ws.repository.exceptions.RepositoryResourceLifecycleException;
import com.ibm.ws.repository.exceptions.RepositoryResourceUpdateException;
import com.ibm.ws.repository.exceptions.RepositoryResourceValidationException;
import com.ibm.ws.repository.resources.AttachmentResource;
import com.ibm.ws.repository.resources.RepositoryResource;
import com.ibm.ws.repository.resources.internal.AppliesToProcessor;
import com.ibm.ws.repository.resources.internal.EsaResourceImpl;
import com.ibm.ws.repository.resources.internal.RepositoryResourceMatchingData;
import com.ibm.ws.repository.resources.internal.ResourceFactory;
import com.ibm.ws.repository.resources.internal.UpdateType;
import com.ibm.ws.repository.resources.writeable.AttachmentResourceWritable;
import com.ibm.ws.repository.resources.writeable.RepositoryResourceWritable;
import com.ibm.ws.repository.strategies.writeable.UploadStrategy;
import com.ibm.ws.repository.transport.client.RepositoryReadableClient;
import com.ibm.ws.repository.transport.client.RepositoryWriteableClient;
import com.ibm.ws.repository.transport.exceptions.BadVersionException;
import com.ibm.ws.repository.transport.exceptions.ClientFailureException;
import com.ibm.ws.repository.transport.exceptions.RequestFailureException;
import com.ibm.ws.repository.transport.model.AppliesToFilterInfo;
import com.ibm.ws.repository.transport.model.Asset;
import com.ibm.ws.repository.transport.model.Attachment;
import com.ibm.ws.repository.transport.model.AttachmentSummary;
import com.ibm.ws.repository.transport.model.FilterVersion;
import com.ibm.ws.repository.transport.model.ImageDetails;
import com.ibm.ws.repository.transport.model.Provider;
import com.ibm.ws.repository.transport.model.WlpInformation;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public abstract class RepositoryResourceImpl
implements RepositoryResourceWritable {
    protected Asset _asset;
    protected RepositoryReadableClient _client;
    private boolean _contentAttached = false;
    private HashMap<String, AttachmentResourceImpl> _attachments = new HashMap();
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    protected RepositoryConnection _repoConnection;

    protected static RepositoryReadableClient createClient(RepositoryConnection repoConnection) {
        return ((AbstractRepositoryConnection)repoConnection).createClient();
    }

    private RepositoryWriteableClient getWritableClient() throws RepositoryOperationNotSupportedException {
        if (this._client instanceof RepositoryWriteableClient) {
            return (RepositoryWriteableClient)((Object)this._client);
        }
        throw new RepositoryOperationNotSupportedException("The backend does not support write operations", this._repoConnection);
    }

    public RepositoryResourceImpl(RepositoryConnection repoConnection) {
        this(repoConnection, null);
    }

    public RepositoryResourceImpl(RepositoryConnection repoConnection, Asset ass) {
        this._repoConnection = repoConnection;
        if (ass == null) {
            this._asset = new Asset();
            this._asset.setWlpInformation(new WlpInformation());
            this.setDownloadPolicy(DownloadPolicy.ALL);
        } else {
            this._asset = ass;
        }
        if (repoConnection != null) {
            this._client = RepositoryResourceImpl.createClient(repoConnection);
        }
    }

    protected <T extends RepositoryResourceImpl> T createNewResource() {
        RepositoryResourceImpl result = null == this.getType() ? RepositoryResourceImpl.createTestResource(this._repoConnection) : (RepositoryResourceImpl)ResourceFactory.getInstance().createResource(this.getType(), this._repoConnection, null);
        return (T)result;
    }

    private static RepositoryResourceImpl createTestResource(RepositoryConnection repoConnection) {
        return new RepositoryResourceImpl(repoConnection, null){};
    }

    @Override
    public void refreshFromMassive() throws RepositoryBackendException, RepositoryResourceException {
        try {
            this._asset = this._client.getAsset(this._asset.get_id());
            this.parseAttachmentsInAsset();
        }
        catch (IOException ioe) {
            throw new RepositoryBackendIOException("Unable to obtain asset from massive " + this._asset.get_id(), ioe, this._repoConnection);
        }
        catch (BadVersionException bvx) {
            throw new RepositoryBadDataException("Bad version in asset ", this._asset.get_id(), bvx);
        }
        catch (RequestFailureException bfe) {
            throw new RepositoryBackendRequestFailureException(bfe, this._repoConnection);
        }
    }

    public MatchResult matches(ProductDefinition def) {
        Collection<AppliesToFilterInfo> atfiList = this._asset.getWlpInformation().getAppliesToFilterInfo();
        if (atfiList == null || atfiList.isEmpty()) {
            return MatchResult.NOT_APPLICABLE;
        }
        MatchResult matchResult = MatchResult.MATCHED;
        for (AppliesToFilterInfo atfi : atfiList) {
            if (!atfi.getProductId().equals(def.getId())) {
                matchResult = MatchResult.NOT_APPLICABLE;
                continue;
            }
            if (def.getVersion() != null && !def.getVersion().isEmpty()) {
                Version checkVersion = new Version(def.getVersion());
                VersionRange vr = FilterVersion.getFilterRange(atfi.getMinVersion(), atfi.getMaxVersion());
                if (!vr.includes(checkVersion)) {
                    return MatchResult.INVALID_VERSION;
                }
            }
            if (atfi.getRawEditions() != null && !atfi.getRawEditions().isEmpty() && !atfi.getRawEditions().contains(def.getEdition())) {
                return MatchResult.INVALID_EDITION;
            }
            if (atfi.getInstallType() != null && !atfi.getInstallType().equals(def.getInstallType())) {
                return MatchResult.INVALID_INSTALL_TYPE;
            }
            return MatchResult.MATCHED;
        }
        return matchResult;
    }

    public synchronized void parseAttachmentsInAsset() throws RepositoryBackendException {
        this.readAttachmentsFromAsset(this._asset);
    }

    private synchronized void readAttachmentsFromAsset(Asset ass) {
        List<Attachment> attachments = ass.getAttachments();
        this._attachments = new HashMap();
        if (attachments != null) {
            for (Attachment at : attachments) {
                this._attachments.put(at.getName(), new AttachmentResourceImpl(at));
                if (at.getType() != AttachmentType.CONTENT) continue;
                this._contentAttached = true;
            }
        }
    }

    protected Asset getAsset() {
        return this._asset;
    }

    @Override
    public void setRepositoryConnection(RepositoryConnection repoConnection) {
        this._repoConnection = repoConnection;
        this._client = RepositoryResourceImpl.createClient(repoConnection);
        this.resetId();
    }

    @Override
    public RepositoryConnection getRepositoryConnection() {
        return this._repoConnection;
    }

    @Override
    public String getId() {
        return this._asset.get_id();
    }

    @Override
    public void resetId() {
        this._asset.set_id(null);
    }

    @Override
    public void setName(String name) {
        this._asset.setName(name);
    }

    @Override
    public String getName() {
        return this._asset.getName();
    }

    @Override
    public void setProviderName(String providerName) {
        Provider prov = this._asset.getProvider();
        if (prov == null) {
            prov = new Provider();
            this._asset.setProvider(prov);
        }
        prov.setName(providerName);
    }

    @Override
    public String getProviderName() {
        return this._asset.getProvider() == null ? null : this._asset.getProvider().getName();
    }

    @Override
    public void setProviderUrl(String providerUrl) {
        Provider prov = this._asset.getProvider();
        if (prov == null) {
            prov = new Provider();
            this._asset.setProvider(prov);
        }
        prov.setUrl(providerUrl);
    }

    @Override
    public String getProviderUrl() {
        return this._asset.getProvider() == null ? null : this._asset.getProvider().getUrl();
    }

    protected void setType(ResourceType type) {
        if (type == null) {
            this._asset.setType(null);
            this._asset.getWlpInformation().setTypeLabel(null);
        } else {
            this._asset.setType(type);
            this._asset.getWlpInformation().setTypeLabel(type.getTypeLabel());
        }
    }

    @Override
    public ResourceType getType() {
        if (this._asset.getWlpInformation() == null) {
            return null;
        }
        return this._asset.getType();
    }

    public ResourceTypeLabel getTypeLabel() {
        if (this._asset.getWlpInformation() == null) {
            return null;
        }
        return this._asset.getWlpInformation().getTypeLabel();
    }

    @Override
    public void setDescription(String desc) {
        this._asset.setDescription(desc);
    }

    @Override
    public String getDescription() {
        return this._asset.getDescription();
    }

    @Override
    public State getState() {
        return this._asset.getState();
    }

    public void setState(State state) {
        this._asset.setState(state);
    }

    @Override
    public void setVersion(String version) {
        this._asset.setVersion(version);
    }

    @Override
    public String getVersion() {
        return this._asset.getVersion();
    }

    private void setMainAttachmentSize(long size) {
        this._asset.getWlpInformation().setMainAttachmentSize(size);
    }

    @Override
    public long getMainAttachmentSize() {
        return this._asset.getWlpInformation().getMainAttachmentSize();
    }

    @Override
    public String getMainAttachmentSHA256() {
        return this._asset.getWlpInformation().getMainAttachmentSHA256();
    }

    private void setMainAttachmentSHA256(String mainAttachmentSHA256) {
        this._asset.getWlpInformation().setMainAttachmentSHA256(mainAttachmentSHA256);
    }

    @Override
    public void setDownloadPolicy(DownloadPolicy policy) {
        this._asset.getWlpInformation().setDownloadPolicy(policy);
    }

    @Override
    public void setVanityURL(String vanityUrl) {
        this._asset.getWlpInformation().setVanityRelativeURL(vanityUrl);
    }

    @Override
    public DownloadPolicy getDownloadPolicy() {
        if (this._asset.getWlpInformation() == null) {
            return null;
        }
        return this._asset.getWlpInformation().getDownloadPolicy();
    }

    @Override
    public String getVanityURL() {
        return this._asset.getWlpInformation().getVanityRelativeURL();
    }

    @Override
    public void setFeaturedWeight(String featuredWeight) {
        this._asset.getWlpInformation().setFeaturedWeight(featuredWeight);
    }

    @Override
    public String getFeaturedWeight() {
        return this._asset.getWlpInformation().getFeaturedWeight();
    }

    @Override
    public String getAppliesToVersions(Collection<ProductDefinition> definitions) {
        String appliesTo = this._asset.getWlpInformation().getAppliesTo();
        List<AppliesToProcessor.AppliesToEntry> entries = AppliesToProcessor.parseAppliesToEntries(appliesTo);
        for (AppliesToProcessor.AppliesToEntry entry : entries) {
            for (ProductDefinition def : definitions) {
                if (!entry.getProductId().equals(def.getId()) || entry.getEditions() != null && !entry.getEditions().contains(def.getEdition()) || entry.getInstallType() != null && !entry.getInstallType().equals(def.getInstallType())) continue;
                return entry.getVersion();
            }
        }
        return null;
    }

    @Override
    public Collection<String> getAppliesToMinimumVersions() {
        HashSet<String> versions = new HashSet<String>();
        try {
            List<AppliesToFilterInfo> entries = this.generateAppliesToFilterInfoList(false);
            if (entries != null) {
                for (AppliesToFilterInfo appliesToFilterInfo : entries) {
                    FilterVersion minVersion = appliesToFilterInfo.getMinVersion();
                    if (minVersion == null) continue;
                    versions.add(minVersion.toString());
                }
            }
        }
        catch (RepositoryResourceCreationException repositoryResourceCreationException) {
            // empty catch block
        }
        return versions;
    }

    @Override
    public Calendar getLastUpdatedOn() {
        return this._asset.getLastUpdatedOn();
    }

    @Override
    public AttachmentResourceWritable addContent(File file) throws RepositoryException {
        return this.addContent(file, file.getName());
    }

    @Override
    public AttachmentResourceWritable addContent(File file, String name) throws RepositoryException {
        if (this._contentAttached) {
            throw new RepositoryResourceValidationException("addContent(" + file.getAbsolutePath() + ") called for resource " + this.getName() + " which all ready has a CONTENT attachment", this.getId());
        }
        this._contentAttached = true;
        AttachmentResourceWritable at = this.addAttachment(file, AttachmentType.CONTENT, name);
        this.setMainAttachmentSize(at.getSize());
        try {
            this.setMainAttachmentSHA256(file == null ? null : HashUtils.getFileSHA256String(file));
        }
        catch (IOException ioe) {
            throw new RepositoryException(ioe);
        }
        return at;
    }

    @Override
    public AttachmentResourceWritable addContent(File file, String name, String url, AttachmentLinkType linkType) throws RepositoryException {
        if (this._contentAttached) {
            throw new RepositoryResourceValidationException("addContent(" + file.getAbsolutePath() + ") called for resource " + this.getName() + " which all ready has a CONTENT attachment", this.getId());
        }
        this._contentAttached = true;
        AttachmentResourceWritable at = this.addAttachment(file, AttachmentType.CONTENT, name, url, linkType);
        this.setMainAttachmentSize(at.getSize());
        try {
            this.setMainAttachmentSHA256(file == null ? null : HashUtils.getFileSHA256String(file));
        }
        catch (IOException ioe) {
            throw new RepositoryException(ioe);
        }
        return at;
    }

    @Override
    public AttachmentResourceWritable addAttachment(File file, AttachmentType type) throws RepositoryException {
        return this.addAttachment(file, type, file.getName());
    }

    @Override
    public synchronized AttachmentResourceWritable addAttachment(File file, AttachmentType type, String name) throws RepositoryException {
        AttachmentResourceImpl at = new AttachmentResourceImpl(file, name);
        at.setType(type);
        at.setFileProps();
        this._attachments.put(name, at);
        return at;
    }

    @Override
    public synchronized AttachmentResourceWritable addAttachment(File file, AttachmentType type, String name, String url, AttachmentLinkType linkType) throws RepositoryException {
        AttachmentResourceImpl at = new AttachmentResourceImpl(file, name, url, linkType);
        at.setType(type);
        at.setFileProps();
        this._attachments.put(name, at);
        return at;
    }

    boolean isMainAttachment(AttachmentResource at) {
        return AttachmentType.CONTENT == at.getType();
    }

    @Override
    public AttachmentResource getMainAttachment() throws RepositoryBackendException, RepositoryResourceException {
        Collection<AttachmentResource> attachments = this.getAttachments();
        for (AttachmentResource at : attachments) {
            if (!this.isMainAttachment(at)) continue;
            return at;
        }
        return null;
    }

    @Override
    public AttachmentResource getAttachment(String attachmentName) throws RepositoryBackendException, RepositoryResourceException {
        for (AttachmentResource at : this.getAttachments()) {
            if (!at.getName().equals(attachmentName)) continue;
            return at;
        }
        return null;
    }

    @Override
    public synchronized Collection<AttachmentResource> getAttachments() throws RepositoryBackendException, RepositoryResourceException {
        return Collections.unmodifiableCollection(this.getAttachmentImpls());
    }

    public synchronized Collection<AttachmentResourceImpl> getAttachmentImpls() throws RepositoryBackendException, RepositoryResourceException {
        if (this._attachments == null || this._attachments.isEmpty()) {
            if (this.getId() != null) {
                RepositoryResourceImpl mr = (RepositoryResourceImpl)this._repoConnection.getResource(this.getId());
                this.readAttachmentsFromAsset(mr._asset);
                this._asset.setAttachments(mr._asset.getAttachments());
            } else if (this._attachments == null) {
                this._attachments = new HashMap();
            }
        }
        return this._attachments.values();
    }

    public int getAttachmentCount() throws RepositoryBackendException, RepositoryResourceException {
        Collection<AttachmentResource> attachments = this.getAttachments();
        return attachments.size();
    }

    @Override
    public void addLicense(File license, Locale loc) throws RepositoryException {
        AttachmentResourceImpl res = (AttachmentResourceImpl)this.addAttachment(license, AttachmentType.LICENSE, license.getName());
        res.setLocale(loc);
    }

    @Override
    public void addLicenseAgreement(File license, Locale loc) throws RepositoryException {
        AttachmentResourceImpl res = (AttachmentResourceImpl)this.addAttachment(license, AttachmentType.LICENSE_AGREEMENT, license.getName());
        res.setLocale(loc);
    }

    @Override
    public void addLicenseInformation(File license, Locale loc) throws RepositoryException {
        AttachmentResourceImpl res = (AttachmentResourceImpl)this.addAttachment(license, AttachmentType.LICENSE_INFORMATION, license.getName());
        res.setLocale(loc);
    }

    @Override
    public AttachmentResource getLicense(Locale loc) throws RepositoryBackendException, RepositoryResourceException {
        AttachmentSummary s = RepositoryResourceImpl.matchByLocale(this.getAttachmentImpls(), AttachmentType.LICENSE, loc);
        AttachmentResource result = null;
        if (s instanceof AttachmentResource) {
            result = (AttachmentResource)((Object)s);
        }
        return result;
    }

    @Override
    public AttachmentResource getLicenseAgreement(Locale loc) throws RepositoryBackendException, RepositoryResourceException {
        AttachmentSummary s = RepositoryResourceImpl.matchByLocale(this.getAttachmentImpls(), AttachmentType.LICENSE_AGREEMENT, loc);
        AttachmentResource result = null;
        if (s instanceof AttachmentResource) {
            result = (AttachmentResource)((Object)s);
        }
        return result;
    }

    @Override
    public AttachmentResource getLicenseInformation(Locale loc) throws RepositoryBackendException, RepositoryResourceException {
        AttachmentSummary s = RepositoryResourceImpl.matchByLocale(this.getAttachmentImpls(), AttachmentType.LICENSE_INFORMATION, loc);
        AttachmentResource result = null;
        if (s instanceof AttachmentResource) {
            result = (AttachmentResource)((Object)s);
        }
        return result;
    }

    public static AttachmentSummary matchByLocale(Collection<? extends AttachmentSummary> attachments, AttachmentType desiredType, Locale desiredLocale) {
        ArrayList<AttachmentSummary> possibleMatches = new ArrayList<AttachmentSummary>();
        for (AttachmentSummary attachmentSummary : attachments) {
            AttachmentType attType = attachmentSummary.getAttachment().getType();
            if (!attType.equals((Object)desiredType)) continue;
            if (attachmentSummary.getLocale().equals(desiredLocale)) {
                return attachmentSummary;
            }
            possibleMatches.add(attachmentSummary);
        }
        Locale baseDesiredLocale = new Locale(desiredLocale.getLanguage());
        for (AttachmentSummary s : possibleMatches) {
            if (!s.getLocale().equals(baseDesiredLocale)) continue;
            return s;
        }
        for (AttachmentSummary s : possibleMatches) {
            if (!s.getLocale().equals(Locale.ENGLISH)) continue;
            return s;
        }
        for (AttachmentSummary s : possibleMatches) {
            if (!new Locale(s.getLocale().getLanguage()).equals(Locale.ENGLISH)) continue;
            return s;
        }
        return null;
    }

    @Override
    public void setLicenseType(LicenseType lt) {
        this._asset.setLicenseType(lt);
    }

    @Override
    public LicenseType getLicenseType() {
        return this._asset.getLicenseType();
    }

    @Override
    public void setLicenseId(String lic) {
        this._asset.setLicenseId(lic);
    }

    @Override
    public String getLicenseId() {
        return this._asset.getLicenseId();
    }

    @Override
    public void setShortDescription(String shortDescription) {
        this._asset.setShortDescription(shortDescription);
    }

    @Override
    public String getShortDescription() {
        return this._asset.getShortDescription();
    }

    @Override
    public void setWlpInformationVersion(String wlpInformationVersion) {
        this._asset.getWlpInformation().setWlpInformationVersion(wlpInformationVersion);
    }

    @Override
    public String getWlpInformationVersion() {
        return this._asset.getWlpInformation().getWlpInformationVersion();
    }

    @Override
    public void setDisplayPolicy(DisplayPolicy policy) {
        this._asset.getWlpInformation().setDisplayPolicy(policy);
    }

    @Override
    public DisplayPolicy getDisplayPolicy() {
        if (this._asset.getWlpInformation() == null) {
            return null;
        }
        return this._asset.getWlpInformation().getDisplayPolicy();
    }

    public UpdateType updateRequired(RepositoryResourceImpl matching) {
        if (null == matching) {
            return UpdateType.ADD;
        }
        if (this.equivalentWithoutAttachments(matching)) {
            return UpdateType.NOTHING;
        }
        this._asset.set_id(matching.getId());
        return UpdateType.UPDATE;
    }

    public RepositoryResourceMatchingData createMatchingData() {
        RepositoryResourceMatchingData matchingData = new RepositoryResourceMatchingData();
        matchingData.setName(this.getName());
        matchingData.setProviderName(this.getProviderName());
        matchingData.setType(this.getType());
        return matchingData;
    }

    protected List<RepositoryResourceImpl> performMatching() throws BadVersionException, RequestFailureException, RepositoryBadDataException, RepositoryBackendException {
        ArrayList<RepositoryResourceImpl> matching = new ArrayList<RepositoryResourceImpl>();
        Collection<? extends RepositoryResource> resources = this.getPotentiallyMatchingResources();
        RepositoryResourceImpl resource = null;
        for (RepositoryResourceImpl repositoryResourceImpl : resources) {
            if (!this.createMatchingData().equals(repositoryResourceImpl.createMatchingData())) continue;
            resource = (RepositoryResourceImpl)this._repoConnection.getResource(repositoryResourceImpl.getId());
            matching.add(resource);
        }
        return matching;
    }

    protected Collection<? extends RepositoryResource> getPotentiallyMatchingResources() throws RepositoryBackendException {
        return this._repoConnection.getAllResourcesWithDupes(this.getType());
    }

    public boolean doesResourceMatch(Collection<ProductDefinition> productDefinitions, Visibility visibility) {
        boolean matches;
        ResourceType type = this.getType();
        if (ResourceType.FEATURE == type && visibility != null) {
            Visibility visibilityMatches;
            EsaResourceImpl esa = (EsaResourceImpl)this;
            Visibility visibility2 = visibilityMatches = esa.getVisibility() == null ? Visibility.PUBLIC : esa.getVisibility();
            if (!visibilityMatches.equals((Object)visibility)) {
                return false;
            }
        }
        boolean bl = matches = productDefinitions == null || productDefinitions.isEmpty();
        if (productDefinitions != null) {
            for (ProductDefinition productDefinition : productDefinitions) {
                if (this.matches(productDefinition) != MatchResult.MATCHED) continue;
                matches = true;
                break;
            }
        }
        return matches;
    }

    public List<RepositoryResourceImpl> findMatchingResource() throws RepositoryResourceValidationException, RepositoryBackendException, RepositoryBadDataException {
        List<RepositoryResourceImpl> matchingRes;
        try {
            matchingRes = this.performMatching();
            if (matchingRes != null && matchingRes.size() > 1) {
                StringBuilder warningMessage = new StringBuilder("More than one match found for " + this.getName() + ":");
                for (RepositoryResourceImpl massiveResource : matchingRes) {
                    warningMessage.append("\n\t" + massiveResource.getName() + " (" + massiveResource.getId() + ")");
                }
                this.logger.warning(warningMessage.toString());
            }
        }
        catch (BadVersionException bvx) {
            throw new RepositoryBadDataException("BadDataException accessing asset", this.getId(), bvx);
        }
        catch (RequestFailureException bfe) {
            throw new RepositoryBackendRequestFailureException(bfe, this._repoConnection);
        }
        return matchingRes;
    }

    protected void copyFieldsFrom(RepositoryResourceImpl fromResource, boolean includeAttachmentInfo) {
        this.setName(fromResource.getName());
        this.setDescription(fromResource.getDescription());
        this.setShortDescription(fromResource.getShortDescription());
        this.setProviderName(fromResource.getProviderName());
        this.setProviderUrl(fromResource.getProviderUrl());
        this.setVersion(fromResource.getVersion());
        this.setDownloadPolicy(fromResource.getDownloadPolicy());
        this.setLicenseId(fromResource.getLicenseId());
        this.setLicenseType(fromResource.getLicenseType());
        this.setMainAttachmentSize(fromResource.getMainAttachmentSize());
        this.setMainAttachmentSHA256(fromResource.getMainAttachmentSHA256());
        this.setFeaturedWeight(fromResource.getFeaturedWeight());
        this.setDisplayPolicy(fromResource.getDisplayPolicy());
        this.setVanityURL(fromResource.getVanityURL());
        this.setWlpInformationVersion(fromResource.getWlpInformationVersion());
        if (includeAttachmentInfo) {
            this.setMainAttachmentSize(fromResource.getMainAttachmentSize());
        }
        this._asset.getWlpInformation().setAppliesToFilterInfo(fromResource.getAsset().getWlpInformation().getAppliesToFilterInfo());
    }

    public void overWriteAssetData(RepositoryResourceImpl fromResource, boolean includeAttachmentInfo) throws RepositoryResourceValidationException {
        if (!fromResource.getClass().getName().equals(this.getClass().getName())) {
            throw new RepositoryResourceValidationException("Expected class of type " + this.getClass().getName() + " but was " + fromResource.getClass().getName(), this.getId());
        }
        fromResource.copyFieldsFrom(this, includeAttachmentInfo);
        this._asset = fromResource._asset;
    }

    public void addAsset() throws RepositoryResourceCreationException, RepositoryBadDataException, RepositoryBackendIOException {
        this.resetId();
        try {
            this._asset = this.getWritableClient().addAsset(this._asset);
        }
        catch (IOException ioe) {
            throw new RepositoryBackendIOException("Failed to add asset " + this.getId(), ioe, this._repoConnection);
        }
        catch (BadVersionException bvx) {
            throw new RepositoryBadDataException("Bad version when adding asset", this.getId(), bvx);
        }
        catch (RequestFailureException rfe) {
            throw new RepositoryResourceCreationException("Failed to add the asset", this.getId(), rfe);
        }
        catch (SecurityException se) {
            throw new RepositoryResourceCreationException("Failed to add the asset", this.getId(), se);
        }
        catch (RepositoryOperationNotSupportedException rbnse) {
            throw new RepositoryResourceCreationException("Failed to add the asset", this.getId(), rbnse);
        }
        catch (ClientFailureException cfe) {
            throw new RepositoryResourceCreationException("Failed to add the asset", this.getId(), cfe);
        }
    }

    public void updateAsset() throws RepositoryResourceUpdateException, RepositoryResourceValidationException, RepositoryBadDataException, RepositoryBackendIOException {
        try {
            this._asset = this.getWritableClient().updateAsset(this._asset);
        }
        catch (IOException ioe) {
            throw new RepositoryBackendIOException("Failed to update asset " + this.getId(), ioe, this._repoConnection);
        }
        catch (BadVersionException bvx) {
            throw new RepositoryBadDataException("Bad version when updating asset", this.getId(), bvx);
        }
        catch (RequestFailureException e) {
            throw new RepositoryResourceUpdateException("Failed to update the attachment", this.getId(), e);
        }
        catch (SecurityException se) {
            throw new RepositoryResourceUpdateException("Failed to update the asset", this.getId(), se);
        }
        catch (RepositoryOperationNotSupportedException rbnse) {
            throw new RepositoryResourceUpdateException("Failed to add the asset", this.getId(), rbnse);
        }
        catch (ClientFailureException cfe) {
            throw new RepositoryResourceUpdateException("Failed to add the asset", this.getId(), cfe);
        }
    }

    public void copyAsset(RepositoryResourceImpl from) {
        this._asset = from._asset;
    }

    public void addAttachment(AttachmentResourceImpl at) throws RepositoryResourceCreationException, RepositoryBadDataException, RepositoryResourceUpdateException, RepositoryBackendIOException {
        at.resetId();
        try {
            this.getWritableClient().addAttachment(this.getId(), at);
        }
        catch (IOException e) {
            throw new RepositoryBackendIOException("Failed to add the attachment" + this.getId(), e, this._repoConnection);
        }
        catch (BadVersionException bvx) {
            throw new RepositoryBadDataException("Bad version when adding attachment", this.getId(), bvx);
        }
        catch (RequestFailureException rfe) {
            throw new RepositoryResourceCreationException("Failed to add the attachment", this.getId(), rfe);
        }
        catch (SecurityException se) {
            throw new RepositoryResourceUpdateException("Failed to add the attachment", this.getId(), se);
        }
        catch (RepositoryOperationNotSupportedException rbnse) {
            throw new RepositoryResourceUpdateException("Failed to add the attachment", this.getId(), rbnse);
        }
    }

    public void updateAttachment(AttachmentResourceImpl at) throws RepositoryResourceUpdateException, RepositoryBadDataException, RepositoryBackendIOException {
        try {
            this.getWritableClient().updateAttachment(this.getId(), at);
        }
        catch (IOException ioe) {
            throw new RepositoryBackendIOException("Failed to update the attachment " + this.getId(), ioe, this._repoConnection);
        }
        catch (BadVersionException bvx) {
            throw new RepositoryBadDataException("Bad version when updating attachment", this.getId(), bvx);
        }
        catch (RequestFailureException e) {
            throw new RepositoryResourceUpdateException("Failed to update the attachment", this.getId(), e);
        }
        catch (SecurityException se) {
            throw new RepositoryResourceUpdateException("Failed to update the attachment", this.getId(), se);
        }
        catch (RepositoryOperationNotSupportedException rbnse) {
            throw new RepositoryResourceUpdateException("Failed to add the attachment", this.getId(), rbnse);
        }
    }

    @Override
    public synchronized void uploadToMassive(UploadStrategy strategy) throws RepositoryBackendException, RepositoryResourceException {
        this.updateGeneratedFields(strategy.performEditionChecking());
        if (this.getId() != null) {
            this.copyAttachments();
        }
        List<RepositoryResourceImpl> matching = strategy.findMatchingResources(this);
        strategy.uploadAsset(this, matching);
    }

    void copyAttachments() throws RepositoryBackendException, RepositoryResourceException {
        Collection<AttachmentResourceImpl> attachments = this.getAttachmentImpls();
        for (AttachmentResourceImpl at : attachments) {
            AttachmentLinkType linkType = at.getLinkType();
            if (null == linkType && at.getURL() != null) {
                final File tempFile = new File(this.getId() + "_" + at.getName());
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() {
                            tempFile.deleteOnExit();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw new RepositoryResourceValidationException("Unable to copy attachments", at.getId(), e.getCause());
                }
                try {
                    try {
                        at.downloadToFile(tempFile);
                    }
                    catch (IOException e) {
                        at.downloadToFile(tempFile);
                    }
                    at.setURL(null);
                    at.setFile(tempFile);
                }
                catch (IOException e) {
                    throw new RepositoryBackendIOException("Exception caught while obtaining attachments for resource " + this.getName(), e, this._repoConnection);
                }
            }
            at.resetId();
        }
    }

    private void performLifeCycle(StateAction action) throws RepositoryBackendException, RepositoryResourceException {
        State s = this.getState();
        if (s.isStateActionAllowed(action)) {
            try {
                this.getWritableClient().updateState(this._asset.get_id(), action);
            }
            catch (IOException ioe) {
                throw new RepositoryBackendIOException("IOException on " + (Object)((Object)action), ioe, null);
            }
            catch (RequestFailureException cause) {
                throw new RepositoryBackendRequestFailureException(cause, null);
            }
        } else {
            throw new RepositoryResourceLifecycleException((Object)((Object)action) + " not supported for assets in " + (Object)((Object)s) + " state", this._asset.get_id(), s, action);
        }
        this.refreshFromMassive();
    }

    public void publish() throws RepositoryBackendException, RepositoryResourceException {
        this.performLifeCycle(StateAction.PUBLISH);
    }

    public void approve() throws RepositoryBackendException, RepositoryResourceException {
        this.performLifeCycle(StateAction.APPROVE);
    }

    public void cancel() throws RepositoryBackendException, RepositoryResourceException {
        this.performLifeCycle(StateAction.CANCEL);
    }

    public void need_more_info() throws RepositoryBackendException, RepositoryResourceException {
        this.performLifeCycle(StateAction.NEED_MORE_INFO);
    }

    public void unpublish() throws RepositoryBackendException, RepositoryResourceException {
        this.performLifeCycle(StateAction.UNPUBLISH);
    }

    public void moveToState(State state) throws RepositoryBackendException, RepositoryResourceException {
        int counter = 0;
        while (this.getState() != state) {
            StateAction nextAction = this.getState().getNextAction(state);
            this.performLifeCycle(nextAction);
            if (++counter < 10) continue;
            throw new RepositoryResourceLifecycleException("Unable to move to state " + (Object)((Object)state) + " after 10 state transistion attempts. Resource left in state " + (Object)((Object)this.getState()), this.getId(), this.getState(), nextAction);
        }
    }

    @Override
    public void delete() throws RepositoryResourceDeletionException, RepositoryBackendIOException {
        try {
            this.getWritableClient().deleteAssetAndAttachments(this._asset.get_id());
        }
        catch (IOException ioe) {
            throw new RepositoryBackendIOException("Failed to delete resource " + this.getId(), ioe, this.getRepositoryConnection());
        }
        catch (RequestFailureException e) {
            throw new RepositoryResourceDeletionException("Failed to delete resource", this.getId(), e);
        }
        catch (RepositoryOperationNotSupportedException e) {
            throw new RepositoryResourceDeletionException("Failed to delete resource", this.getId(), e);
        }
    }

    @Override
    public String getAssetURL() {
        String url = null;
        if (this._repoConnection instanceof RestRepositoryConnection) {
            RestRepositoryConnection lie = (RestRepositoryConnection)this._repoConnection;
            url = lie.getAssetURL(this.getId());
        }
        return url;
    }

    @Override
    public void updateGeneratedFields(boolean performEditionChecking) throws RepositoryResourceCreationException {
        this.updateAssetFilterInfo(performEditionChecking);
        if (this._asset != null && this._asset.getWlpInformation() != null && this._asset.getWlpInformation().getVanityRelativeURL() == null) {
            this.createVanityURL();
        }
    }

    protected String getVersionForVanityUrl() {
        return "";
    }

    protected String getNameForVanityUrl() {
        return this.getName();
    }

    protected void createVanityURL() {
        List<Character> allowable = Arrays.asList(Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('0'), Character.valueOf('.'), Character.valueOf('-'), Character.valueOf('_'));
        ResourceType type = this.getType();
        if (type == null) {
            return;
        }
        StringBuffer sb = new StringBuffer(type.getURLForType());
        String version = this.getVersionForVanityUrl();
        if (version != null && !version.isEmpty()) {
            sb.append("-");
            sb.append(version);
        }
        sb.append("-");
        sb.append(this.getNameForVanityUrl());
        StringBuffer filtered = new StringBuffer();
        char[] arr$ = sb.toString().toCharArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Character c = Character.valueOf(arr$[i$]);
            if (allowable.contains(c)) {
                filtered.append(c);
                continue;
            }
            if (!c.equals(Character.valueOf(' '))) continue;
            filtered.append('_');
        }
        this._asset.getWlpInformation().setVanityRelativeURL(filtered.toString());
    }

    protected List<AppliesToFilterInfo> generateAppliesToFilterInfoList(boolean validateEditions) throws RepositoryResourceCreationException {
        String appliesTo;
        WlpInformation wlp = this._asset.getWlpInformation();
        List<AppliesToFilterInfo> atfi = null;
        if (wlp != null && (appliesTo = wlp.getAppliesTo()) != null && (atfi = AppliesToProcessor.parseAppliesToHeader(appliesTo)) != null && validateEditions) {
            for (AppliesToFilterInfo info : atfi) {
                AppliesToProcessor.validateEditions(info, appliesTo);
            }
        }
        return atfi;
    }

    private void updateAssetFilterInfo(boolean performEditionChecking) throws RepositoryResourceCreationException {
        WlpInformation wlp = this._asset.getWlpInformation();
        List<AppliesToFilterInfo> atfi = this.generateAppliesToFilterInfoList(performEditionChecking);
        if (wlp != null && atfi != null) {
            wlp.setAppliesToFilterInfo(atfi);
        }
    }

    @Override
    public void dump(OutputStream os) {
        this._asset.dump(os);
    }

    @Override
    public void writeDiskRepoJSONToStream(OutputStream writeJsonTo) throws RepositoryResourceException {
        try {
            this._asset.dumpMinimalAsset(writeJsonTo);
        }
        catch (IllegalArgumentException e) {
            throw new RepositoryResourceCreationException("Failed to write the resource to disk", this.getId(), e);
        }
        catch (IllegalAccessException e) {
            throw new RepositoryResourceCreationException("Failed to write the resource to disk", this.getId(), e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._asset == null ? 0 : this._asset.hashCode());
        return result;
    }

    public boolean equivalent(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryResourceImpl other = (RepositoryResourceImpl)obj;
        return !(this._asset == null ? other._asset != null : !this._asset.equivalent(other._asset));
    }

    public boolean equivalentWithoutAttachments(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryResourceImpl other = (RepositoryResourceImpl)obj;
        return !(this._asset == null ? other._asset != null : !this._asset.equivalentWithoutAttachments(other._asset));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryResourceImpl other = (RepositoryResourceImpl)obj;
        return !(this._asset == null ? other._asset != null : !this._asset.equals(other._asset));
    }

    public String toString() {
        return "<MassiveResource@" + this.hashCode() + " <Asset=" + this._asset + ">>";
    }

    private static long getCRC(InputStream is) throws IOException {
        CheckedInputStream check = new CheckedInputStream(is, new CRC32());
        BufferedInputStream in = new BufferedInputStream(check);
        while (in.read() != -1) {
        }
        long crc = check.getChecksum().getValue();
        return crc;
    }

    public class AttachmentResourceImpl
    implements AttachmentSummary,
    AttachmentResourceWritable {
        private final Attachment _attachment;
        private File _file = null;

        private AttachmentResourceImpl(File file, String name) {
            this._attachment = new Attachment();
            this._attachment.setName(name);
            this._file = file;
        }

        private AttachmentResourceImpl(Attachment at) {
            this._attachment = at;
        }

        private AttachmentResourceImpl(File file, String name, String url, AttachmentLinkType linkType) {
            this._attachment = new Attachment();
            this._attachment.setName(name);
            this._attachment.setUrl(url);
            if (linkType == null) {
                linkType = AttachmentLinkType.DIRECT;
            }
            this._attachment.setLinkType(linkType);
            this._file = file;
        }

        @Override
        public String getName() {
            return this._attachment.getName();
        }

        @Override
        public Locale getLocale() {
            return this._attachment.getLocale();
        }

        @Override
        public File getFile() {
            return this._file;
        }

        public void setFile(File file) {
            this._file = file;
        }

        @Override
        public String getURL() {
            return this._attachment.getUrl();
        }

        public void setURL(String url) {
            this._attachment.setUrl(url);
        }

        @Override
        public Attachment getAttachment() {
            return this._attachment;
        }

        @Override
        public long getSize() {
            return this._attachment.getSize();
        }

        private void setFileProps() throws RepositoryException {
            this.setSize(this.getFileLength());
            this.setCRC(this.calculateCRC());
        }

        private void setSize(long size) {
            this._attachment.setSize(size);
        }

        @Override
        public void setImageDimensions(int height, int width) {
            ImageDetails details = this._attachment.getWlpInformation().getImageDetails();
            if (details == null) {
                details = new ImageDetails();
                this._attachment.getWlpInformation().setImageDetails(details);
            }
            details.setHeight(height);
            details.setWidth(width);
        }

        @Override
        public int getImageHeight() {
            ImageDetails details = this._attachment.getWlpInformation().getImageDetails();
            if (details == null) {
                return 0;
            }
            return details.getHeight();
        }

        @Override
        public int getImageWidth() {
            ImageDetails details = this._attachment.getWlpInformation().getImageDetails();
            if (details == null) {
                return 0;
            }
            return details.getWidth();
        }

        @Override
        public String getId() {
            return this._attachment.get_id();
        }

        public void resetId() {
            this._attachment.set_id(null);
        }

        @Override
        public AttachmentType getType() {
            return this._attachment.getType();
        }

        public void setType(AttachmentType type) {
            this._attachment.setType(type);
        }

        public Calendar getUploadOn() {
            return this._attachment.getUploadOn();
        }

        @Override
        public InputStream getInputStream() throws RepositoryBackendException, RepositoryBadDataException {
            try {
                return RepositoryResourceImpl.this._client.getAttachment(RepositoryResourceImpl.this._asset, this._attachment);
            }
            catch (IOException e) {
                throw new RepositoryBackendIOException("Failed to get read attachment", e, RepositoryResourceImpl.this._repoConnection);
            }
            catch (BadVersionException e) {
                throw new RepositoryBadDataException("BadVersion reading attachment", this.getId(), e);
            }
            catch (RequestFailureException e) {
                throw new RepositoryBackendRequestFailureException(e, RepositoryResourceImpl.this._repoConnection);
            }
        }

        public void setCRC(long CRC) {
            this._attachment.getWlpInformation().setCRC(CRC);
        }

        @Override
        public long getCRC() {
            return this._attachment.getWlpInformation().getCRC();
        }

        public void setLocale(Locale locale) {
            this._attachment.setLocale(locale);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteNow() throws RepositoryResourceDeletionException, RepositoryBackendIOException {
            RepositoryResourceImpl repositoryResourceImpl = RepositoryResourceImpl.this;
            synchronized (repositoryResourceImpl) {
                try {
                    if (this.getId() != null) {
                        RepositoryResourceImpl.this.getWritableClient().deleteAttachment(RepositoryResourceImpl.this.getId(), this.getId());
                    }
                    RepositoryResourceImpl.this._attachments.remove(this.getName());
                    if (this._attachment.getType().equals((Object)AttachmentType.CONTENT)) {
                        RepositoryResourceImpl.this._contentAttached = false;
                    }
                }
                catch (IOException e) {
                    throw new RepositoryBackendIOException("Failed to delete the attachment " + this.getId() + " in asset " + RepositoryResourceImpl.this.getId(), e, RepositoryResourceImpl.this.getRepositoryConnection());
                }
                catch (RequestFailureException e) {
                    throw new RepositoryResourceDeletionException("Failed to delete the attachment " + this.getId() + " in asset " + RepositoryResourceImpl.this.getId(), this.getId(), e);
                }
                catch (RepositoryOperationNotSupportedException rbnse) {
                    throw new RepositoryResourceDeletionException("Failed to delete the attachment " + this.getId() + " in asset " + RepositoryResourceImpl.this.getId(), this.getId(), rbnse);
                }
            }
        }

        public UpdateType updateRequired(RepositoryResourceImpl remoteResource) throws RepositoryBackendException, RepositoryResourceException {
            if (null == remoteResource) {
                return UpdateType.ADD;
            }
            Collection<AttachmentResource> remoteAttachments = remoteResource.getAttachments();
            for (AttachmentResource remoteAt : remoteAttachments) {
                if (!this.getName().equals(remoteAt.getName())) continue;
                if (this.equivalent(remoteAt)) {
                    return UpdateType.NOTHING;
                }
                return UpdateType.UPDATE;
            }
            return UpdateType.ADD;
        }

        public boolean equivalent(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AttachmentResourceImpl other = (AttachmentResourceImpl)obj;
            return !(this._attachment == null ? other._attachment != null : !this._attachment.equivalent(other._attachment));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this._file == null ? 0 : this._file.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AttachmentResourceImpl other = (AttachmentResourceImpl)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this._file == null ? other._file != null : !this._file.equals(other._file));
        }

        public String toString() {
            return "<AttachmentResource@" + this.hashCode() + " <Attachment=" + this._attachment + ">>";
        }

        @Override
        public void dump(OutputStream os) {
            this._attachment.dump(os);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void downloadToFile(final File fileToWriteTo) throws RepositoryBackendException, IOException, RepositoryBadDataException {
            FileOutputStream fos = null;
            InputStream is = this.getInputStream();
            try {
                try {
                    fos = AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                        @Override
                        public FileOutputStream run() throws FileNotFoundException {
                            return new FileOutputStream(fileToWriteTo);
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    throw (FileNotFoundException)e.getCause();
                }
                byte[] buffer = new byte[1024];
                int read = 0;
                while ((read = is.read(buffer)) != -1) {
                    fos.write(buffer, 0, read);
                }
            }
            finally {
                if (null != fos) {
                    fos.close();
                }
                if (null != is) {
                    is.close();
                }
            }
        }

        public AttachmentLinkType getLinkType() {
            return this._attachment.getLinkType();
        }

        private RepositoryResourceImpl getOuterType() {
            return RepositoryResourceImpl.this;
        }

        private long calculateCRC() throws RepositoryException {
            if (this._file == null) {
                return 0L;
            }
            InputStream is = null;
            try {
                is = AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                    @Override
                    public FileInputStream run() throws FileNotFoundException {
                        return new FileInputStream(AttachmentResourceImpl.this._file);
                    }
                });
                long l = RepositoryResourceImpl.getCRC(is);
                return l;
            }
            catch (PrivilegedActionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw new RepositoryException(cause);
                }
                throw (RuntimeException)cause;
            }
            catch (IOException cause) {
                throw new RepositoryException(cause);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
        }

        private long getFileLength() throws RepositoryException {
            Long fileSize;
            if (this._file == null) {
                return 0L;
            }
            try {
                fileSize = AccessController.doPrivileged(new PrivilegedExceptionAction<Long>(){

                    @Override
                    public Long run() {
                        return AttachmentResourceImpl.this._file.length();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RepositoryException(e.getCause());
            }
            return fileSize;
        }

        @Override
        public RepositoryConnection getRepositoryConnection() {
            return this.getOuterType().getRepositoryConnection();
        }
    }

    public static enum MatchResult {
        MATCHED,
        NOT_APPLICABLE,
        INVALID_VERSION,
        INVALID_EDITION,
        INVALID_INSTALL_TYPE;

    }
}

