/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jndi.internal.literals;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jndi.internal.literals.Patterns;
import com.ibm.ws.jndi.internal.literals.StringParser;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.math.BigInteger;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
enum LiteralType {
    BOOLEAN_TRUE("true"){
        static final long serialVersionUID = 4776591588665464795L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        Object parse(String s) {
            return true;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    }
    ,
    BOOLEAN_FALSE("false"){
        static final long serialVersionUID = -1339806338571459098L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        Object parse(String s) {
            return false;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(2.class);
        }
    }
    ,
    CHARACTER("'.*"){
        static final long serialVersionUID = -581415508615591863L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        Object parse(String s) {
            return StringParser.parseChar(s);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(3.class);
        }
    }
    ,
    DOUBLE(Patterns.DOUBLE){
        static final long serialVersionUID = -4882132329110281677L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        Object parse(String s) {
            try {
                return Double.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jndi.internal.literals.LiteralType$4", (String)"53", (Object)((Object)this), (Object[])new Object[]{s});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to parse double", (Object[])new Object[]{s});
                }
                return s;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(4.class);
        }
    }
    ,
    FLOAT(Patterns.FLOAT){
        static final long serialVersionUID = 5305568723517779724L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        Object parse(String s) {
            try {
                return Float.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jndi.internal.literals.LiteralType$5", (String)"65", (Object)((Object)this), (Object[])new Object[]{s});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to parse float", (Object[])new Object[]{s});
                }
                return s;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(5.class);
        }
    }
    ,
    INTEGER_BINARY("0[Bb][01](?:_*[01]){0,31}"){
        static final long serialVersionUID = -2494968564304428433L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        Object parse(String s) {
            s = s.replaceAll("_*", "").substring(2);
            try {
                return LiteralType.parseUnsigned(s, 2, 6.MAX_UNSIGNED_INTEGER).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jndi.internal.literals.LiteralType$6", (String)"79", (Object)((Object)this), (Object[])new Object[]{s});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to parse binary int", (Object[])new Object[]{s});
                }
                return s;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(6.class);
        }
    }
    ,
    INTEGER_OCTAL("0(?:_*[0-7]){1,11}"){
        static final long serialVersionUID = -6050615831397929347L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        Object parse(String s) {
            s = s.replaceAll("_*", "");
            try {
                return LiteralType.parseUnsigned(s, 8, 7.MAX_UNSIGNED_INTEGER).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jndi.internal.literals.LiteralType$7", (String)"93", (Object)((Object)this), (Object[])new Object[]{s});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to parse octal int", (Object[])new Object[]{s});
                }
                return s;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(7.class);
        }
    }
    ,
    INTEGER_DENARY("[+-]?(0|[1-9](?:_*[0-9]){0,9})"){
        static final long serialVersionUID = 2295888906931285428L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        Object parse(String s) {
            s = s.replaceAll("_*", "");
            try {
                return Integer.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jndi.internal.literals.LiteralType$8", (String)"106", (Object)((Object)this), (Object[])new Object[]{s});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to parse int", (Object[])new Object[]{s});
                }
                return s;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(8.class);
        }
    }
    ,
    INTEGER_HEX("0[Xx][0-9A-Fa-f](?:_*[0-9A-Fa-f]){0,7}"){
        static final long serialVersionUID = -6852688345304469341L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        Object parse(String s) {
            s = s.replaceAll("_*", "").substring(2);
            try {
                return LiteralType.parseUnsigned(s, 16, 9.MAX_UNSIGNED_INTEGER).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jndi.internal.literals.LiteralType$9", (String)"120", (Object)((Object)this), (Object[])new Object[]{s});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to parse hex int", (Object[])new Object[]{s});
                }
                return s;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(9.class);
        }
    }
    ,
    LONG_BINARY("0[Bb][01](?:_*[01]){0,63}[Ll]"){
        static final long serialVersionUID = 8685645300891204258L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        Object parse(String s) {
            s = s.replaceAll("_*", "").replaceAll("[Ll]$", "").substring(2);
            try {
                return LiteralType.parseUnsigned(s, 2, 10.MAX_UNSIGNED_LONG).longValue();
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jndi.internal.literals.LiteralType$10", (String)"134", (Object)((Object)this), (Object[])new Object[]{s});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to parse binary long", (Object[])new Object[]{s});
                }
                return s;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(10.class);
        }
    }
    ,
    LONG_OCTAL("0(?:_*[0-7]){1,23}[Ll]"){
        static final long serialVersionUID = -6619343371022419413L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        Object parse(String s) {
            s = s.replaceAll("_*", "").replaceAll("[Ll]$", "");
            try {
                return LiteralType.parseUnsigned(s, 8, 11.MAX_UNSIGNED_LONG).longValue();
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jndi.internal.literals.LiteralType$11", (String)"148", (Object)((Object)this), (Object[])new Object[]{s});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to parse octal long", (Object[])new Object[]{s});
                }
                return s;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(11.class);
        }
    }
    ,
    LONG_DENARY("[+-]?[1-9](?:_*[0-9]){0,18}[Ll]"){
        static final long serialVersionUID = 4340716287305101720L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        Object parse(String s) {
            s = s.replaceAll("_*", "").replaceAll("[Ll]$", "");
            try {
                return Long.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jndi.internal.literals.LiteralType$12", (String)"161", (Object)((Object)this), (Object[])new Object[]{s});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to parse long", (Object[])new Object[]{s});
                }
                return s;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(12.class);
        }
    }
    ,
    LONG_HEX("0[Xx][0-9A-Fa-f](?:_*[0-9A-Fa-f]){0,15}[Ll]"){
        static final long serialVersionUID = 9198821055957662516L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        Object parse(String s) {
            s = s.replaceAll("_*", "").replaceAll("[Ll]$", "").substring(2);
            try {
                return LiteralType.parseUnsigned(s, 16, 13.MAX_UNSIGNED_LONG).longValue();
            }
            catch (NumberFormatException numberFormatException) {
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jndi.internal.literals.LiteralType$13", (String)"175", (Object)((Object)this), (Object[])new Object[]{s});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed to parse hex long", (Object[])new Object[]{s});
                }
                return s;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(13.class);
        }
    }
    ,
    STRING("\".*"){
        static final long serialVersionUID = 5696056570617087760L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        Object parse(String s) {
            return StringParser.parse(s);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(14.class);
        }
    };

    static final TraceComponent tc;
    static final BigInteger MAX_UNSIGNED_INTEGER;
    static final BigInteger MAX_UNSIGNED_LONG;
    final Pattern pattern;
    static final long serialVersionUID = 153415112200490437L;

    private LiteralType(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    boolean matches(String s) {
        return this.pattern.matcher(s).matches();
    }

    abstract Object parse(String var1);

    private static BigInteger parseUnsigned(String s, int radix, BigInteger maxValue) {
        BigInteger i = new BigInteger(s, radix);
        if (i.compareTo(BigInteger.ZERO) < 0 || i.compareTo(maxValue) > 0) {
            throw new NumberFormatException();
        }
        return i;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.AlpineTracingMethodAdapter"})
    static {
        tc = Tr.register(LiteralType.class);
        MAX_UNSIGNED_INTEGER = new BigInteger("2").pow(32).subtract(BigInteger.ONE);
        MAX_UNSIGNED_LONG = new BigInteger("2").pow(64).subtract(BigInteger.ONE);
    }
}

