/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.flow.Flow;
import org.apache.myfaces.flow.impl.FlowScopeMap;
import org.apache.myfaces.spi.FacesFlowProvider;

public class DefaultFacesFlowProvider
extends FacesFlowProvider {
    private static final String FLOW_PREFIX = "oam.flow";
    static final String FLOW_SESSION_MAP_SUBKEY_PREFIX = "oam.flow.SCOPE";
    static final char SEPARATOR_CHAR = '.';
    private static final String CURRENT_FLOW_SCOPE_MAP = "oam.flow.SCOPE_MAP";

    @Override
    public Iterator<Flow> getAnnotatedFlows(FacesContext facesContext) {
        return null;
    }

    @Override
    public void doAfterEnterFlow(FacesContext facesContext, Flow flow) {
        String mapKey = "oam.flow.SCOPE_MAP." + flow.getDefiningDocumentId() + '.' + flow.getId();
        facesContext.getAttributes().remove(mapKey);
    }

    @Override
    public void doBeforeExitFlow(FacesContext facesContext, Flow flow) {
        String flowMapKey = flow.getClientWindowFlowId(facesContext.getExternalContext().getClientWindow());
        String fullToken = "oam.flow.SCOPE." + flowMapKey;
        String mapKey = "oam.flow.SCOPE_MAP." + flow.getDefiningDocumentId() + '.' + flow.getId();
        Map map = (Map)facesContext.getAttributes().get(mapKey);
        if (map != null) {
            map.clear();
        } else {
            map = (Map)facesContext.getExternalContext().getSessionMap().get(fullToken);
            if (map != null) {
                map.clear();
            }
        }
        facesContext.getExternalContext().getSessionMap().remove(fullToken);
        facesContext.getAttributes().remove(mapKey);
    }

    @Override
    public Map<Object, Object> getCurrentFlowScope(FacesContext facesContext) {
        Flow flow = facesContext.getApplication().getFlowHandler().getCurrentFlow(facesContext);
        Map map = null;
        if (flow != null) {
            String mapKey = "oam.flow.SCOPE_MAP." + flow.getDefiningDocumentId() + '.' + flow.getId();
            map = (Map)facesContext.getAttributes().get(mapKey);
            if (map == null) {
                String flowMapKey = flow.getClientWindowFlowId(facesContext.getExternalContext().getClientWindow());
                map = new FlowScopeMap(this, flowMapKey);
                facesContext.getAttributes().put(mapKey, map);
            }
        }
        return map;
    }

    Map<Object, Object> createOrRestoreMap(FacesContext context, String prefix, boolean create) {
        ExternalContext external = context.getExternalContext();
        Map sessionMap = external.getSessionMap();
        ConcurrentHashMap map = (ConcurrentHashMap)sessionMap.get(prefix);
        if (map == null && create) {
            map = new ConcurrentHashMap();
            sessionMap.put(prefix, map);
        }
        return map;
    }
}

