/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.osgi;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.logging.internal.osgi.TrLogImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;

public class TrLogEntry
implements LogEntry,
FFDCSelfIntrospectable {
    protected final TrLogImpl logImpl;
    final long timestamp;
    final int level;
    final String msg;
    final Bundle b;
    final ServiceReference<?> sr;
    final Throwable t;
    final EventObject event;
    transient String toString;

    protected TrLogEntry(TrLogImpl logImpl, long timestamp, int level, String msg, Bundle b, ServiceReference<?> sr, Throwable t, EventObject event) {
        this.logImpl = logImpl;
        this.timestamp = timestamp;
        this.level = level;
        this.msg = msg;
        this.b = b;
        this.sr = sr;
        this.t = t;
        this.event = event;
    }

    public Bundle getBundle() {
        return this.b;
    }

    public ServiceReference getServiceReference() {
        return this.sr;
    }

    public int getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.msg;
    }

    public Throwable getException() {
        return this.t;
    }

    public long getTime() {
        return this.timestamp;
    }

    Object[] getObjects(boolean translatedMsg) {
        String sString;
        ArrayList<Object> list = new ArrayList<Object>(5);
        if (translatedMsg && this.msg != null) {
            list.add(this.msg);
        }
        if (translatedMsg && this.b != null) {
            String bString = String.format("Bundle:%s(id=%d)", this.b.getSymbolicName(), this.b.getBundleId());
            list.add(bString);
        }
        if (this.sr != null) {
            sString = String.format("ServiceRef:%s(id=%s, pid=%s)", Arrays.asList((String[])this.sr.getProperty("objectClass")), this.sr.getProperty("service.id"), this.sr.getProperty("service.pid"));
            list.add(sString);
        }
        if (this.t != null) {
            list.add(this.t);
        }
        if (this.event != null) {
            sString = String.format("Event:%s", this.event.toString());
            list.add(sString);
        }
        if (translatedMsg) {
            while (list.size() < 5) {
                list.add("");
            }
        }
        return list.toArray();
    }

    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        StringBuilder str = new StringBuilder(this.getClass().getSimpleName());
        str.append("[").append(this.msg);
        str.append(",Bundle:").append(this.b.getSymbolicName());
        str.append("(").append(this.b.getBundleId()).append(")");
        if (this.sr != null) {
            str.append(",ServiceRef:");
            str.append(Arrays.asList((String[])this.sr.getProperty("objectClass")));
            str.append("(id=").append(this.sr.getProperty("service.id"));
            str.append(",pid=").append(this.sr.getProperty("service.pid"));
            str.append(")");
        }
        if (this.event != null) {
            str.append(",Event:").append(this.event.toString());
        }
        str.append("]");
        this.toString = str.toString();
        return this.toString;
    }

    public String[] introspectSelf() {
        Object[] objs = this.getObjects(true);
        ArrayList<String> strs = new ArrayList<String>(objs.length);
        for (Object o : objs) {
            String s = o.toString();
            if (s.length() <= 0) continue;
            strs.add(s);
        }
        return strs.toArray(new String[strs.size()]);
    }

    public void publish(Collection<LogListener> listeners, EventAdmin service) {
        for (LogListener l : listeners) {
            try {
                l.logged((LogEntry)this);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"run-1", (Object[])new Object[]{l, this});
            }
        }
        if (service != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("log.level", this.level);
            map.put("log.entry", this);
            map.put("message", this.msg);
            map.put("timestamp", this.timestamp);
            map.put("bundle", this.b);
            map.put("bundle.id", this.b.getBundleId());
            String symName = this.b.getSymbolicName();
            if (symName != null) {
                map.put("bundle.symbolicName", symName);
            }
            if (this.t != null) {
                map.put("exception.class", this.t.getClass());
                map.put("exception.message", this.t.getMessage());
                map.put("exception", this.t);
            }
            if (this.sr != null) {
                map.put("service", this.sr);
                map.put("service.id", this.sr.getProperty("service.id"));
                Object pid = this.sr.getProperty("service.pid");
                if (pid != null) {
                    map.put("service.pid", pid);
                }
                map.put("service.objectClass", this.sr.getProperty("service.objectClass"));
            }
            Event event = new Event(TrLogImpl.LogEvent.getTopic(this.level), map);
            try {
                service.postEvent(event);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"run-2", (Object[])new Object[]{this, event});
            }
        }
    }
}

