/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ola;

import jakarta.resource.cci.MappedRecord;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MappedRecordImpl
implements MappedRecord {
    private static final long serialVersionUID = 1L;
    private static final String RECORD_BYTES_CLASSNAME = "com.ibm.etools.marshall.RecordBytes";
    private String recordName;
    private String recordDescription;
    private HashMap<String, byte[]> containerMap;
    private int dataSize;

    public MappedRecordImpl() {
        this.containerMap = new HashMap();
        this.dataSize = 0;
    }

    public MappedRecordImpl(String newRecordName, String newRecordDescription, HashMap newMap) {
        this.recordName = newRecordName;
        this.recordDescription = newRecordDescription;
        this.containerMap = new HashMap();
        this.containerMap.putAll(newMap);
    }

    private MappedRecordImpl(MappedRecordImpl base) {
        this.recordName = base.getRecordName();
        this.recordDescription = base.getRecordShortDescription();
        this.dataSize = base.getDataSize();
        this.containerMap.putAll(base.containerMap);
    }

    public String getRecordName() {
        return this.recordName;
    }

    public String getRecordShortDescription() {
        return this.recordDescription;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public void setRecordName(String name) {
        this.recordName = name;
    }

    public void setRecordShortDescription(String description) {
        this.recordDescription = description;
    }

    public void clear() {
        this.containerMap.clear();
        this.dataSize = 0;
    }

    public boolean containsKey(Object key) {
        return this.containerMap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.containerMap.containsValue(value);
    }

    public Set<Map.Entry<String, byte[]>> entrySet() {
        return this.containerMap.entrySet();
    }

    public byte[] get(Object key) {
        return this.containerMap.get(key);
    }

    public boolean isEmpty() {
        return this.containerMap.isEmpty();
    }

    public Set<String> keySet() {
        return this.containerMap.keySet();
    }

    private boolean isRecordBytes(Object o) {
        try {
            Class<?> recordClass = o.getClass();
            ClassLoader cl = recordClass.getClassLoader();
            Class<?> recordBytesClass = cl.loadClass(RECORD_BYTES_CLASSNAME);
            return recordBytesClass.isAssignableFrom(recordClass);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public byte[] put(Object key, Object value) {
        byte[] inputBytes = null;
        if (value instanceof byte[]) {
            inputBytes = (byte[])value;
        } else if (this.isRecordBytes(value)) {
            try {
                Class<?> c = value.getClass();
                Method m = c.getMethod("getBytes", new Class[0]);
                inputBytes = (byte[])m.invoke(value, (Object[])null);
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("Unable to store RecordBytes into MappedRecord", t);
            }
        } else {
            throw new IllegalArgumentException();
        }
        if (!(key instanceof String)) {
            throw new IllegalArgumentException();
        }
        byte[] returnBytes = this.containerMap.put((String)key, inputBytes);
        if (returnBytes != null) {
            this.dataSize -= returnBytes.length;
        }
        this.dataSize += inputBytes.length;
        return returnBytes;
    }

    public void putAll(Map t) {
        this.containerMap.putAll(t);
        Set keys = t.keySet();
        int dataSizeToAdd = 0;
        for (String currentKey : keys) {
            dataSizeToAdd += ((byte[])t.get(currentKey)).length;
        }
        this.dataSize += dataSizeToAdd;
    }

    public byte[] remove(Object key) {
        byte[] returnBytes = this.containerMap.remove(key);
        if (returnBytes != null) {
            this.dataSize -= returnBytes.length;
        }
        return returnBytes;
    }

    public int size() {
        return this.containerMap.size();
    }

    public Collection<byte[]> values() {
        return this.containerMap.values();
    }

    public Object clone() {
        return new MappedRecordImpl(this);
    }
}

