/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.testerui;

import java.awt.Color;

public enum TesterUIColors {
    CUSTOM("- (custom settings)", 0, 0, 0, 0),
    EXERCISER("exerciser", 0xFFFFFB, 0xFFFFFB, 0xEEEEEE, 0xFFEEEE),
    PASTEL("pastel", 0xEEFFFF, 0xFFFFEE, 0xEEFFEE, 0xFFEEEE);

    private final String uiName;
    private final Color colorInput;
    private final Color colorJsonata;
    private final Color colorOutput;
    private final Color colorError;

    private TesterUIColors(String uiName, int colorInput, int colorJsonata, int colorOutput, int colorError) {
        this.uiName = uiName;
        this.colorInput = new Color(colorInput);
        this.colorJsonata = new Color(colorJsonata);
        this.colorOutput = new Color(colorOutput);
        this.colorError = new Color(colorError);
    }

    public static TesterUIColors fromColors(Color colorInput, Color colorJsonata, Color colorOutput, Color colorError) {
        for (TesterUIColors color : TesterUIColors.values()) {
            if (color == CUSTOM || !colorInput.equals(color.getColorInput()) || !colorJsonata.equals(color.getColorJsonata()) || !colorOutput.equals(color.getColorOutput()) || !colorError.equals(color.getColorError())) continue;
            return color;
        }
        return CUSTOM;
    }

    public String toString() {
        return this.uiName;
    }

    public Color getColorInput() {
        return this.colorInput;
    }

    public Color getColorJsonata() {
        return this.colorJsonata;
    }

    public Color getColorOutput() {
        return this.colorOutput;
    }

    public Color getColorError() {
        return this.colorError;
    }
}

