/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.functions;

import com.api.jsonata4java.expressions.EvaluateRuntimeException;
import com.api.jsonata4java.expressions.ExpressionsVisitor;
import com.api.jsonata4java.expressions.RegularExpression;
import com.api.jsonata4java.expressions.functions.FunctionBase;
import com.api.jsonata4java.expressions.generated.MappingExpressionParser;
import com.api.jsonata4java.expressions.utils.FunctionUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.POJONode;

public class ContainsFunction
extends FunctionBase {
    public static String ERR_BAD_CONTEXT = String.format("Context value is not a compatible type with argument 1 of function \"%s\"", "$contains");
    public static String ERR_ARG1BADTYPE = String.format("Argument 1 of function %s does not match function signature", "$contains");
    public static String ERR_ARG2BADTYPE = String.format("Argument 2 of function %s does not match function signature", "$contains");
    public static String ERR_ARG3BADTYPE = String.format("Argument 3 of function %s does not match function signature", "$contains");
    public static ObjectMapper s_objectMapper = new ObjectMapper();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JsonNode invoke(ExpressionsVisitor expressionVisitor, MappingExpressionParser.Function_callContext ctx) {
        BooleanNode result = null;
        JsonNode argString = JsonNodeFactory.instance.nullNode();
        boolean useContext = FunctionUtils.useContextVariable(this, ctx, this.getSignature());
        int argCount = ContainsFunction.getArgumentCount(ctx);
        if (useContext) {
            argString = FunctionUtils.getContextVariable(expressionVisitor);
            if (argString != null && !argString.isNull()) {
                if (!argString.isTextual()) {
                    if (!argString.isObject()) throw new EvaluateRuntimeException(ERR_BAD_CONTEXT);
                    argString = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
                } else {
                    ++argCount;
                }
            } else {
                useContext = false;
            }
        }
        if (argCount != 2) throw new EvaluateRuntimeException(argCount < 2 ? ERR_BAD_CONTEXT : ERR_ARG3BADTYPE);
        if (!useContext) {
            argString = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, 0);
        }
        if (argString == null) {
            return null;
        }
        if (!argString.isTextual()) {
            throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        }
        JsonNode argPattern = FunctionUtils.getValuesListExpression(expressionVisitor, ctx, useContext ? 0 : 1);
        if (!argString.isTextual()) {
            throw new EvaluateRuntimeException(ERR_ARG1BADTYPE);
        }
        String str = argString.textValue();
        if (argPattern == null) throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
        if (argPattern.isTextual()) {
            return str.contains(argPattern.textValue()) ? BooleanNode.TRUE : BooleanNode.FALSE;
        }
        if (!(argPattern instanceof POJONode)) throw new EvaluateRuntimeException(ERR_ARG2BADTYPE);
        RegularExpression regex = (RegularExpression)((POJONode)argPattern).getPojo();
        return regex.getPattern().matcher(str).find() ? BooleanNode.TRUE : BooleanNode.FALSE;
    }

    @Override
    public int getMaxArgs() {
        return 2;
    }

    @Override
    public int getMinArgs() {
        return 1;
    }

    @Override
    public String getSignature() {
        return "<s-(sf):b>";
    }
}

