/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.s3;

import com.ibm.cloud.objectstorage.ClientConfigurationFactory;
import com.ibm.cloud.objectstorage.annotation.NotThreadSafe;
import com.ibm.cloud.objectstorage.annotation.SdkTestInternalApi;
import com.ibm.cloud.objectstorage.client.builder.AwsSyncClientBuilder;
import com.ibm.cloud.objectstorage.internal.SdkFunction;
import com.ibm.cloud.objectstorage.regions.AwsRegionProvider;
import com.ibm.cloud.objectstorage.services.s3.AmazonS3;
import com.ibm.cloud.objectstorage.services.s3.AmazonS3Client;
import com.ibm.cloud.objectstorage.services.s3.AmazonS3ClientConfigurationFactory;
import com.ibm.cloud.objectstorage.services.s3.AmazonS3ClientParamsWrapper;
import com.ibm.cloud.objectstorage.services.s3.S3ClientOptions;

@NotThreadSafe
public abstract class AmazonS3Builder<Subclass extends AmazonS3Builder, TypeToBuild extends AmazonS3>
extends AwsSyncClientBuilder<Subclass, TypeToBuild> {
    private static final AmazonS3ClientConfigurationFactory CLIENT_CONFIG_FACTORY = new AmazonS3ClientConfigurationFactory();
    private static final SdkFunction<AmazonS3ClientParamsWrapper, AmazonS3> DEFAULT_CLIENT_FACTORY = new SdkFunction<AmazonS3ClientParamsWrapper, AmazonS3>(){

        public AmazonS3 apply(AmazonS3ClientParamsWrapper params) {
            return new AmazonS3Client(params);
        }
    };
    protected final SdkFunction<AmazonS3ClientParamsWrapper, AmazonS3> clientFactory;
    private Boolean pathStyleAccessEnabled;
    private Boolean chunkedEncodingDisabled;
    private Boolean accelerateModeEnabled;
    private Boolean payloadSigningEnabled;
    private Boolean dualstackEnabled;
    private Boolean forceGlobalBucketAccessEnabled;

    protected AmazonS3Builder() {
        super((ClientConfigurationFactory)CLIENT_CONFIG_FACTORY);
        this.clientFactory = DEFAULT_CLIENT_FACTORY;
    }

    @SdkTestInternalApi
    AmazonS3Builder(SdkFunction<AmazonS3ClientParamsWrapper, AmazonS3> clientFactory, ClientConfigurationFactory clientConfigFactory, AwsRegionProvider regionProvider) {
        super(clientConfigFactory, regionProvider);
        this.clientFactory = clientFactory;
    }

    public Boolean isPathStyleAccessEnabled() {
        return this.pathStyleAccessEnabled;
    }

    public void setPathStyleAccessEnabled(Boolean pathStyleAccessEnabled) {
        this.pathStyleAccessEnabled = pathStyleAccessEnabled;
    }

    public Subclass withPathStyleAccessEnabled(Boolean pathStyleAccessEnabled) {
        this.setPathStyleAccessEnabled(pathStyleAccessEnabled);
        return (Subclass)((Object)((AmazonS3Builder)this.getSubclass()));
    }

    public Subclass enablePathStyleAccess() {
        this.setPathStyleAccessEnabled(Boolean.TRUE);
        return (Subclass)((Object)((AmazonS3Builder)this.getSubclass()));
    }

    public Boolean isChunkedEncodingDisabled() {
        return this.chunkedEncodingDisabled;
    }

    public void setChunkedEncodingDisabled(Boolean chunkedEncodingDisabled) {
        this.chunkedEncodingDisabled = chunkedEncodingDisabled;
    }

    public Subclass withChunkedEncodingDisabled(Boolean chunkedEncodingDisabled) {
        this.setChunkedEncodingDisabled(chunkedEncodingDisabled);
        return (Subclass)((Object)((AmazonS3Builder)this.getSubclass()));
    }

    public Subclass disableChunkedEncoding() {
        this.setChunkedEncodingDisabled(Boolean.TRUE);
        return (Subclass)((Object)((AmazonS3Builder)this.getSubclass()));
    }

    public Boolean isAccelerateModeEnabled() {
        return this.accelerateModeEnabled;
    }

    public void setAccelerateModeEnabled(Boolean accelerateModeEnabled) {
        this.accelerateModeEnabled = accelerateModeEnabled;
    }

    public Subclass withAccelerateModeEnabled(Boolean accelerateModeEnabled) {
        this.setAccelerateModeEnabled(accelerateModeEnabled);
        return (Subclass)((Object)((AmazonS3Builder)this.getSubclass()));
    }

    public Subclass enableAccelerateMode() {
        this.setAccelerateModeEnabled(Boolean.TRUE);
        return (Subclass)((Object)((AmazonS3Builder)this.getSubclass()));
    }

    public Boolean isPayloadSigningEnabled() {
        return this.payloadSigningEnabled;
    }

    public void setPayloadSigningEnabled(Boolean payloadSigningEnabled) {
        this.payloadSigningEnabled = payloadSigningEnabled;
    }

    public Subclass withPayloadSigningEnabled(Boolean payloadSigningEnabled) {
        this.setPayloadSigningEnabled(payloadSigningEnabled);
        return (Subclass)((Object)((AmazonS3Builder)this.getSubclass()));
    }

    public Subclass enablePayloadSigning() {
        this.setPayloadSigningEnabled(Boolean.TRUE);
        return (Subclass)((Object)((AmazonS3Builder)this.getSubclass()));
    }

    public Boolean isDualstackEnabled() {
        return this.dualstackEnabled;
    }

    public void setDualstackEnabled(Boolean dualstackEnabled) {
        this.dualstackEnabled = dualstackEnabled;
    }

    public Subclass withDualstackEnabled(Boolean dualstackEnabled) {
        this.setDualstackEnabled(dualstackEnabled);
        return (Subclass)((Object)((AmazonS3Builder)this.getSubclass()));
    }

    public Subclass enableDualstack() {
        this.setDualstackEnabled(Boolean.TRUE);
        return (Subclass)((Object)((AmazonS3Builder)this.getSubclass()));
    }

    public Boolean isForceGlobalBucketAccessEnabled() {
        return this.forceGlobalBucketAccessEnabled;
    }

    public void setForceGlobalBucketAccessEnabled(Boolean forceGlobalBucketAccessEnabled) {
        this.forceGlobalBucketAccessEnabled = forceGlobalBucketAccessEnabled;
    }

    public Subclass withForceGlobalBucketAccessEnabled(Boolean forceGlobalBucketAccessEnabled) {
        this.setForceGlobalBucketAccessEnabled(forceGlobalBucketAccessEnabled);
        return (Subclass)((Object)((AmazonS3Builder)this.getSubclass()));
    }

    public Subclass enableForceGlobalBucketAccess() {
        this.setForceGlobalBucketAccessEnabled(Boolean.TRUE);
        return (Subclass)((Object)((AmazonS3Builder)this.getSubclass()));
    }

    protected S3ClientOptions resolveS3ClientOptions() {
        S3ClientOptions.Builder builder = S3ClientOptions.builder();
        if (Boolean.TRUE.equals(this.chunkedEncodingDisabled)) {
            builder.disableChunkedEncoding();
        }
        if (this.payloadSigningEnabled != null) {
            builder.setPayloadSigningEnabled(this.payloadSigningEnabled);
        }
        if (this.accelerateModeEnabled != null) {
            builder.setAccelerateModeEnabled(this.accelerateModeEnabled);
        }
        if (this.pathStyleAccessEnabled != null) {
            builder.setPathStyleAccess(this.pathStyleAccessEnabled);
        }
        if (Boolean.TRUE.equals(this.dualstackEnabled)) {
            builder.enableDualstack();
        }
        if (Boolean.TRUE.equals(this.forceGlobalBucketAccessEnabled)) {
            builder.enableForceGlobalBucketAccess();
        }
        return builder.build();
    }
}

