/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.s3.internal;

import com.ibm.cloud.objectstorage.AmazonWebServiceResponse;
import com.ibm.cloud.objectstorage.ResponseMetadata;
import com.ibm.cloud.objectstorage.SdkClientException;
import com.ibm.cloud.objectstorage.http.HttpResponse;
import com.ibm.cloud.objectstorage.http.HttpResponseHandler;
import com.ibm.cloud.objectstorage.services.s3.S3ResponseMetadata;
import com.ibm.cloud.objectstorage.services.s3.internal.ObjectExpirationHeaderHandler;
import com.ibm.cloud.objectstorage.services.s3.internal.ObjectRestoreHeaderHandler;
import com.ibm.cloud.objectstorage.services.s3.internal.ObjectTransitionHeaderHandler;
import com.ibm.cloud.objectstorage.services.s3.internal.S3MetadataResponseHandler;
import com.ibm.cloud.objectstorage.services.s3.internal.S3RequesterChargedHeaderHandler;
import com.ibm.cloud.objectstorage.services.s3.internal.ServiceUtils;
import com.ibm.cloud.objectstorage.services.s3.model.ObjectMetadata;
import com.ibm.cloud.objectstorage.util.DateUtils;
import com.ibm.cloud.objectstorage.util.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractS3ResponseHandler<T>
implements HttpResponseHandler<AmazonWebServiceResponse<T>> {
    private static final Log log = LogFactory.getLog(S3MetadataResponseHandler.class);
    private static final Set<String> ignoredHeaders = new HashSet<String>();

    public boolean needsConnectionLeftOpen() {
        return false;
    }

    protected AmazonWebServiceResponse<T> parseResponseMetadata(HttpResponse response) {
        AmazonWebServiceResponse awsResponse = new AmazonWebServiceResponse();
        String awsRequestId = (String)response.getHeaders().get("x-amz-request-id");
        String hostId = (String)response.getHeaders().get("x-amz-id-2");
        String cloudFrontId = (String)response.getHeaders().get("X-Amz-Cf-Id");
        String IbmProtectionManagementState = (String)response.getHeaders().get("x-ibm-protection-management-state");
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        metadataMap.put("AWS_REQUEST_ID", awsRequestId);
        metadataMap.put("HOST_ID", hostId);
        metadataMap.put("CLOUD_FRONT_ID", cloudFrontId);
        metadataMap.put("IBM_PROTECTION_MANAGEMENT_STATE", IbmProtectionManagementState);
        awsResponse.setResponseMetadata((ResponseMetadata)new S3ResponseMetadata(metadataMap));
        return awsResponse;
    }

    protected void populateObjectMetadata(HttpResponse response, ObjectMetadata metadata) {
        for (Map.Entry header : response.getHeaders().entrySet()) {
            String key = (String)header.getKey();
            if (StringUtils.beginsWithIgnoreCase((String)key, (String)"x-amz-meta-")) {
                key = key.substring("x-amz-meta-".length());
                metadata.addUserMetadata(key, (String)header.getValue());
                continue;
            }
            if (ignoredHeaders.contains(key)) continue;
            if (key.equalsIgnoreCase("Last-Modified")) {
                try {
                    metadata.setHeader(key, ServiceUtils.parseRfc822Date((String)header.getValue()));
                }
                catch (Exception pe) {
                    log.warn((Object)("Unable to parse last modified date: " + (String)header.getValue()), (Throwable)pe);
                }
                continue;
            }
            if (key.equalsIgnoreCase("Content-Length")) {
                try {
                    metadata.setHeader(key, Long.parseLong((String)header.getValue()));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new SdkClientException("Unable to parse content length. Header 'Content-Length' has corrupted data" + nfe.getMessage(), (Throwable)nfe);
                }
            }
            if (key.equalsIgnoreCase("ETag")) {
                metadata.setHeader(key, ServiceUtils.removeQuotes((String)header.getValue()));
                continue;
            }
            if (key.equalsIgnoreCase("Expires")) {
                metadata.setHeader("Expires", header.getValue());
                try {
                    metadata.setHttpExpiresDate(DateUtils.parseRFC822Date((String)((String)header.getValue())));
                }
                catch (Exception pe) {
                    log.warn((Object)("Unable to parse http expiration date: " + (String)header.getValue()), (Throwable)pe);
                }
                continue;
            }
            if (key.equalsIgnoreCase("x-amz-expiration")) {
                new ObjectExpirationHeaderHandler<ObjectMetadata>().handle(metadata, response);
                metadata.setHeader(key, header.getValue());
                continue;
            }
            if (key.equalsIgnoreCase("x-amz-restore")) {
                new ObjectRestoreHeaderHandler<ObjectMetadata>().handle(metadata, response);
                continue;
            }
            if (key.equalsIgnoreCase("x-ibm-transition")) {
                new ObjectTransitionHeaderHandler<ObjectMetadata>().handle(metadata, response);
                metadata.setHeader(key, header.getValue());
                continue;
            }
            if (key.equalsIgnoreCase("x-amz-request-charged")) {
                new S3RequesterChargedHeaderHandler<ObjectMetadata>().handle(metadata, response);
                continue;
            }
            if (key.equalsIgnoreCase("x-amz-mp-parts-count")) {
                try {
                    metadata.setHeader(key, Integer.parseInt((String)header.getValue()));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new SdkClientException("Unable to parse part count. Header x-amz-mp-parts-count has corrupted data" + nfe.getMessage(), (Throwable)nfe);
                }
            }
            if (key.equalsIgnoreCase("retention-expiration-date")) {
                try {
                    metadata.setRetentionExpirationDate(ServiceUtils.parseRfc822Date((String)header.getValue()));
                }
                catch (Exception pe) {
                    log.warn((Object)("Unable to parse retention expiration date: " + (String)header.getValue()), (Throwable)pe);
                }
                continue;
            }
            if (key.equalsIgnoreCase("retention-legal-hold-count")) {
                try {
                    metadata.setRetentionLegalHoldCount(Integer.parseInt((String)header.getValue()));
                }
                catch (NumberFormatException nfe) {
                    log.warn((Object)("Unable to parse legal hold count: " + (String)header.getValue()), (Throwable)nfe);
                }
                continue;
            }
            if (key.equalsIgnoreCase("retention-period")) {
                try {
                    metadata.setRetentionPeriod(Long.parseLong((String)header.getValue()));
                }
                catch (NumberFormatException nfe) {
                    log.warn((Object)("Unable to parse retention period: " + (String)header.getValue()), (Throwable)nfe);
                }
                continue;
            }
            metadata.setHeader(key, header.getValue());
        }
    }

    static {
        ignoredHeaders.add("Date");
        ignoredHeaders.add("Server");
        ignoredHeaders.add("x-amz-request-id");
        ignoredHeaders.add("x-amz-id-2");
        ignoredHeaders.add("X-Amz-Cf-Id");
        ignoredHeaders.add("Connection");
    }
}

