/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.features;

import com.ibm.cloud.cloudant.features.ChangesFollower;
import com.ibm.cloud.cloudant.v1.model.PostChangesOptions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

class ChangesOptionsHelper {
    static final long MIN_CLIENT_TIMEOUT = Duration.ofMinutes(1L).toMillis();
    static final long LONGPOLL_TIMEOUT = MIN_CLIENT_TIMEOUT - TimeUnit.SECONDS.toMillis(3L);
    private static final String singleOptionErrorFormat = "The option %s is invalid when using %s.";
    private static final String multipleOptionErrorFormat = "The options %s are invalid when using %s.";

    private ChangesOptionsHelper() {
    }

    static PostChangesOptions cloneOptions(PostChangesOptions options) {
        return ChangesOptionsHelper.cloneOptions(options, options.since(), options.limit());
    }

    static PostChangesOptions cloneOptionsWithNewLimit(PostChangesOptions options, Long limit) {
        return ChangesOptionsHelper.cloneOptions(options, options.since(), limit);
    }

    static PostChangesOptions cloneOptionsWithNewSince(PostChangesOptions options, String since) {
        return ChangesOptionsHelper.cloneOptions(options, since, options.limit());
    }

    private static PostChangesOptions cloneOptions(PostChangesOptions options, String since, Long limit) {
        PostChangesOptions.Builder builder = new PostChangesOptions.Builder(options.db()).attEncodingInfo(options.attEncodingInfo()).attachments(options.attachments()).conflicts(options.conflicts()).docIds(options.docIds()).feed("longpoll").fields(options.fields()).filter(options.filter()).includeDocs(options.includeDocs()).selector(options.selector()).since(since).style(options.style()).timeout(LONGPOLL_TIMEOUT).view(options.view());
        if (limit != null) {
            builder.limit(limit);
        }
        if (options.seqInterval() != null) {
            builder.seqInterval(options.seqInterval());
        }
        return builder.build();
    }

    private static String throwInvalidOptionsMessageWith(String suffix, List<String> invalidOptions) {
        String errorMsgFormat = invalidOptions.size() > 1 ? multipleOptionErrorFormat : singleOptionErrorFormat;
        String errorMsg = String.format(errorMsgFormat, invalidOptions.stream().collect(Collectors.joining("', '", "'", "'")), ChangesFollower.class.getSimpleName());
        throw new IllegalArgumentException(errorMsg);
    }

    static void validateOptions(PostChangesOptions options) {
        ArrayList<String> invalidOptions = new ArrayList<String>();
        if (options.descending() != null) {
            invalidOptions.add("descending");
        }
        if (options.feed() != null) {
            invalidOptions.add("feed");
        }
        if (options.heartbeat() != null) {
            invalidOptions.add("heartbeat");
        }
        if (options.lastEventId() != null) {
            invalidOptions.add("lastEventId");
        }
        if (options.timeout() != null) {
            invalidOptions.add("timeout");
        }
        if (options.filter() != null && !"_selector".equals(options.filter())) {
            invalidOptions.add(String.format("filter=%s", options.filter()));
        }
        if (invalidOptions.size() > 0) {
            ChangesOptionsHelper.throwInvalidOptionsMessageWith(String.format(" when using %s.", ChangesFollower.class.getSimpleName()), invalidOptions);
        }
    }
}

