/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.features.pagination;

import com.ibm.cloud.cloudant.features.pagination.Pager;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

final class IteratorPager<O, I>
implements Pager<I> {
    private State state = State.NEW;
    private final Iterable<List<I>> pageIterable;
    private final Iterator<List<I>> pageIterator;

    IteratorPager(Iterable<List<I>> pageIterable) {
        this.pageIterable = pageIterable;
        this.pageIterator = pageIterable.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.pageIterator.hasNext();
    }

    @Override
    public List<I> getNext() {
        this.checkState(State.GET_NEXT);
        List<I> page = this.pageIterator.next();
        if (!this.hasNext()) {
            this.state = State.CONSUMED;
        }
        return page;
    }

    @Override
    public List<I> getAll() {
        this.checkState(State.GET_ALL);
        List allRows = StreamSupport.stream(this.pageIterable.spliterator(), false).flatMap(Collection::stream).collect(Collectors.toList());
        this.state = State.CONSUMED;
        return allRows;
    }

    private void checkState(State mode) {
        if (this.state == mode) {
            return;
        }
        switch (this.state.ordinal()) {
            case 0: {
                this.state = mode;
                break;
            }
            case 3: {
                throw new IllegalStateException("This pager has been consumed use a new Pager.");
            }
            default: {
                throw new IllegalStateException("Cannot mix getAll() and getNext() use only one method or get a a new Pager.");
            }
        }
    }

    static enum State {
        NEW,
        GET_NEXT,
        GET_ALL,
        CONSUMED;

    }
}

