/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PostChangesOptions
extends GenericModel {
    protected String db;
    protected List<String> docIds;
    protected List<String> fields;
    protected Map<String, Object> selector;
    protected String lastEventId;
    protected Boolean attEncodingInfo;
    protected Boolean attachments;
    protected Boolean conflicts;
    protected Boolean descending;
    protected String feed;
    protected String filter;
    protected Long heartbeat;
    protected Boolean includeDocs;
    protected Long limit;
    protected Long seqInterval;
    protected String since;
    protected String style;
    protected Long timeout;
    protected String view;

    protected PostChangesOptions() {
    }

    protected PostChangesOptions(Builder builder) {
        Validator.notEmpty((String)builder.db, (String)"db cannot be empty");
        this.db = builder.db;
        this.docIds = builder.docIds;
        this.fields = builder.fields;
        this.selector = builder.selector;
        this.lastEventId = builder.lastEventId;
        this.attEncodingInfo = builder.attEncodingInfo;
        this.attachments = builder.attachments;
        this.conflicts = builder.conflicts;
        this.descending = builder.descending;
        this.feed = builder.feed;
        this.filter = builder.filter;
        this.heartbeat = builder.heartbeat;
        this.includeDocs = builder.includeDocs;
        this.limit = builder.limit;
        this.seqInterval = builder.seqInterval;
        this.since = builder.since;
        this.style = builder.style;
        this.timeout = builder.timeout;
        this.view = builder.view;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public List<String> docIds() {
        return this.docIds;
    }

    public List<String> fields() {
        return this.fields;
    }

    public Map<String, Object> selector() {
        return this.selector;
    }

    public String lastEventId() {
        return this.lastEventId;
    }

    public Boolean attEncodingInfo() {
        return this.attEncodingInfo;
    }

    public Boolean attachments() {
        return this.attachments;
    }

    public Boolean conflicts() {
        return this.conflicts;
    }

    public Boolean descending() {
        return this.descending;
    }

    public String feed() {
        return this.feed;
    }

    public String filter() {
        return this.filter;
    }

    public Long heartbeat() {
        return this.heartbeat;
    }

    public Boolean includeDocs() {
        return this.includeDocs;
    }

    public Long limit() {
        return this.limit;
    }

    public Long seqInterval() {
        return this.seqInterval;
    }

    public String since() {
        return this.since;
    }

    public String style() {
        return this.style;
    }

    public Long timeout() {
        return this.timeout;
    }

    public String view() {
        return this.view;
    }

    public static class Builder {
        private String db;
        private List<String> docIds;
        private List<String> fields;
        private Map<String, Object> selector;
        private String lastEventId;
        private Boolean attEncodingInfo;
        private Boolean attachments;
        private Boolean conflicts;
        private Boolean descending;
        private String feed;
        private String filter;
        private Long heartbeat;
        private Boolean includeDocs;
        private Long limit;
        private Long seqInterval;
        private String since;
        private String style;
        private Long timeout;
        private String view;

        private Builder(PostChangesOptions postChangesOptions) {
            this.db = postChangesOptions.db;
            this.docIds = postChangesOptions.docIds;
            this.fields = postChangesOptions.fields;
            this.selector = postChangesOptions.selector;
            this.lastEventId = postChangesOptions.lastEventId;
            this.attEncodingInfo = postChangesOptions.attEncodingInfo;
            this.attachments = postChangesOptions.attachments;
            this.conflicts = postChangesOptions.conflicts;
            this.descending = postChangesOptions.descending;
            this.feed = postChangesOptions.feed;
            this.filter = postChangesOptions.filter;
            this.heartbeat = postChangesOptions.heartbeat;
            this.includeDocs = postChangesOptions.includeDocs;
            this.limit = postChangesOptions.limit;
            this.seqInterval = postChangesOptions.seqInterval;
            this.since = postChangesOptions.since;
            this.style = postChangesOptions.style;
            this.timeout = postChangesOptions.timeout;
            this.view = postChangesOptions.view;
        }

        public Builder() {
        }

        public Builder(String db) {
            this.db = db;
        }

        public PostChangesOptions build() {
            return new PostChangesOptions(this);
        }

        public Builder addDocIds(String docIds) {
            Validator.notNull((Object)docIds, (String)"docIds cannot be null");
            if (this.docIds == null) {
                this.docIds = new ArrayList<String>();
            }
            this.docIds.add(docIds);
            return this;
        }

        public Builder addFields(String fields) {
            Validator.notNull((Object)fields, (String)"fields cannot be null");
            if (this.fields == null) {
                this.fields = new ArrayList<String>();
            }
            this.fields.add(fields);
            return this;
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder docIds(List<String> docIds) {
            this.docIds = docIds;
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public Builder selector(Map<String, Object> selector) {
            this.selector = selector;
            return this;
        }

        public Builder lastEventId(String lastEventId) {
            this.lastEventId = lastEventId;
            return this;
        }

        public Builder attEncodingInfo(Boolean attEncodingInfo) {
            this.attEncodingInfo = attEncodingInfo;
            return this;
        }

        public Builder attachments(Boolean attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder conflicts(Boolean conflicts) {
            this.conflicts = conflicts;
            return this;
        }

        public Builder descending(Boolean descending) {
            this.descending = descending;
            return this;
        }

        public Builder feed(String feed) {
            this.feed = feed;
            return this;
        }

        public Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder heartbeat(long heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        public Builder includeDocs(Boolean includeDocs) {
            this.includeDocs = includeDocs;
            return this;
        }

        public Builder limit(long limit) {
            this.limit = limit;
            return this;
        }

        public Builder seqInterval(long seqInterval) {
            this.seqInterval = seqInterval;
            return this;
        }

        public Builder since(String since) {
            this.since = since;
            return this;
        }

        public Builder style(String style) {
            this.style = style;
            return this;
        }

        public Builder timeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder view(String view) {
            this.view = view;
            return this;
        }
    }

    public static interface Style {
        public static final String MAIN_ONLY = "main_only";
        public static final String ALL_DOCS = "all_docs";
    }

    public static interface Feed {
        public static final String CONTINUOUS = "continuous";
        public static final String EVENTSOURCE = "eventsource";
        public static final String LONGPOLL = "longpoll";
        public static final String NORMAL = "normal";
    }
}

