/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class PutDatabaseOptions
extends GenericModel {
    protected String db;
    protected Boolean partitioned;
    protected Long q;

    protected PutDatabaseOptions() {
    }

    protected PutDatabaseOptions(Builder builder) {
        Validator.notEmpty((String)builder.db, (String)"db cannot be empty");
        this.db = builder.db;
        this.partitioned = builder.partitioned;
        this.q = builder.q;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public Boolean partitioned() {
        return this.partitioned;
    }

    public Long q() {
        return this.q;
    }

    public static class Builder {
        private String db;
        private Boolean partitioned;
        private Long q;

        private Builder(PutDatabaseOptions putDatabaseOptions) {
            this.db = putDatabaseOptions.db;
            this.partitioned = putDatabaseOptions.partitioned;
            this.q = putDatabaseOptions.q;
        }

        public Builder() {
        }

        public Builder(String db) {
            this.db = db;
        }

        public PutDatabaseOptions build() {
            return new PutDatabaseOptions(this);
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder partitioned(Boolean partitioned) {
            this.partitioned = partitioned;
            return this;
        }

        public Builder q(long q) {
            this.q = q;
            return this;
        }
    }
}

