/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.cloudant.v1.model.BulkDocs;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class PostBulkDocsOptions
extends GenericModel {
    protected String db;
    protected BulkDocs bulkDocs;
    protected InputStream body;

    protected PostBulkDocsOptions() {
    }

    protected PostBulkDocsOptions(Builder builder) {
        Validator.notEmpty((String)builder.db, (String)"db cannot be empty");
        this.db = builder.db;
        this.bulkDocs = builder.bulkDocs;
        this.body = builder.body;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public BulkDocs bulkDocs() {
        return this.bulkDocs;
    }

    public InputStream body() {
        return this.body;
    }

    public static class Builder {
        private String db;
        private BulkDocs bulkDocs;
        private InputStream body;

        private Builder(PostBulkDocsOptions postBulkDocsOptions) {
            this.db = postBulkDocsOptions.db;
            this.bulkDocs = postBulkDocsOptions.bulkDocs;
            this.body = postBulkDocsOptions.body;
        }

        public Builder() {
        }

        public Builder(String db) {
            this.db = db;
        }

        public PostBulkDocsOptions build() {
            return new PostBulkDocsOptions(this);
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder bulkDocs(BulkDocs bulkDocs) {
            this.bulkDocs = bulkDocs;
            return this;
        }

        public Builder body(InputStream body) {
            this.body = body;
            return this;
        }

        public Builder body(File body) throws FileNotFoundException {
            this.body = new FileInputStream(body);
            return this;
        }
    }
}

