/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.cloudant.v1.model.Document;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class PutDocumentOptions
extends GenericModel {
    protected String db;
    protected String docId;
    protected Document document;
    protected InputStream body;
    protected String contentType;
    protected String ifMatch;
    protected String batch;
    protected Boolean newEdits;
    protected String rev;

    protected PutDocumentOptions(Builder builder) {
        Validator.notEmpty((String)builder.db, (String)"db cannot be empty");
        Validator.notEmpty((String)builder.docId, (String)"docId cannot be empty");
        this.db = builder.db;
        this.docId = builder.docId;
        this.document = builder.document;
        this.body = builder.body;
        this.contentType = builder.contentType;
        this.ifMatch = builder.ifMatch;
        this.batch = builder.batch;
        this.newEdits = builder.newEdits;
        this.rev = builder.rev;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public String docId() {
        return this.docId;
    }

    public Document document() {
        return this.document;
    }

    public InputStream body() {
        return this.body;
    }

    public String contentType() {
        return this.contentType;
    }

    public String ifMatch() {
        return this.ifMatch;
    }

    public String batch() {
        return this.batch;
    }

    public Boolean newEdits() {
        return this.newEdits;
    }

    public String rev() {
        return this.rev;
    }

    public static class Builder {
        private String db;
        private String docId;
        private Document document;
        private InputStream body;
        private String contentType;
        private String ifMatch;
        private String batch;
        private Boolean newEdits;
        private String rev;

        private Builder(PutDocumentOptions putDocumentOptions) {
            this.db = putDocumentOptions.db;
            this.docId = putDocumentOptions.docId;
            this.document = putDocumentOptions.document;
            this.body = putDocumentOptions.body;
            this.contentType = putDocumentOptions.contentType;
            this.ifMatch = putDocumentOptions.ifMatch;
            this.batch = putDocumentOptions.batch;
            this.newEdits = putDocumentOptions.newEdits;
            this.rev = putDocumentOptions.rev;
        }

        public Builder() {
        }

        public Builder(String db, String docId) {
            this.db = db;
            this.docId = docId;
        }

        public PutDocumentOptions build() {
            return new PutDocumentOptions(this);
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder docId(String docId) {
            this.docId = docId;
            return this;
        }

        public Builder document(Document document) {
            this.document = document;
            return this;
        }

        public Builder body(InputStream body) {
            this.body = body;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder batch(String batch) {
            this.batch = batch;
            return this;
        }

        public Builder newEdits(Boolean newEdits) {
            this.newEdits = newEdits;
            return this;
        }

        public Builder rev(String rev) {
            this.rev = rev;
            return this;
        }

        public Builder body(File body) throws FileNotFoundException {
            this.body = new FileInputStream(body);
            return this;
        }
    }

    public static interface Batch {
        public static final String OK = "ok";
    }
}

