/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.cloudant.v1.model.IndexDefinition;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.Map;

public class PostIndexOptions
extends GenericModel {
    protected String db;
    protected IndexDefinition index;
    protected String ddoc;
    protected IndexDefinition def;
    protected String name;
    protected Map<String, Object> partialFilterSelector;
    protected Boolean partitioned;
    protected String type;

    protected PostIndexOptions(Builder builder) {
        Validator.notEmpty((String)builder.db, (String)"db cannot be empty");
        Validator.notNull((Object)((Object)builder.index), (String)"index cannot be null");
        this.db = builder.db;
        this.index = builder.index;
        this.ddoc = builder.ddoc;
        this.def = builder.def;
        this.name = builder.name;
        this.partialFilterSelector = builder.partialFilterSelector;
        this.partitioned = builder.partitioned;
        this.type = builder.type;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public IndexDefinition index() {
        return this.index;
    }

    public String ddoc() {
        return this.ddoc;
    }

    public IndexDefinition def() {
        return this.def;
    }

    public String name() {
        return this.name;
    }

    public Map<String, Object> partialFilterSelector() {
        return this.partialFilterSelector;
    }

    public Boolean partitioned() {
        return this.partitioned;
    }

    public String type() {
        return this.type;
    }

    public static class Builder {
        private String db;
        private IndexDefinition index;
        private String ddoc;
        private IndexDefinition def;
        private String name;
        private Map<String, Object> partialFilterSelector;
        private Boolean partitioned;
        private String type;

        private Builder(PostIndexOptions postIndexOptions) {
            this.db = postIndexOptions.db;
            this.index = postIndexOptions.index;
            this.ddoc = postIndexOptions.ddoc;
            this.def = postIndexOptions.def;
            this.name = postIndexOptions.name;
            this.partialFilterSelector = postIndexOptions.partialFilterSelector;
            this.partitioned = postIndexOptions.partitioned;
            this.type = postIndexOptions.type;
        }

        public Builder() {
        }

        public Builder(String db, IndexDefinition index) {
            this.db = db;
            this.index = index;
        }

        public PostIndexOptions build() {
            return new PostIndexOptions(this);
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder index(IndexDefinition index) {
            this.index = index;
            return this;
        }

        public Builder ddoc(String ddoc) {
            this.ddoc = ddoc;
            return this;
        }

        public Builder def(IndexDefinition def) {
            this.def = def;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder partialFilterSelector(Map<String, Object> partialFilterSelector) {
            this.partialFilterSelector = partialFilterSelector;
            return this;
        }

        public Builder partitioned(Boolean partitioned) {
            this.partitioned = partitioned;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }
    }

    public static interface Type {
        public static final String JSON = "json";
        public static final String SPECIAL = "special";
        public static final String TEXT = "text";
    }
}

