/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class GetGeoOptions
extends GenericModel {
    protected String db;
    protected String ddoc;
    protected String index;
    protected String bbox;
    protected String bookmark;
    protected String format;
    protected String g;
    protected Boolean includeDocs;
    protected Double lat;
    protected Long limit;
    protected Double lon;
    protected Boolean nearest;
    protected Double radius;
    protected Double rangex;
    protected Double rangey;
    protected String relation;
    protected Long skip;
    protected String stale;

    protected GetGeoOptions(Builder builder) {
        Validator.notEmpty((String)builder.db, (String)"db cannot be empty");
        Validator.notEmpty((String)builder.ddoc, (String)"ddoc cannot be empty");
        Validator.notEmpty((String)builder.index, (String)"index cannot be empty");
        this.db = builder.db;
        this.ddoc = builder.ddoc;
        this.index = builder.index;
        this.bbox = builder.bbox;
        this.bookmark = builder.bookmark;
        this.format = builder.format;
        this.g = builder.g;
        this.includeDocs = builder.includeDocs;
        this.lat = builder.lat;
        this.limit = builder.limit;
        this.lon = builder.lon;
        this.nearest = builder.nearest;
        this.radius = builder.radius;
        this.rangex = builder.rangex;
        this.rangey = builder.rangey;
        this.relation = builder.relation;
        this.skip = builder.skip;
        this.stale = builder.stale;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public String ddoc() {
        return this.ddoc;
    }

    public String index() {
        return this.index;
    }

    public String bbox() {
        return this.bbox;
    }

    public String bookmark() {
        return this.bookmark;
    }

    public String format() {
        return this.format;
    }

    public String g() {
        return this.g;
    }

    public Boolean includeDocs() {
        return this.includeDocs;
    }

    public Double lat() {
        return this.lat;
    }

    public Long limit() {
        return this.limit;
    }

    public Double lon() {
        return this.lon;
    }

    public Boolean nearest() {
        return this.nearest;
    }

    public Double radius() {
        return this.radius;
    }

    public Double rangex() {
        return this.rangex;
    }

    public Double rangey() {
        return this.rangey;
    }

    public String relation() {
        return this.relation;
    }

    public Long skip() {
        return this.skip;
    }

    public String stale() {
        return this.stale;
    }

    public static class Builder {
        private String db;
        private String ddoc;
        private String index;
        private String bbox;
        private String bookmark;
        private String format;
        private String g;
        private Boolean includeDocs;
        private Double lat;
        private Long limit;
        private Double lon;
        private Boolean nearest;
        private Double radius;
        private Double rangex;
        private Double rangey;
        private String relation;
        private Long skip;
        private String stale;

        private Builder(GetGeoOptions getGeoOptions) {
            this.db = getGeoOptions.db;
            this.ddoc = getGeoOptions.ddoc;
            this.index = getGeoOptions.index;
            this.bbox = getGeoOptions.bbox;
            this.bookmark = getGeoOptions.bookmark;
            this.format = getGeoOptions.format;
            this.g = getGeoOptions.g;
            this.includeDocs = getGeoOptions.includeDocs;
            this.lat = getGeoOptions.lat;
            this.limit = getGeoOptions.limit;
            this.lon = getGeoOptions.lon;
            this.nearest = getGeoOptions.nearest;
            this.radius = getGeoOptions.radius;
            this.rangex = getGeoOptions.rangex;
            this.rangey = getGeoOptions.rangey;
            this.relation = getGeoOptions.relation;
            this.skip = getGeoOptions.skip;
            this.stale = getGeoOptions.stale;
        }

        public Builder() {
        }

        public Builder(String db, String ddoc, String index) {
            this.db = db;
            this.ddoc = ddoc;
            this.index = index;
        }

        public GetGeoOptions build() {
            return new GetGeoOptions(this);
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder ddoc(String ddoc) {
            this.ddoc = ddoc;
            return this;
        }

        public Builder index(String index) {
            this.index = index;
            return this;
        }

        public Builder bbox(String bbox) {
            this.bbox = bbox;
            return this;
        }

        public Builder bookmark(String bookmark) {
            this.bookmark = bookmark;
            return this;
        }

        public Builder format(String format) {
            this.format = format;
            return this;
        }

        public Builder g(String g) {
            this.g = g;
            return this;
        }

        public Builder includeDocs(Boolean includeDocs) {
            this.includeDocs = includeDocs;
            return this;
        }

        public Builder lat(Double lat) {
            this.lat = lat;
            return this;
        }

        public Builder limit(long limit) {
            this.limit = limit;
            return this;
        }

        public Builder lon(Double lon) {
            this.lon = lon;
            return this;
        }

        public Builder nearest(Boolean nearest) {
            this.nearest = nearest;
            return this;
        }

        public Builder radius(Double radius) {
            this.radius = radius;
            return this;
        }

        public Builder rangex(Double rangex) {
            this.rangex = rangex;
            return this;
        }

        public Builder rangey(Double rangey) {
            this.rangey = rangey;
            return this;
        }

        public Builder relation(String relation) {
            this.relation = relation;
            return this;
        }

        public Builder skip(long skip) {
            this.skip = skip;
            return this;
        }

        public Builder stale(String stale) {
            this.stale = stale;
            return this;
        }
    }

    public static interface Stale {
        public static final String OK = "ok";
    }

    public static interface Relation {
        public static final String CONTAINS = "contains";
        public static final String CONTAINS_PROPERLY = "contains_properly";
        public static final String COVERED_BY = "covered_by";
        public static final String COVERS = "covers";
        public static final String CROSSES = "crosses";
        public static final String DISJOINT = "disjoint";
        public static final String INTERSECTS = "intersects";
        public static final String OVERLAPS = "overlaps";
        public static final String TOUCHES = "touches";
        public static final String WITHIN = "within";
    }

    public static interface Format {
        public static final String LEGACY = "legacy";
        public static final String GEOJSON = "geojson";
        public static final String VIEW = "view";
        public static final String APPLICATION_VND_GEO_JSON = "application/vnd.geo+json";
    }
}

