/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.internal;

import com.ibm.cloud.cloudant.security.CouchDbSessionAuthenticator;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.util.CredentialUtils;
import java.util.Map;

public class DelegatingAuthenticatorFactory
extends ConfigBasedAuthenticatorFactory {
    private DelegatingAuthenticatorFactory() {
    }

    public static Authenticator getAuthenticator(String serviceName) {
        return DelegatingAuthenticatorFactory.getAuthenticator(serviceName, CredentialUtils.getServiceProperties((String)serviceName));
    }

    static Authenticator getAuthenticator(String serviceName, Map<String, String> serviceProperties) {
        if (serviceProperties != null && !serviceProperties.isEmpty() && "COUCHDB_SESSION".equalsIgnoreCase(serviceProperties.get("AUTH_TYPE"))) {
            return CouchDbSessionAuthenticator.newAuthenticator(serviceProperties.get("USERNAME"), serviceProperties.get("PASSWORD"));
        }
        return ConfigBasedAuthenticatorFactory.getAuthenticator((String)serviceName);
    }
}

