/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.xjcl;

import com.ibm.batch.container.xjcl.ControlElement;
import java.util.List;
import java.util.Properties;
import jsr352.batch.jsl.Batchlet;
import jsr352.batch.jsl.CheckpointAlgorithm;
import jsr352.batch.jsl.Chunk;
import jsr352.batch.jsl.End;
import jsr352.batch.jsl.ExceptionClassFilter;
import jsr352.batch.jsl.Fail;
import jsr352.batch.jsl.ItemProcessor;
import jsr352.batch.jsl.ItemReader;
import jsr352.batch.jsl.ItemWriter;
import jsr352.batch.jsl.JSLProperties;
import jsr352.batch.jsl.Listener;
import jsr352.batch.jsl.Listeners;
import jsr352.batch.jsl.Next;
import jsr352.batch.jsl.ObjectFactory;
import jsr352.batch.jsl.Property;
import jsr352.batch.jsl.Stop;

public class CloneUtility {
    private static ObjectFactory jslFactory = new ObjectFactory();

    public static Batchlet cloneBatchlet(Batchlet batchlet) {
        Batchlet newBatchlet = jslFactory.createBatchlet();
        newBatchlet.setRef(batchlet.getRef());
        newBatchlet.setProperties(CloneUtility.cloneJSLProperties(batchlet.getProperties()));
        return newBatchlet;
    }

    public static JSLProperties cloneJSLProperties(JSLProperties jslProps) {
        if (jslProps == null) {
            return null;
        }
        JSLProperties newJSLProps = jslFactory.createJSLProperties();
        newJSLProps.setPartition(jslProps.getPartition());
        for (Property jslProp : jslProps.getPropertyList()) {
            Property newProperty = jslFactory.createProperty();
            newProperty.setName(jslProp.getName());
            newProperty.setValue(jslProp.getValue());
            newJSLProps.getPropertyList().add(newProperty);
        }
        return newJSLProps;
    }

    public static void cloneControlElements(List<ControlElement> controlElements, List<ControlElement> newControlElements) {
        newControlElements.clear();
        for (ControlElement controlElement : controlElements) {
            if (controlElement instanceof End) {
                End endElement = (End)controlElement;
                End newEnd = jslFactory.createEnd();
                newEnd.setExitStatus(endElement.getExitStatus());
                newEnd.setOn(endElement.getOn());
                newControlElements.add(newEnd);
                continue;
            }
            if (controlElement instanceof Fail) {
                Fail failElement = (Fail)controlElement;
                Fail newFail = jslFactory.createFail();
                newFail.setExitStatus(failElement.getExitStatus());
                newFail.setOn(failElement.getOn());
                newControlElements.add(newFail);
                continue;
            }
            if (controlElement instanceof Next) {
                Next nextElement = (Next)controlElement;
                Next newNext = jslFactory.createNext();
                newNext.setOn(nextElement.getOn());
                newNext.setTo(nextElement.getTo());
                newControlElements.add(newNext);
                continue;
            }
            if (!(controlElement instanceof Stop)) continue;
            Stop stopElement = (Stop)controlElement;
            Stop newStop = jslFactory.createStop();
            newStop.setExitStatus(stopElement.getExitStatus());
            newStop.setOn(stopElement.getOn());
            newStop.setRestart(stopElement.getRestart());
            newControlElements.add(newStop);
        }
    }

    public static Listeners cloneListeners(Listeners listeners) {
        if (listeners == null) {
            return null;
        }
        Listeners newListeners = jslFactory.createListeners();
        for (Listener listener : listeners.getListenerList()) {
            Listener newListener = jslFactory.createListener();
            newListener.setRef(listener.getRef());
            newListener.setProperties(CloneUtility.cloneJSLProperties(listener.getProperties()));
        }
        return newListeners;
    }

    public static Chunk cloneChunk(Chunk chunk) {
        Chunk newChunk = jslFactory.createChunk();
        newChunk.setItemCount(chunk.getItemCount());
        newChunk.setRetryLimit(chunk.getRetryLimit());
        newChunk.setSkipLimit(chunk.getSkipLimit());
        newChunk.setTimeLimit(chunk.getTimeLimit());
        newChunk.setCheckpointPolicy(chunk.getCheckpointPolicy());
        newChunk.setCheckpointAlgorithm(CloneUtility.cloneCheckpointAlorithm(chunk.getCheckpointAlgorithm()));
        newChunk.setProcessor(CloneUtility.cloneItemProcessor(chunk.getProcessor()));
        newChunk.setReader(CloneUtility.cloneItemReader(chunk.getReader()));
        newChunk.setWriter(CloneUtility.cloneItemWriter(chunk.getWriter()));
        newChunk.setNoRollbackExceptionClasses(CloneUtility.cloneExceptionClassFilter(chunk.getNoRollbackExceptionClasses()));
        newChunk.setRetryableExceptionClasses(CloneUtility.cloneExceptionClassFilter(chunk.getRetryableExceptionClasses()));
        newChunk.setSkippableExceptionClasses(CloneUtility.cloneExceptionClassFilter(chunk.getSkippableExceptionClasses()));
        return newChunk;
    }

    private static CheckpointAlgorithm cloneCheckpointAlorithm(CheckpointAlgorithm checkpointAlgorithm) {
        if (checkpointAlgorithm == null) {
            return null;
        }
        CheckpointAlgorithm newCheckpointAlgorithm = jslFactory.createCheckpointAlgorithm();
        newCheckpointAlgorithm.setRef(checkpointAlgorithm.getRef());
        newCheckpointAlgorithm.setProperties(CloneUtility.cloneJSLProperties(checkpointAlgorithm.getProperties()));
        return newCheckpointAlgorithm;
    }

    private static ItemProcessor cloneItemProcessor(ItemProcessor itemProcessor) {
        if (itemProcessor == null) {
            return null;
        }
        ItemProcessor newItemProcessor = jslFactory.createItemProcessor();
        newItemProcessor.setRef(itemProcessor.getRef());
        newItemProcessor.setProperties(CloneUtility.cloneJSLProperties(itemProcessor.getProperties()));
        return newItemProcessor;
    }

    private static ItemReader cloneItemReader(ItemReader itemReader) {
        if (itemReader == null) {
            return null;
        }
        ItemReader newItemReader = jslFactory.createItemReader();
        newItemReader.setRef(itemReader.getRef());
        newItemReader.setProperties(CloneUtility.cloneJSLProperties(itemReader.getProperties()));
        return newItemReader;
    }

    private static ItemWriter cloneItemWriter(ItemWriter itemWriter) {
        ItemWriter newItemWriter = jslFactory.createItemWriter();
        newItemWriter.setRef(itemWriter.getRef());
        newItemWriter.setProperties(CloneUtility.cloneJSLProperties(itemWriter.getProperties()));
        return newItemWriter;
    }

    private static ExceptionClassFilter cloneExceptionClassFilter(ExceptionClassFilter exceptionClassFilter) {
        if (exceptionClassFilter == null) {
            return null;
        }
        ExceptionClassFilter newExceptionClassFilter = jslFactory.createExceptionClassFilter();
        for (ExceptionClassFilter.Include oldInclude : exceptionClassFilter.getIncludeList()) {
            newExceptionClassFilter.getIncludeList().add(CloneUtility.cloneExceptionClassFilterInclude(oldInclude));
        }
        for (ExceptionClassFilter.Exclude oldExclude : exceptionClassFilter.getExcludeList()) {
            newExceptionClassFilter.getExcludeList().add(CloneUtility.cloneExceptionClassFilterExclude(oldExclude));
        }
        return newExceptionClassFilter;
    }

    private static ExceptionClassFilter.Include cloneExceptionClassFilterInclude(ExceptionClassFilter.Include include) {
        if (include == null) {
            return null;
        }
        ExceptionClassFilter.Include newInclude = jslFactory.createExceptionClassFilterInclude();
        newInclude.setClazz(include.getClazz());
        return newInclude;
    }

    private static ExceptionClassFilter.Exclude cloneExceptionClassFilterExclude(ExceptionClassFilter.Exclude exclude) {
        if (exclude == null) {
            return null;
        }
        ExceptionClassFilter.Exclude newExclude = jslFactory.createExceptionClassFilterExclude();
        newExclude.setClazz(exclude.getClazz());
        return newExclude;
    }

    public static Properties jslPropertiesToJavaProperties(JSLProperties xmlProperties) {
        Properties props = new Properties();
        for (Property prop : xmlProperties.getPropertyList()) {
            props.setProperty(prop.getName(), prop.getValue());
        }
        return props;
    }
}

