/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.batch.container.impl;

import com.ibm.batch.container.artifact.proxy.CheckpointAlgorithmProxy;
import com.ibm.batch.container.artifact.proxy.ChunkListenerProxy;
import com.ibm.batch.container.artifact.proxy.InjectionReferences;
import com.ibm.batch.container.artifact.proxy.ItemProcessListenerProxy;
import com.ibm.batch.container.artifact.proxy.ItemProcessorProxy;
import com.ibm.batch.container.artifact.proxy.ItemReadListenerProxy;
import com.ibm.batch.container.artifact.proxy.ItemReaderProxy;
import com.ibm.batch.container.artifact.proxy.ItemWriteListenerProxy;
import com.ibm.batch.container.artifact.proxy.ItemWriterProxy;
import com.ibm.batch.container.artifact.proxy.ProxyFactory;
import com.ibm.batch.container.artifact.proxy.RetryProcessListenerProxy;
import com.ibm.batch.container.artifact.proxy.RetryReadListenerProxy;
import com.ibm.batch.container.artifact.proxy.RetryWriteListenerProxy;
import com.ibm.batch.container.artifact.proxy.SkipProcessListenerProxy;
import com.ibm.batch.container.artifact.proxy.SkipReadListenerProxy;
import com.ibm.batch.container.artifact.proxy.SkipWriteListenerProxy;
import com.ibm.batch.container.exception.BatchContainerRuntimeException;
import com.ibm.batch.container.exception.BatchContainerServiceException;
import com.ibm.batch.container.impl.ChunkHelper;
import com.ibm.batch.container.impl.RetryHandler;
import com.ibm.batch.container.impl.SingleThreadedStepControllerImpl;
import com.ibm.batch.container.impl.SkipHandler;
import com.ibm.batch.container.jobinstance.RuntimeJobExecutionImpl;
import com.ibm.batch.container.persistence.CheckpointAlgorithmFactory;
import com.ibm.batch.container.persistence.CheckpointData;
import com.ibm.batch.container.persistence.CheckpointDataKey;
import com.ibm.batch.container.persistence.CheckpointManager;
import com.ibm.batch.container.persistence.ItemCheckpointAlgorithm;
import com.ibm.batch.container.services.IPersistenceManagerService;
import com.ibm.batch.container.services.ServicesManager;
import com.ibm.batch.container.util.PartitionDataWrapper;
import com.ibm.batch.container.util.TCCLObjectInputStream;
import com.ibm.batch.container.validation.ArtifactValidationException;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.api.CheckpointAlgorithm;
import javax.batch.operations.JobOperator;
import javax.batch.runtime.Metric;
import jsr352.batch.jsl.Chunk;
import jsr352.batch.jsl.ItemProcessor;
import jsr352.batch.jsl.ItemReader;
import jsr352.batch.jsl.ItemWriter;
import jsr352.batch.jsl.Property;
import jsr352.batch.jsl.Step;

public class ChunkStepControllerImpl
extends SingleThreadedStepControllerImpl {
    private static final String sourceClass = ChunkStepControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private Chunk chunk = null;
    private ItemReaderProxy readerProxy = null;
    private ItemProcessorProxy processorProxy = null;
    private ItemWriterProxy writerProxy = null;
    private CheckpointAlgorithmProxy checkpointProxy = null;
    private CheckpointAlgorithm chkptAlg = null;
    private CheckpointManager checkpointManager;
    private ServicesManager servicesManager = ServicesManager.getInstance();
    private IPersistenceManagerService _persistenceManagerService = null;
    private SkipHandler skipHandler = null;
    CheckpointDataKey readerChkptDK;
    CheckpointDataKey writerChkptDK = null;
    CheckpointData readerChkptData = null;
    CheckpointData writerChkptData = null;
    List<ChunkListenerProxy> chunkListeners = null;
    List<SkipProcessListenerProxy> skipProcessListeners = null;
    List<SkipReadListenerProxy> skipReadListeners = null;
    List<SkipWriteListenerProxy> skipWriteListeners = null;
    List<RetryProcessListenerProxy> retryProcessListeners = null;
    List<RetryReadListenerProxy> retryReadListeners = null;
    List<RetryWriteListenerProxy> retryWriteListeners = null;
    List<ItemReadListenerProxy> itemReadListeners = null;
    List<ItemProcessListenerProxy> itemProcessListeners = null;
    List<ItemWriteListenerProxy> itemWriteListeners = null;
    private RetryHandler retryHandler;
    long readCount = 0L;
    long writeCount = 0L;
    long readSkipCount = 0L;
    long processSkipCount = 0L;
    long writeSkipCount = 0L;
    boolean rollbackRetry = false;

    public ChunkStepControllerImpl(RuntimeJobExecutionImpl jobExecutionImpl, Step step) {
        super(jobExecutionImpl, step);
    }

    private List<Object> readAndProcess(int chunkSize, ItemStatus theStatus) {
        logger.entering(sourceClass, "readAndProcess", new Object[]{chunkSize, theStatus});
        ArrayList<Object> chunkToWrite = new ArrayList<Object>();
        Object itemRead = null;
        Object itemProcessed = null;
        int readProcessedCount = 0;
        do {
            ItemStatus status = new ItemStatus();
            itemRead = this.readItem(status);
            if (status.isRollback()) {
                theStatus.setRollback(true);
                this.stepContext.getMetric(Metric.MetricName.ROLLBACKCOUNT).incValue();
                break;
            }
            if (!status.isSkipped() && !status.isFinished()) {
                itemProcessed = this.processItem(itemRead, status);
                if (status.isRollback()) {
                    theStatus.setRollback(true);
                    this.stepContext.getMetric(Metric.MetricName.ROLLBACKCOUNT).incValue();
                    break;
                }
                if (!status.isSkipped() && !status.isFiltered()) {
                    chunkToWrite.add(itemProcessed);
                    ++readProcessedCount;
                }
            }
            theStatus.setFinished(status.isFinished());
            theStatus.setCheckPointed(this.checkpointManager.ApplyCheckPointPolicy());
            if (!this.stepContext.getBatchStatus().equals((Object)JobOperator.BatchStatus.STOPPING)) continue;
            theStatus.setFinished(true);
        } while (readProcessedCount != chunkSize && !theStatus.isCheckPointed() && !theStatus.isFinished());
        logger.exiting(sourceClass, "readAndProcess", chunkToWrite);
        return chunkToWrite;
    }

    private Object readItem(ItemStatus status) {
        logger.entering(sourceClass, "readItem", status);
        Object itemRead = null;
        try {
            for (ItemReadListenerProxy readListenerProxy : this.itemReadListeners) {
                readListenerProxy.beforeRead();
            }
            itemRead = this.readerProxy.readItem();
            for (ItemReadListenerProxy readListenerProxy : this.itemReadListeners) {
                readListenerProxy.afterRead(itemRead);
            }
            status.setFinished(itemRead == null);
            if (!status.isFinished()) {
                this.stepContext.getMetric(Metric.MetricName.READCOUNT).incValue();
            }
        }
        catch (Exception e) {
            if (!this.rollbackRetry) {
                if (this.retryReadException(e)) {
                    if (!this.retryHandler.isRollbackException(e)) {
                        itemRead = this.readItem(status);
                    } else {
                        status.setRollback(true);
                        this.rollbackRetry = true;
                        this.stepContext.getMetric(Metric.MetricName.ROLLBACKCOUNT).incValue();
                    }
                }
                if (this.skipReadException(e)) {
                    status.setSkipped(true);
                    this.stepContext.getMetric(Metric.MetricName.READSKIPCOUNT).incValue();
                }
                throw new BatchContainerRuntimeException(e);
            }
            if (this.skipReadException(e)) {
                status.setSkipped(true);
                this.stepContext.getMetric(Metric.MetricName.READSKIPCOUNT).incValue();
            }
            if (this.retryReadException(e)) {
                if (!this.retryHandler.isRollbackException(e)) {
                    itemRead = this.readItem(status);
                } else {
                    status.setRollback(true);
                    this.stepContext.getMetric(Metric.MetricName.ROLLBACKCOUNT).incValue();
                }
            }
            throw new BatchContainerRuntimeException(e);
        }
        catch (Throwable e) {
            throw new BatchContainerRuntimeException(e);
        }
        logger.exiting(sourceClass, "readItem", itemRead);
        return itemRead;
    }

    private Object processItem(Object itemRead, ItemStatus status) {
        logger.entering(sourceClass, "processItem", new Object[]{itemRead, status});
        Object processedItem = null;
        try {
            for (ItemProcessListenerProxy processListenerProxy : this.itemProcessListeners) {
                processListenerProxy.beforeProcess(itemRead);
            }
            processedItem = this.processorProxy.processItem(itemRead);
            if (processedItem == null) {
                this.stepContext.getMetric(Metric.MetricName.FILTERCOUNT).incValue();
                status.setFiltered(true);
            }
            for (ItemProcessListenerProxy processListenerProxy : this.itemProcessListeners) {
                processListenerProxy.afterProcess(itemRead, processedItem);
            }
        }
        catch (Exception e) {
            if (!this.rollbackRetry) {
                if (this.retryProcessException(e, itemRead)) {
                    if (!this.retryHandler.isRollbackException(e)) {
                        for (ItemProcessListenerProxy processListenerProxy : this.itemProcessListeners) {
                            processListenerProxy.beforeProcess(itemRead);
                        }
                        processedItem = this.processItem(itemRead, status);
                        if (processedItem == null) {
                            this.stepContext.getMetric(Metric.MetricName.FILTERCOUNT).incValue();
                            status.setFiltered(true);
                        }
                        for (ItemProcessListenerProxy processListenerProxy : this.itemProcessListeners) {
                            processListenerProxy.afterProcess(itemRead, processedItem);
                        }
                    } else {
                        status.setRollback(true);
                        this.rollbackRetry = true;
                        this.stepContext.getMetric(Metric.MetricName.ROLLBACKCOUNT).incValue();
                    }
                }
                if (this.skipProcessException(e, itemRead)) {
                    status.setSkipped(true);
                    this.stepContext.getMetric(Metric.MetricName.PROCESSSKIPCOUNT).incValue();
                }
                throw new BatchContainerRuntimeException(e);
            }
            if (this.skipProcessException(e, itemRead)) {
                status.setSkipped(true);
                this.stepContext.getMetric(Metric.MetricName.PROCESSSKIPCOUNT).incValue();
            }
            if (this.retryProcessException(e, itemRead)) {
                if (!this.retryHandler.isRollbackException(e)) {
                    for (ItemProcessListenerProxy processListenerProxy : this.itemProcessListeners) {
                        processListenerProxy.beforeProcess(itemRead);
                    }
                    processedItem = this.processItem(itemRead, status);
                    if (processedItem == null) {
                        this.stepContext.getMetric(Metric.MetricName.FILTERCOUNT).incValue();
                        status.setFiltered(true);
                    }
                    for (ItemProcessListenerProxy processListenerProxy : this.itemProcessListeners) {
                        processListenerProxy.afterProcess(itemRead, processedItem);
                    }
                } else {
                    status.setRollback(true);
                    this.rollbackRetry = true;
                    this.stepContext.getMetric(Metric.MetricName.ROLLBACKCOUNT).incValue();
                }
            }
            throw new BatchContainerRuntimeException(e);
        }
        catch (Throwable e) {
            throw new BatchContainerRuntimeException(e);
        }
        logger.exiting(sourceClass, "processItem", processedItem);
        return processedItem;
    }

    private void writeChunk(List<Object> theChunk, ItemStatus status) {
        logger.entering(sourceClass, "writeChunk", theChunk);
        if (!theChunk.isEmpty()) {
            try {
                for (ItemWriteListenerProxy writeListenerProxy : this.itemWriteListeners) {
                    writeListenerProxy.beforeWrite(theChunk);
                }
                this.writerProxy.writeItems(theChunk);
                for (ItemWriteListenerProxy writeListenerProxy : this.itemWriteListeners) {
                    writeListenerProxy.afterWrite(theChunk);
                }
                this.stepContext.getMetric(Metric.MetricName.WRITECOUNT).incValueBy(theChunk.size());
            }
            catch (Exception e) {
                if (!this.rollbackRetry) {
                    if (this.retryWriteException(e, theChunk)) {
                        if (!this.retryHandler.isRollbackException(e)) {
                            this.writeChunk(theChunk, status);
                        } else {
                            this.rollbackRetry = true;
                            status.setRollback(true);
                            this.stepContext.getMetric(Metric.MetricName.ROLLBACKCOUNT).incValue();
                        }
                    }
                    if (this.skipWriteException(e, theChunk)) {
                        this.stepContext.getMetric(Metric.MetricName.WRITESKIPCOUNT).incValueBy(1L);
                    }
                    throw new BatchContainerRuntimeException(e);
                }
                if (this.skipWriteException(e, theChunk)) {
                    this.stepContext.getMetric(Metric.MetricName.WRITESKIPCOUNT).incValueBy(1L);
                }
                if (this.retryWriteException(e, theChunk)) {
                    if (!this.retryHandler.isRollbackException(e)) {
                        status.setRetry(true);
                        this.writeChunk(theChunk, status);
                    } else {
                        this.rollbackRetry = true;
                        status.setRollback(true);
                        this.stepContext.getMetric(Metric.MetricName.ROLLBACKCOUNT).incValue();
                    }
                }
                throw new BatchContainerRuntimeException(e);
            }
            catch (Throwable e) {
                throw new BatchContainerRuntimeException(e);
            }
        }
        logger.exiting(sourceClass, "writeChunk");
    }

    private void invokeChunk() throws Exception {
        logger.entering(sourceClass, "invokeChunk2");
        int itemCount = ChunkHelper.getItemCount(this.chunk);
        int timeInterval = ChunkHelper.getTimeLimit(this.chunk);
        ArrayList<Object> chunkToWrite = new ArrayList();
        boolean checkPointed = true;
        boolean rollback = false;
        try {
            this.transactionManager.begin();
            this.openReaderAndWriter();
            this.transactionManager.commit();
            while (true) {
                if (checkPointed || rollback) {
                    this.transactionManager.begin();
                    for (ChunkListenerProxy chunkProxy : this.chunkListeners) {
                        chunkProxy.beforeChunk();
                    }
                    if (rollback) {
                        this.positionReaderAtCheckpoint();
                        this.positionWriterAtCheckpoint();
                        this.checkpointManager = new CheckpointManager(this.readerProxy, this.writerProxy, this.getCheckpointAlgorithm(itemCount, timeInterval), this.jobExecutionImpl.getExecutionId(), this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId());
                    }
                }
                ItemStatus status = new ItemStatus();
                if (rollback) {
                    rollback = false;
                }
                chunkToWrite = this.readAndProcess(itemCount, status);
                if (status.isRollback()) {
                    itemCount = 1;
                    rollback = true;
                    this.transactionManager.rollback();
                    continue;
                }
                this.writeChunk(chunkToWrite, status);
                if (status.isRollback()) {
                    itemCount = 1;
                    rollback = true;
                    this.transactionManager.rollback();
                    continue;
                }
                checkPointed = status.isCheckPointed();
                if (!status.isCheckPointed() && !status.isFinished()) continue;
                this.checkpointManager.checkpoint();
                for (ChunkListenerProxy chunkProxy : this.chunkListeners) {
                    chunkProxy.afterChunk();
                }
                this.transactionManager.commit();
                if (this.collectorProxy != null) {
                    Externalizable data = this.collectorProxy.collectPartitionData();
                    if (this.analyzerQueue != null) {
                        PartitionDataWrapper dataWrapper = new PartitionDataWrapper();
                        dataWrapper.setCollectorData(data);
                        dataWrapper.setEventType(PartitionDataWrapper.PartitionEventType.ANALYZE_COLLECTOR_DATA);
                        this.analyzerQueue.add(dataWrapper);
                    }
                }
                if (status.isFinished()) {
                    this.transactionManager.begin();
                    this.readerProxy.close();
                    this.writerProxy.close();
                    this.transactionManager.commit();
                    this.stepContext.getMetric(Metric.MetricName.COMMITCOUNT).incValue();
                    break;
                }
                this.stepContext.getMetric(Metric.MetricName.COMMITCOUNT).incValue();
            }
        }
        catch (Throwable e) {
            for (ChunkListenerProxy chunkProxy : this.chunkListeners) {
                chunkProxy.onError();
            }
            this.transactionManager.rollback();
            logger.log(Level.SEVERE, "Failure in Read-Process-Write Loop, transaction is being rolled back.", e);
            throw new BatchContainerRuntimeException(e);
        }
        logger.exiting(sourceClass, "invokeChunk");
    }

    @Override
    protected void invokeCoreStep() throws BatchContainerServiceException {
        this.chunk = this.step.getChunk();
        this.initializeChunkArtifacts();
        try {
            this.invokeChunk();
        }
        catch (Exception re) {
            throw new BatchContainerServiceException(re);
        }
        finally {
            if (this.collectorProxy != null) {
                Externalizable data = this.collectorProxy.collectPartitionData();
                if (this.analyzerQueue != null) {
                    PartitionDataWrapper dataWrapper = new PartitionDataWrapper();
                    dataWrapper.setCollectorData(data);
                    dataWrapper.setEventType(PartitionDataWrapper.PartitionEventType.ANALYZE_COLLECTOR_DATA);
                    this.analyzerQueue.add(dataWrapper);
                }
            }
            if (this.analyzerQueue != null) {
                PartitionDataWrapper dataWrapper = new PartitionDataWrapper();
                dataWrapper.setBatchStatus(this.stepStatus.getBatchStatus());
                dataWrapper.setExitStatus(this.stepStatus.getExitStatus());
                dataWrapper.setEventType(PartitionDataWrapper.PartitionEventType.ANALYZE_STATUS);
                this.analyzerQueue.add(dataWrapper);
            }
        }
    }

    private CheckpointAlgorithm getCheckpointAlgorithm(int itemCount, int timeInterval) {
        Object alg = null;
        if (this.checkpointProxy.getCheckpointType() == "item") {
            alg = new ItemCheckpointAlgorithm();
            ((ItemCheckpointAlgorithm)alg).setThresholds(itemCount, timeInterval);
        } else {
            alg = this.checkpointProxy;
        }
        return alg;
    }

    private void initializeChunkArtifacts() {
        ItemReader itemReader;
        String sourceMethod = "initializeChunkArtifacts";
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(sourceClass, sourceMethod);
        }
        List<Property> itemReaderProps = (itemReader = this.chunk.getReader()).getProperties() == null ? null : itemReader.getProperties().getPropertyList();
        try {
            InjectionReferences injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, itemReaderProps);
            this.readerProxy = ProxyFactory.createItemReaderProxy(itemReader.getRef(), injectionRef);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Created ItemReaderProxy for " + itemReader.getRef());
            }
        }
        catch (ArtifactValidationException e) {
            throw new BatchContainerServiceException("Cannot create the ItemReader [" + itemReader.getRef() + "]", e);
        }
        ItemProcessor itemProcessor = this.chunk.getProcessor();
        List<Property> itemProcessorProps = itemProcessor.getProperties() == null ? null : itemProcessor.getProperties().getPropertyList();
        try {
            InjectionReferences injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, itemProcessorProps);
            this.processorProxy = ProxyFactory.createItemProcessorProxy(itemProcessor.getRef(), injectionRef);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Created ItemProcessorProxy for " + itemProcessor.getRef());
            }
        }
        catch (ArtifactValidationException e) {
            throw new BatchContainerServiceException("Cannot create the ItemProcessor [" + itemProcessor.getRef() + "]", e);
        }
        ItemWriter itemWriter = this.chunk.getWriter();
        List<Property> itemWriterProps = itemWriter.getProperties() == null ? null : itemWriter.getProperties().getPropertyList();
        try {
            InjectionReferences injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, itemWriterProps);
            this.writerProxy = ProxyFactory.createItemWriterProxy(itemWriter.getRef(), injectionRef);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Created ItemWriterProxy for " + itemWriter.getRef());
            }
        }
        catch (ArtifactValidationException e) {
            throw new BatchContainerServiceException("Cannot create the ItemWriter [" + itemWriter.getRef() + "]", e);
        }
        try {
            List<Property> propList = null;
            if (this.chunk.getCheckpointAlgorithm() != null) {
                propList = this.chunk.getCheckpointAlgorithm().getProperties() == null ? null : this.chunk.getCheckpointAlgorithm().getProperties().getPropertyList();
            }
            InjectionReferences injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, propList);
            this.checkpointProxy = CheckpointAlgorithmFactory.getCheckpointAlgorithmProxy(this.step, injectionRef);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Created CheckpointAlgorithmProxy for policy [" + this.chunk.getCheckpointPolicy() + "]");
            }
        }
        catch (ArtifactValidationException e) {
            throw new BatchContainerServiceException("Cannot create the CheckpointAlgorithm for policy [" + this.chunk.getCheckpointPolicy() + "]", e);
        }
        int itemCount = ChunkHelper.getItemCount(this.chunk);
        int timeInterval = ChunkHelper.getTimeLimit(this.chunk);
        InjectionReferences injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, null);
        this.chunkListeners = this.jobExecutionImpl.getListenerFactory().getChunkListeners(this.step, injectionRef);
        this.skipProcessListeners = this.jobExecutionImpl.getListenerFactory().getSkipProcessListeners(this.step, injectionRef);
        this.skipReadListeners = this.jobExecutionImpl.getListenerFactory().getSkipReadListeners(this.step, injectionRef);
        this.skipWriteListeners = this.jobExecutionImpl.getListenerFactory().getSkipWriteListeners(this.step, injectionRef);
        this.retryProcessListeners = this.jobExecutionImpl.getListenerFactory().getRetryProcessListeners(this.step, injectionRef);
        this.retryReadListeners = this.jobExecutionImpl.getListenerFactory().getRetryReadListeners(this.step, injectionRef);
        this.retryWriteListeners = this.jobExecutionImpl.getListenerFactory().getRetryWriteListeners(this.step, injectionRef);
        this.itemReadListeners = this.jobExecutionImpl.getListenerFactory().getItemReadListeners(this.step, injectionRef);
        this.itemProcessListeners = this.jobExecutionImpl.getListenerFactory().getItemProcessListeners(this.step, injectionRef);
        this.itemWriteListeners = this.jobExecutionImpl.getListenerFactory().getItemWriteListeners(this.step, injectionRef);
        if (this.checkpointProxy.getCheckpointType() == "item") {
            this.chkptAlg = new ItemCheckpointAlgorithm();
            ((ItemCheckpointAlgorithm)this.chkptAlg).setThresholds(itemCount, timeInterval);
        } else {
            this.chkptAlg = this.checkpointProxy;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Setting contexts for chunk artifacts");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Initialize checkpoint manager with item-count=" + itemCount);
        }
        logger.fine("Initialize checkpoint manager with time-interval=" + timeInterval);
        this.checkpointManager = new CheckpointManager(this.readerProxy, this.writerProxy, this.chkptAlg, this.jobExecutionImpl.getExecutionId(), this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId());
        this.skipHandler = new SkipHandler(this.chunk, this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId());
        this.skipHandler.addSkipProcessListener(this.skipProcessListeners);
        this.skipHandler.addSkipReadListener(this.skipReadListeners);
        this.skipHandler.addSkipWriteListener(this.skipWriteListeners);
        this.retryHandler = new RetryHandler(this.chunk, this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId());
        this.retryHandler.addRetryProcessListener(this.retryProcessListeners);
        this.retryHandler.addRetryReadListener(this.retryReadListeners);
        this.retryHandler.addRetryWriteListener(this.retryWriteListeners);
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(sourceClass, sourceMethod);
        }
    }

    private void openReaderAndWriter() {
        String sourceMethod;
        block13: {
            List data;
            block12: {
                sourceMethod = "openReaderAndWriter";
                if (logger.isLoggable(Level.FINE)) {
                    logger.entering(sourceClass, sourceMethod);
                }
                this._persistenceManagerService = (IPersistenceManagerService)this.servicesManager.getService(ServicesManager.ServiceType.PERSISTENCE_MANAGEMENT_SERVICE);
                this.readerChkptDK = new CheckpointDataKey(this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId(), "READER");
                data = this._persistenceManagerService.getData(2, this.readerChkptDK);
                try {
                    if (data.size() >= 1) {
                        this.readerChkptData = (CheckpointData)data.get(0);
                        byte[] readertoken = this.readerChkptData.getRestartToken();
                        ByteArrayInputStream readerChkptBA = new ByteArrayInputStream(readertoken);
                        TCCLObjectInputStream readerOIS = null;
                        try {
                            readerOIS = new TCCLObjectInputStream(readerChkptBA);
                            this.readerProxy.open((Externalizable)readerOIS.readObject());
                            readerOIS.close();
                            break block12;
                        }
                        catch (Exception ex) {
                            throw new BatchContainerServiceException("Cannot persist the checkpoint data for [" + this.step.getId() + "]", ex);
                        }
                    }
                    this.readerChkptData = null;
                    this.readerProxy.open(null);
                }
                catch (ClassCastException e) {
                    throw new IllegalStateException("Expected CheckpointData but found" + data.get(0));
                }
            }
            this.writerChkptDK = new CheckpointDataKey(this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId(), "WRITER");
            data = this._persistenceManagerService.getData(2, this.writerChkptDK);
            try {
                if (data.size() >= 1) {
                    this.writerChkptData = (CheckpointData)data.get(0);
                    byte[] writertoken = this.writerChkptData.getRestartToken();
                    ByteArrayInputStream writerChkptBA = new ByteArrayInputStream(writertoken);
                    TCCLObjectInputStream writerOIS = null;
                    try {
                        writerOIS = new TCCLObjectInputStream(writerChkptBA);
                        this.writerProxy.open((Externalizable)writerOIS.readObject());
                        writerOIS.close();
                        break block13;
                    }
                    catch (Exception ex) {
                        throw new BatchContainerServiceException("Cannot persist the checkpoint data for [" + this.step.getId() + "]", ex);
                    }
                }
                this.writerChkptData = null;
                this.writerProxy.open(null);
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Expected Checkpoint but found" + data.get(0));
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.exiting(sourceClass, sourceMethod);
        }
    }

    @Override
    public void stop() {
        this.stepContext.setBatchStatus(JobOperator.BatchStatus.STOPPING);
    }

    boolean skipReadException(Exception e) {
        try {
            this.skipHandler.handleExceptionRead(e);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    boolean retryReadException(Exception e) {
        try {
            this.retryHandler.handleExceptionRead(e);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    boolean skipProcessException(Exception e, Object record) {
        try {
            this.skipHandler.handleExceptionWithRecordProcess(e, record);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    boolean retryProcessException(Exception e, Object record) {
        try {
            this.retryHandler.handleExceptionProcess(e, record);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    boolean skipWriteException(Exception e, List<Object> chunkToWrite) {
        Object[] writeObjs = chunkToWrite.toArray();
        for (int i = 0; i < writeObjs.length; ++i) {
            try {
                this.skipHandler.handleExceptionWithRecordListWrite(e, chunkToWrite);
                continue;
            }
            catch (BatchContainerRuntimeException bcre) {
                return false;
            }
        }
        return true;
    }

    boolean retryWriteException(Exception e, List<Object> chunkToWrite) {
        try {
            this.retryHandler.handleExceptionWrite(e, chunkToWrite);
        }
        catch (BatchContainerRuntimeException bcre) {
            return false;
        }
        return true;
    }

    private void positionReaderAtCheckpoint() {
        block5: {
            this._persistenceManagerService = (IPersistenceManagerService)this.servicesManager.getService(ServicesManager.ServiceType.PERSISTENCE_MANAGEMENT_SERVICE);
            this.readerChkptDK = new CheckpointDataKey(this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId(), "READER");
            List data = this._persistenceManagerService.getData(2, this.readerChkptDK);
            CheckpointData readerData = null;
            try {
                if (data.size() >= 1) {
                    readerData = (CheckpointData)data.get(0);
                    byte[] readertoken = readerData.getRestartToken();
                    ByteArrayInputStream readerChkptBA = new ByteArrayInputStream(readertoken);
                    TCCLObjectInputStream readerOIS = null;
                    try {
                        readerOIS = new TCCLObjectInputStream(readerChkptBA);
                        this.readerProxy.open((Externalizable)readerOIS.readObject());
                        readerOIS.close();
                        break block5;
                    }
                    catch (Exception ex) {
                        throw new BatchContainerServiceException("Cannot persist the checkpoint data for [" + this.step.getId() + "]", ex);
                    }
                }
                readerData = null;
                this.readerProxy.open(null);
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Expected CheckpointData but found" + data.get(0));
            }
        }
    }

    private void positionWriterAtCheckpoint() {
        block5: {
            this._persistenceManagerService = (IPersistenceManagerService)this.servicesManager.getService(ServicesManager.ServiceType.PERSISTENCE_MANAGEMENT_SERVICE);
            this.writerChkptDK = new CheckpointDataKey(this.jobExecutionImpl.getJobInstance().getInstanceId(), this.step.getId(), "WRITER");
            List data = this._persistenceManagerService.getData(2, this.writerChkptDK);
            CheckpointData writerData = null;
            try {
                if (data.size() >= 1) {
                    writerData = (CheckpointData)data.get(0);
                    byte[] writertoken = writerData.getRestartToken();
                    ByteArrayInputStream writerChkptBA = new ByteArrayInputStream(writertoken);
                    TCCLObjectInputStream writerOIS = null;
                    try {
                        writerOIS = new TCCLObjectInputStream(writerChkptBA);
                        this.writerProxy.open((Externalizable)writerOIS.readObject());
                        writerOIS.close();
                        break block5;
                    }
                    catch (Exception ex) {
                        throw new BatchContainerServiceException("Cannot persist the checkpoint data for [" + this.step.getId() + "]", ex);
                    }
                }
                writerData = null;
                this.writerProxy.open(null);
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Expected CheckpointData but found" + data.get(0));
            }
        }
    }

    private class ItemStatus {
        private boolean skipped = false;
        private boolean filtered = false;
        private boolean finished = false;
        private boolean checkPointed = false;
        private boolean retry = false;
        private boolean rollback = false;

        private ItemStatus() {
        }

        public boolean isSkipped() {
            return this.skipped;
        }

        public void setSkipped(boolean skipped) {
            this.skipped = skipped;
        }

        public boolean isFiltered() {
            return this.filtered;
        }

        public void setFiltered(boolean filtered) {
            this.filtered = filtered;
        }

        public boolean isCheckPointed() {
            return this.checkPointed;
        }

        public void setCheckPointed(boolean checkPointed) {
            this.checkPointed = checkPointed;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public void setFinished(boolean finished) {
            this.finished = finished;
        }

        public boolean isRetry() {
            return this.retry;
        }

        public void setRetry(boolean retry) {
            this.retry = retry;
        }

        public boolean isRollback() {
            return this.rollback;
        }

        public void setRollback(boolean rollback) {
            this.rollback = rollback;
        }
    }
}

